/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.BosAttachmentRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.utils.ProxyUtils;

public class ContractTplService {
    private static final Log LOGGER = LogFactory.getLog(ContractTplService.class);

    public static boolean checkTplIsPreData(long templateId) {
        return 1555680070209637376L == templateId;
    }

    public static Object getKeyMap(Long futureVid) {
        Object keyMap = null;
        try {
            keyMap = HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSKeywordMappingService", (String)"selectKeywordMapping", (Object[])new Object[]{"hlcm_contracttemplate", futureVid});
        }
        catch (Exception exception) {
            LOGGER.error("IHRCSKeywordMappingService_selectKeywordMapping_error");
        }
        return keyMap;
    }

    public static void contractpreview(IFormView view, IDataModel dataModel) {
        String attachmentUrl = ContractTplService.getPreviewOrDownloadUrl(dataModel.getEntryCurrentRowIndex("entryentity"), false, view, dataModel);
        String previewRealUrl = ProxyUtils.attachmentPreviewRealUrl(attachmentUrl);
        view.openUrl(previewRealUrl);
    }

    public static void contractdownload(IFormView view, IDataModel dataModel) {
        String attachmentUrl = ContractTplService.getPreviewOrDownloadUrl(dataModel.getEntryCurrentRowIndex("entryentity"), true, view, dataModel);
        if (HRStringUtils.isEmpty((String)attachmentUrl)) {
            return;
        }
        String downloadRealUrl = ProxyUtils.attachmentDownloadRealUrl(attachmentUrl);
        IClientViewProxy clientViewProxy = (IClientViewProxy)dataModel.getService(IClientViewProxy.class);
        clientViewProxy.addAction("download", (Object)downloadRealUrl);
    }

    public static String getPreviewOrDownloadUrl(int index, boolean downloadOrPreview, IFormView view, IDataModel dataModel) {
        DynamicObject entryEntity = dataModel.getEntryRowEntity("entryentity", index);
        FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
        String url = attachFileServiceExt.getRealPath(entryEntity.getString("presigndocurl"));
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
            return null;
        }
        if (HRStringUtils.isEmpty((String)url)) {
            boolean isContractFileForm;
            String entityId = view.getEntityId();
            DynamicObject dataEntity = dataModel.getDataEntity();
            boolean bl = isContractFileForm = HRStringUtils.equals((String)entityId, (String)"hlcm_contract") || HRStringUtils.equals((String)entityId, (String)"hlcm_contractfileemp") || HRStringUtils.equals((String)entityId, (String)"hlcm_contractfileother");
            if (isContractFileForm) {
                DynamicObject signBill = ContractSignApplyRepository.getInstance().getByContractNumber(null, dataEntity.getString("number"));
                if (HRObjectUtils.isEmpty((Object)signBill)) {
                    DynamicObject contract = HLCMCommonRepository.queryDynamicObjectByPk("hlcm_contract", null, dataEntity.getPkValue());
                    DynamicObject contractTemplateEntry = (DynamicObject)contract.getDynamicObjectCollection("entryentity").get(index);
                    DynamicObject contractTemplateHis = CommonRepository.queryById("hlcm_contracttemplatehis", null, contractTemplateEntry.getDynamicObject("texthis").getLong("id"));
                    DynamicObject[] attachments = BosAttachmentRepository.getInstance().queryByInterId(contractTemplateHis.getString("id"), "hlcm_contracttemplatehis", "ffileid");
                    url = Stream.of(attachments).findFirst().map(attachment -> attachment.getString("ffileid")).orElse(null);
                } else {
                    url = ISignManageService.getInstance().replaceKeywordGenContract(signBill, (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(index), false, false);
                }
            } else {
                DynamicObject signBill = CommonRepository.queryById("hlcm_contractapplybase", null, dataEntity.getLong("id"));
                url = ISignManageService.getInstance().replaceKeywordGenContract(signBill, (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(index), false, false);
            }
            url = attachFileServiceExt.getRealPath(url);
            if (HRStringUtils.isEmpty((String)url)) {
                return null;
            }
            try {
                url = URLEncoder.encode(url, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return downloadOrPreview ? UrlService.getAttachmentFullUrl((String)url) : UrlService.getAttachmentPreviewUrl((String)url);
    }
}

