/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.UserRoleCache;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.DimValueResult;

public class PermissionService {
    private static final Log LOGGER = LogFactory.getLog(PermissionService.class);

    public static boolean isSuperUser() {
        long currUserId = RequestContext.get().getCurrUserId();
        return SuperUserCache.isSuperUser((long)currUserId);
    }

    public static boolean hasPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"11", (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            return true;
        }
        List orgIds = result.getHasPermOrgs();
        return orgIds.contains(orgId);
    }

    public static HasPermOrgResult getPermOrgs(String appId, String entityNum, String permItemId) {
        return PermissionService.getPermOrgs("11", appId, entityNum, permItemId);
    }

    public static HasPermOrgResult getPermOrgs(String orgViewType, String appId, String entityNum, String permItemId) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static HasPermOrgResult getPermOrgs(String appId, String entityNum) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"11", (String)appId, (String)entityNum, (String)"47150e89000000ac");
    }

    public static HasPermOrgResult getPermOrgs(Long userId, String appId, String entityNum) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"11", (String)appId, (String)entityNum, (String)"47150e89000000ac");
        return result;
    }

    public static List<Long> getUserHasPermOrgs(Long userId, boolean mustQueryAll) {
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)mustQueryAll);
        if (result.hasAllOrgPerm()) {
            return null;
        }
        return result.getHasPermOrgs();
    }

    public static String getAppIdByFormId(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp", (QFilter[])filters);
        String bizAppId = unitRelForm.getString("bizapp");
        return bizAppId;
    }

    public static boolean hasViewPermission(String appId, String entityNum) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.hasViewPermission((long)userId, (String)appId, (String)entityNum);
    }

    private static Set<Long> getSetFromDimValue(DimValueResult dimValueResult) {
        if (dimValueResult != null) {
            if (dimValueResult.isAll()) {
                return null;
            }
            Set dimValueIds = dimValueResult.getDimValueIds();
            if (dimValueIds == null || dimValueIds.isEmpty()) {
                return new HashSet<Long>();
            }
            return dimValueIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
        }
        LOGGER.error("call IHRCSBizDataPermissionService.getEntityDimValue API error!");
        return new HashSet<Long>();
    }

    public static QFilter getBaseDataFilterByOrgPerm(String appId, String permEntityNumber, String permItemId, String baseDataEntity) {
        HasPermOrgResult permOrgResult = PermissionService.getPermOrgs(appId, permEntityNumber, permItemId);
        if (permOrgResult.hasAllOrgPerm()) {
            return null;
        }
        List orgIds = permOrgResult.getHasPermOrgs();
        return PermissionService.getBaseDataFilterByOrgIds(baseDataEntity, orgIds);
    }

    public static QFilter getBaseDataFilterByOrgIds(String baseDataEntity, List<Long> orgIds) {
        StringBuilder orgStrs = new StringBuilder();
        ArrayList orgIDList = Lists.newArrayList();
        for (Long orgId : orgIds) {
            orgStrs.append(orgId).append(',');
            String key = baseDataEntity + orgId;
            if (BaseDataCtrlCache.hasBaseDataUseRange((String)key)) continue;
            orgIDList.add(orgId);
        }
        String orgStr = orgStrs.toString();
        orgStr = orgStr.length() > 0 ? orgStr.substring(0, orgStr.length() - 1) : "0";
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)baseDataEntity);
        if (orgIDList.size() > 0) {
            int num = 30;
            for (int index = 0; index < orgIDList.size(); index += num) {
                if (index + num > orgIDList.size()) {
                    BaseDataServiceHelper.refreshBaseDataUseRange((String)baseDataEntity, orgIDList.subList(index, orgIDList.size()));
                    continue;
                }
                BaseDataServiceHelper.refreshBaseDataUseRange((String)baseDataEntity, orgIDList.subList(index, index + num));
            }
        }
        String baseDataTableName = dt.getAlias();
        String bsaeDataUseRangeTableName = baseDataTableName + "_U";
        String useRangeAliasName1 = "ur" + DB.genLongId((String)"ur");
        QFilter orgFilter = QFilter.joinSQL((String)baseDataEntity, (String)("inner join " + bsaeDataUseRangeTableName + " " + useRangeAliasName1 + " on " + useRangeAliasName1 + ".fdataid = " + baseDataEntity + ".fid and " + useRangeAliasName1 + ".fuseorgid in (" + orgStr + ")"), (Object[])new Object[0]);
        return orgFilter;
    }

    public static QFilter getBaseDataFilter(String entityID, Long orgID) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)orgID);
    }

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgID, boolean isRemoveDup) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, orgID, (boolean)isRemoveDup);
    }

    public static List<Long> getUserHasPermOrgs(String entityName) {
        if (PermissionService.isSuperUser()) {
            return null;
        }
        HasPermOrgResult hasPermOrgResult = PermissionService.getPermOrgs("hlcm", entityName);
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return null;
        }
        List userHasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        if (CollectionUtils.isEmpty((Collection)userHasPermOrgs)) {
            return new ArrayList<Long>();
        }
        return userHasPermOrgs;
    }

    public static List<Long> getUserHasPermOrgs(boolean mustQueryAll) {
        if (PermissionService.isSuperUser()) {
            return null;
        }
        long userId = RequestContext.get().getCurrUserId();
        return PermissionService.getUserHasPermOrgs(userId, mustQueryAll);
    }

    public static QFilter getBaseDataFilterByOrg(String entityName, boolean isRemoveDup) {
        List<Long> userHasPermOrgs = PermissionService.getUserHasPermOrgs(false);
        if (CollectionUtils.isEmpty(userHasPermOrgs)) {
            return null;
        }
        String entityType = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        return PermissionService.getBaseDataFilter(entityType, userHasPermOrgs, isRemoveDup);
    }

    public static DynamicObject[] getBaseDataDys(String entityName, boolean isRemoveDup) {
        List<Long> userHasPermOrgs = PermissionService.getUserHasPermOrgs(false);
        if (userHasPermOrgs == null) {
            return null;
        }
        if (userHasPermOrgs.size() == 0) {
            return new DynamicObject[0];
        }
        String entityType = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter baseDataFilterByOrg = PermissionService.getBaseDataFilter(entityType, userHasPermOrgs, isRemoveDup);
        QFilter enableFilter = new QFilter("status", "=", (Object)"C");
        if (baseDataFilterByOrg != null) {
            return helper.query(new QFilter[]{baseDataFilterByOrg, enableFilter});
        }
        return null;
    }

    public static List<Long> getUsersByRoleID(String roleId) {
        return UserRoleCache.getUsersByRoleId((String)roleId);
    }
}

