/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.LabrelStatusprd;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PersonService {
    private static final Log logger = LogFactory.getLog(PersonService.class);
    private static final PersonService PERSON_SERVICE = new PersonService();
    private static final String LABRELSTATUSPRD_ID = "labrelstatusprd_id";
    private static final String PERSON_ID = "person_id";

    private PersonService() {
    }

    public static PersonService getInstance() {
        return PERSON_SERVICE;
    }

    @Deprecated
    public Long[] getOnJobPersonIds(List personIds) {
        logger.info("personIds:{}", (Object)JSON.toJSONString((Object)personIds));
        List response = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{"1", personIds});
        ArrayList responseList = new ArrayList(response.size());
        ArrayList<Long> resultPersonIds = new ArrayList<Long>(response.size());
        for (Map result : response) {
            HashMap personMap = new HashMap(2);
            Object labrelStatusPrd = result.get(LABRELSTATUSPRD_ID);
            Object personId = result.get(PERSON_ID);
            personMap.put(LABRELSTATUSPRD_ID, labrelStatusPrd);
            personMap.put(PERSON_ID, personId);
            responseList.add(personMap);
            if (!Objects.equals(labrelStatusPrd, LabrelStatusprd.EMPING.getCombKey()) || !Objects.nonNull(personId)) continue;
            resultPersonIds.add(Long.parseLong(personId.toString()));
        }
        logger.info("person Service return data:{},personIds|{}", (Object)JSON.toJSONString(responseList), (Object)JSON.toJSONString(resultPersonIds));
        return resultPersonIds.toArray(new Long[0]);
    }

    public Long[] getOnJobEmployeeIds(List<Long> employeeIds) {
        logger.info("employeeIds:{}", (Object)JSON.toJSONString(employeeIds));
        Map empAndStatusMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployeeStatus", (Object[])new Object[]{employeeIds});
        ArrayList resultEmployeeIds = new ArrayList(empAndStatusMap.size());
        empAndStatusMap.forEach((employeeId, statusDy) -> {
            if (statusDy != null && LabrelStatusprd.EMPING.getCombKey().equals(statusDy.getLong(LABRELSTATUSPRD_ID))) {
                resultEmployeeIds.add(employeeId);
            }
        });
        return resultEmployeeIds.toArray(new Long[0]);
    }

    public Long getPersonIdByUserId(Long userId) {
        logger.info("userId:{}", (Object)userId);
        HashMap personInfoMap = (HashMap)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
        if (personInfoMap == null) {
            return 0L;
        }
        HashMap data = (HashMap)personInfoMap.get("data");
        if (data == null) {
            return 0L;
        }
        Long personId = (Long)data.get("person");
        logger.info("personInfoMap:{}", (Object)personInfoMap);
        return personId;
    }

    public void updateLaborRelRecord(DynamicObject ... contractFiles) {
        if (contractFiles == null || contractFiles.length == 0) {
            return;
        }
        List files = Arrays.stream(contractFiles).filter(contractFile -> !HRStringUtils.equals((String)contractFile.getString("contractstatus"), (String)ContractStatusEnum.STATUS_PENDING.getCode())).filter(contractFile -> !HRStringUtils.equals((String)contractFile.getString("protocoltype"), (String)ProtocolTypeEnum.FS.getCombKey())).map(contractFile -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("personid", contractFile.getLong("person.id"));
            data.put("orgid", contractFile.getLong("ermanorg.id"));
            data.put("lawentityid", contractFile.get("actualsigncompanyhis.lawentity.id"));
            data.put("startdate", contractFile.get("startdate"));
            return data;
        }).collect(Collectors.toList());
        if (files.isEmpty()) {
            return;
        }
        try (TXHandle txHandle = TX.notSupported();){
            logger.info("updateLaborRelRecord req:{}", (Object)files.toString());
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"updateLaborRelRecord", (Object[])new Object[]{files});
            logger.info("updateLaborRelRecord res:{}", (Object)result.toString());
        }
        catch (Exception exp) {
            logger.error("updateLaborRelRecord error", (Throwable)exp);
        }
    }

    public Optional<Pair<Long, Long>> getLatestErManFileInfo(Long personId, Long posTypeId) {
        logger.info("getLatestErManFileInfo param personId|{},posTypeId|{}", (Object)personId, (Object)posTypeId);
        try {
            Map response = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfileByPersonIdAndPostype", (Object[])new Object[]{personId, null, posTypeId});
            ImmutablePair erManFileInfoPair = ImmutablePair.of(response.get("id"), response.get("org_id"));
            logger.info("getLatestErManFileInfo response erManFileInfoPair|{}", (Object)erManFileInfoPair);
            return Optional.of(erManFileInfoPair);
        }
        catch (Exception exp) {
            logger.error("getLatestErManFileInfo error", (Throwable)exp);
            return Optional.empty();
        }
    }
}

