/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.setcontractstatus.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.setcontractstatus.abs.SetContractStatusBaseService;
import kd.hr.hlcm.common.enums.ContractStatusEnum;

public class InvalidContractService
extends SetContractStatusBaseService {
    private static final Log LOGGER = LogFactory.getLog(InvalidContractService.class);

    @Override
    protected DynamicObject[] getToSetContract() {
        QFilter statusFilter = new QFilter("contractstatus", "=", (Object)"1");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter signStatusAndInitStatusFilter = new QFilter("signstatus", "=", (Object)"1").or("initbatch", "!=", (Object)0L);
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        QFilter endDateFilter = new QFilter("enddate", "<", (Object)today);
        QFilter planEndDateFilter = new QFilter("planenddate", "<", (Object)today);
        QFilter actualEndDateFilter = new QFilter("actualenddate", "<", (Object)today);
        QFilter dateFilter = endDateFilter.or(planEndDateFilter).or(actualEndDateFilter);
        DynamicObject[] toInvalidContracts = this.contractHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, versionFilter, dateFilter, signStatusAndInitStatusFilter});
        LOGGER.info("contracts count|{} wait for invalid", (Object)toInvalidContracts.length);
        return toInvalidContracts;
    }

    @Override
    protected List<DynamicObject> executeContractStatus(DynamicObject[] contracts) {
        ArrayList<String> invalidContractNos = new ArrayList<String>(contracts.length);
        ArrayList<DynamicObject> hisDyns = new ArrayList<DynamicObject>(contracts.length);
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        for (DynamicObject contract : contracts) {
            Date actualEndDate = contract.getDate("actualenddate");
            Date planEndDate = contract.getDate("planenddate");
            Date endDate = contract.getDate("enddate");
            Date actualEndDateCal = null;
            actualEndDateCal = Objects.nonNull(actualEndDate) ? actualEndDate : (Objects.nonNull(planEndDate) ? planEndDate : endDate);
            String number = contract.getString("number");
            LOGGER.info("contract number|{} actualEndDateCal|{}", (Object)number, (Object)HRDateTimeUtils.formatDate((Date)actualEndDateCal));
            if (Objects.isNull(actualEndDateCal) || today.before(actualEndDateCal)) continue;
            DynamicObject contractHis = this.contractHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)contract, (DynamicObject)contractHis);
            contractHis.set("bsed", (Object)HRDateTimeUtils.getNextDay((Date)actualEndDateCal));
            contractHis.set("actualenddate", (Object)actualEndDateCal);
            contractHis.set("contractstatus", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
            if (HRStringUtils.equals((String)contract.getString("signstatus"), (String)"1")) {
                contractHis.set("signstatus", (Object)"5");
                String cancelReason = ResManager.loadKDString((String)"\u5230\u671f\u7ec8\u6b62", (String)"InvalidContractService_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
                contractHis.set("cancelreason", (Object)cancelReason);
            }
            invalidContractNos.add(number);
            hisDyns.add(contractHis);
        }
        if (!hisDyns.isEmpty()) {
            LOGGER.info("the contracts need to invalid number is {}", (Object)String.join((CharSequence)",", invalidContractNos));
        }
        return hisDyns;
    }
}

