/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignModeEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class BatchSignDataUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(BatchSignDataUpgradeTask.class);
    private static final String NUMBER_PREFIX = "HRFSXY";
    private static final int GEN_COUNT = 200;
    private static final int TOP = 100;
    private static final String SERIAL = "%05d";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("BatchSignDataUpgradeTask#execute_start");
        this.upgradeData();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("4BF98H7655+Z");
        scheduleManager.disableSchedule("4BF9TWNWDO2V");
        LOGGER.info("BatchSignDataUpgradeTask#execute_start");
    }

    private void upgradeData() {
        DynamicObject[] dyArray;
        HashMap<String, Object> recordMap = new HashMap<String, Object>(200);
        long id = 0L;
        Set<Long> conTypeSet = this.getConTypeSet();
        while ((dyArray = BatchSignDataUpgradeTask.queryContractDys(id)) != null && dyArray.length > 0) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(dyArray.length);
            Map<String, String> statusMap = this.getStatusMap(dyArray);
            for (DynamicObject bill : dyArray) {
                try {
                    String cStatus;
                    if (bill.get("contractemplate") != null) continue;
                    String createTime = HRDateTimeUtils.format((Date)bill.getDate("createtime"), (String)"yyyyMMdd");
                    DynamicObjectCollection dys = bill.getDynamicObjectCollection("entryentity");
                    String eStatus = statusMap.get(this.getActivityStatusKey(SignTabEnum.E_ESIGN.getActivityId(), bill.getLong("id")));
                    if (eStatus != null) {
                        bill.set("empsignstatus", (Object)eStatus);
                    }
                    if ((cStatus = statusMap.get(this.getActivityStatusKey(SignTabEnum.E_CSIGN.getActivityId(), bill.getLong("id")))) != null) {
                        bill.set("compsignstatus", (Object)cStatus);
                    }
                    if (SignWayEnum.ELECTRONIC.getCombKey().equals(bill.getString("signway"))) {
                        bill.set("signmode", (Object)SignModeEnum.BATCH_ONETASK.getValue());
                    }
                    for (DynamicObject entryRow : dys) {
                        long typeId;
                        DynamicObject contracttemplate;
                        if (eStatus != null) {
                            entryRow.set("entryempsignstatus", (Object)eStatus);
                        }
                        if (cStatus != null) {
                            entryRow.set("entrycompsignstatus", (Object)cStatus);
                        }
                        if ((contracttemplate = entryRow.getDynamicObject("texthis")) != null) {
                            typeId = contracttemplate.getLong("contracttype.id");
                            entryRow.set("entrycontracttype", contracttemplate.get("contracttype"));
                        } else {
                            typeId = entryRow.getLong("entrycontracttype.id");
                        }
                        if (conTypeSet.contains(typeId)) {
                            bill.set("contractemplate", entryRow.get("contracttemplate"));
                            bill.set("contractemplatehis", (Object)contracttemplate);
                            bill.set("signfile", entryRow.get("presigndocurl"));
                            bill.set("contractremark", entryRow.get("remark"));
                            bill.set("issignother", (Object)(dys.size() > 1 ? 1 : 0));
                            entryRow.set("entrycontractnumber", bill.get("contractnumber"));
                            entryRow.set("entryperiodtype", bill.get("periodtype"));
                            entryRow.set("entryperiod", bill.get("period"));
                            entryRow.set("entryperiodunit", bill.get("periodunit"));
                            entryRow.set("entrystartdate", bill.get("startdate"));
                            entryRow.set("entryenddate", bill.get("enddate"));
                            entryRow.set("seq", (Object)0);
                            continue;
                        }
                        String number = this.getNumber(recordMap, createTime);
                        if (number == null) {
                            throw new KDBizException("get number ex");
                        }
                        entryRow.set("entrycontractnumber", (Object)number);
                        entryRow.set("entrystartdate", bill.get("startdate"));
                        if (entryRow.getInt("seq") > 0) continue;
                        entryRow.set("seq", (Object)1);
                    }
                    updateList.add(bill);
                }
                catch (Exception ex) {
                    LOGGER.warn("handlePageMeta_ex, data id:", (Object)ex, (Object)bill.getLong("id"));
                }
            }
            if (!updateList.isEmpty()) {
                CommonRepository.updateDynamicObject("hlcm_contractapplybase", updateList.toArray(new DynamicObject[0]));
            }
            if (dyArray.length < 100) break;
            id = dyArray[dyArray.length - 1].getLong("id");
        }
    }

    private Set<Long> getConTypeSet() {
        QFilter typeFilter = new QFilter("group", "in", (Object)ContractTypeCatEnum.CON.getPkId());
        DynamicObject[] dys = CommonRepository.query("hbss_contracttypes", "", new QFilter[]{typeFilter});
        if (dys != null && dys.length > 0) {
            return Arrays.stream(dys).map(val -> val.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }

    private Map<String, String> getStatusMap(DynamicObject[] signBills) {
        QFilter actityQ;
        QFilter idQ;
        DynamicObject[] activities;
        List ids = Arrays.stream(signBills).filter(val -> SignWayEnum.ELECTRONIC.getCombKey().equals(val.getString("signway"))).map(val -> val.getLong("id")).collect(Collectors.toList());
        if (!ids.isEmpty() && (activities = CommonRepository.query("hlcm_activity", "signapply,processstatus,activity", new QFilter[]{idQ = new QFilter("signapply", "in", ids), actityQ = new QFilter("activity", "=", (Object)SignTabEnum.E_ESIGN.getActivityId()).or("activity", "=", (Object)SignTabEnum.E_CSIGN.getActivityId())})) != null && activities.length > 0) {
            HashMap<String, String> statusMap = new HashMap<String, String>(activities.length);
            for (DynamicObject activity : activities) {
                String status = activity.getString("processstatus");
                if ("2".equals(status)) {
                    status = "3";
                } else if ("3".equals(status)) {
                    status = "0";
                } else if ("4".equals(status)) {
                    status = "2";
                }
                statusMap.put(this.getActivityStatusKey(activity.getLong("activity.id"), activity.getLong("signapply.id")), status);
            }
            return statusMap;
        }
        return new HashMap<String, String>(0);
    }

    private String getActivityStatusKey(Long activityId, Long applyId) {
        return activityId + "-" + applyId;
    }

    private static DynamicObject[] queryContractDys(long id) {
        QFilter typeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey());
        QFilter idFArray = new QFilter("id", ">", (Object)id);
        return CommonRepository.queryDynamicObjectByFilters("hlcm_contractapplybase", "signway,signmode,createtime,empsignstatus,compsignstatus,contractemplate,contractremark,issignother,contractnumber,periodtype,period,periodunit,startdate,enddate,contractemplatehis,signfile,entryentity.entrycontracttype,entryentity.entryempsignstatus,entryentity.entrycompsignstatus,entryentity.contracttemplate,entryentity.texthis,entryentity.presigndocurl,entryentity.seq,entryentity.remark,entryentity.entrycontractnumber,entryentity.entryperiodtype,entryentity.entryperiod,entryentity.entryperiodunit,entryentity.entrystartdate,entryentity.entryenddate", new QFilter[]{typeFilter, idFArray}, "id", 100);
    }

    private String getNumber(Map<String, Object> recordMap, String createTime) {
        List<String> numbers = (List<String>)recordMap.get("number" + createTime);
        if (numbers == null || numbers.isEmpty()) {
            numbers = this.genNumbers(recordMap, createTime);
        }
        return numbers.remove(0);
    }

    private List<String> genNumbers(Map<String, Object> recordMap, String createTime) {
        int curMaxSerialNo;
        Integer serialNo = (Integer)recordMap.get(createTime);
        if (serialNo == null) {
            serialNo = 1;
        }
        ArrayList<String> numbers = new ArrayList<String>(200);
        do {
            curMaxSerialNo = serialNo + 200;
            while (serialNo < curMaxSerialNo) {
                numbers.add("HRFSXY-" + createTime + "-" + String.format(SERIAL, serialNo));
                Integer n = serialNo;
                Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
            }
            this.removeRepeatNumber(numbers);
        } while (numbers.size() <= 0 && curMaxSerialNo <= 99999);
        recordMap.put(createTime, curMaxSerialNo);
        recordMap.put("number" + createTime, numbers);
        return numbers;
    }

    private void removeRepeatNumber(List<String> numbers) {
        QFilter initStatusFilter;
        QFilter contractNumberFilter;
        QFilter versionFilter;
        DynamicObject[] sourceArray;
        QFilter applyFilter = new QFilter("contractnumber", "in", numbers);
        applyFilter.or("entryentity.entrycontractnumber", "in", numbers);
        DynamicObject[] dyArray = CommonRepository.query("hlcm_contractapplybase", "contractnumber,entryentity.entrycontractnumber", new QFilter[]{applyFilter});
        HashSet<String> dbNumers = new HashSet<String>(numbers.size());
        if (dyArray != null && dyArray.length > 0) {
            for (DynamicObject applyDy : dyArray) {
                dbNumers.add(applyDy.getString("contractnumber"));
                DynamicObjectCollection datas = applyDy.getDynamicObjectCollection("entryentity");
                if (datas == null || datas.isEmpty()) continue;
                for (DynamicObject data : datas) {
                    dbNumers.add(data.getString("entrycontractnumber"));
                }
            }
        }
        if ((sourceArray = CommonRepository.query("hlcm_contractsource", "number", new QFilter[]{versionFilter = new QFilter("iscurrentversion", "=", (Object)"1"), contractNumberFilter = new QFilter("number", "in", numbers), initStatusFilter = new QFilter("initstatus", "=", (Object)"2")})) != null && sourceArray.length > 0) {
            dbNumers.addAll(Arrays.stream(sourceArray).map(val -> val.getString("number")).collect(Collectors.toSet()));
        }
        if (dbNumers.size() > 0) {
            numbers.removeIf(val -> dbNumers.contains(val));
        }
    }
}

