/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.sync.ISyncPersonInfoService;

public class HLCMSyncFieldTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HLCMSyncFieldTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("start to sync personInfo");
        long start = System.currentTimeMillis();
        QFilter filter = this.parseFilter(map);
        ISyncPersonInfoService.getInstance().syncPersonInfoByFilter(filter);
        LOGGER.info("sync personInfo success cost|{}ms", (Object)(System.currentTimeMillis() - start));
    }

    private QFilter parseFilter(Map<String, Object> map) {
        String[] split;
        String empNumber = (String)map.get("empnumber");
        String createTimeRange = (String)map.get("createtime_range");
        if (HRStringUtils.isEmpty((String)empNumber) && HRStringUtils.isEmpty((String)createTimeRange)) {
            throw new KDBizException("empnumber and createtime_range  must not all empty");
        }
        ArrayList filters = Lists.newArrayListWithCapacity((int)2);
        if (HRStringUtils.isNotEmpty((String)empNumber)) {
            split = HRStringUtils.split((String)HRStringUtils.trim((String)empNumber), (int)44);
            Set empNumbers = Stream.of(split).filter(HRStringUtils::isNotEmpty).map(HRStringUtils::trim).collect(Collectors.toSet());
            filters.add(new QFilter("empnumber", "in", empNumbers));
        }
        if (HRStringUtils.isNotEmpty((String)createTimeRange)) {
            split = HRStringUtils.split((String)createTimeRange, (String)"~");
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"split length is not 2");
            try {
                Date startCreateDate = HRDateTimeUtils.parseDate((String)HRStringUtils.trim((String)split[0]));
                Date endCreateDate = HRDateTimeUtils.parseDate((String)HRStringUtils.trim((String)split[1]));
                filters.add(new QFilter("createtime", ">=", (Object)startCreateDate).and(new QFilter("createtime", "<=", (Object)endCreateDate)));
            }
            catch (ParseException exp) {
                LOGGER.error("ParseException", (Throwable)exp);
                throw new KDBizException("param createtime_range format error");
            }
        }
        return (QFilter)filters.stream().reduce((f1, f2) -> f1.or(f2)).orElseThrow(() -> new KDBizException("unknow error"));
    }
}

