/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.task.RepairErmanAndEmployeeService;
import org.apache.commons.io.IOUtils;

public class RepairHAOSFieldTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RepairHAOSFieldTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.executeHisHAOS();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3P7KN7/8QV3O");
        scheduleManager.disableSchedule("3P7KU=6SX+5J");
    }

    private void executeHisHAOS() {
        Optional<RuntimeException> billException = this.tryExecute(() -> this.repairSignBillHAOS(10000));
        Optional<RuntimeException> contractException = this.tryExecute(() -> this.repairContractHAOS(10000));
        Optional<RuntimeException> commonVarException = this.tryExecute(this::preInsertCommonVar);
        Optional<RuntimeException> employeeVarException = this.tryExecute(() -> new RepairErmanAndEmployeeService().executeRepair());
        ArrayList exceptionList = Lists.newArrayListWithCapacity((int)4);
        exceptionList.add(billException);
        exceptionList.add(contractException);
        exceptionList.add(commonVarException);
        exceptionList.add(employeeVarException);
        Optional<RuntimeException> first = exceptionList.stream().filter(Optional::isPresent).map(Optional::get).findFirst();
        if (first.isPresent()) {
            throw first.get();
        }
    }

    private Optional<RuntimeException> tryExecute(ExecuteMethod executeMethod) {
        try {
            executeMethod.execute();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            LOGGER.error("execute error", (Throwable)e);
            return Optional.of(e);
        }
    }

    private void repairSignBillHAOS(int batch) {
        boolean isLast = false;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        long start = 0L;
        while (!isLast) {
            QFilter filter = new QFilter("curcompany", "=", (Object)0L).or("curdept", "=", (Object)0L);
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            DynamicObject[] queryResult = serviceHelper.query("stdpostionhis.id,signedcompanyhis.id,departmenthis.id,postionhis.id,job.id,curcompany.id,curdept.id,curpostion.id,curstdpostion.id,curjob.id", new QFilter[]{filter, idFilter}, "id", batch);
            if (queryResult.length == 0) {
                return;
            }
            if (queryResult.length < batch) {
                isLast = true;
            }
            start = queryResult[queryResult.length - 1].getLong("id");
            HashSet stdPositionHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet companyHisHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet deptHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet positionHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet jobHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            for (DynamicObject dy : queryResult) {
                companyHisHisSet.add(dy.getLong("signedcompanyhis.id"));
                deptHisSet.add(dy.getLong("departmenthis.id"));
                positionHisSet.add(dy.getLong("postionhis.id"));
                stdPositionHisSet.add(dy.getLong("stdpostionhis.id"));
                jobHisSet.add(dy.getLong("job.id"));
            }
            Map<Long, Long> companyHisMap = this.getBoidMap("haos_adminorghr", companyHisHisSet);
            Map<Long, Long> deptHisMap = this.getBoidMap("haos_adminorghr", deptHisSet);
            Map<Long, Long> positionHisMap = this.getBoidMap("hbpm_positionhr", positionHisSet);
            Map<Long, Long> stdPositionHisMap = this.getBoidMap("hbpm_stposition", stdPositionHisSet);
            Map<Long, Long> jobHisMap = this.getBoidMap("hbjm_jobhr", jobHisSet);
            for (DynamicObject dy : queryResult) {
                this.setBoId("curcompany", "signedcompanyhis.id", companyHisMap, dy);
                this.setBoId("curdept", "departmenthis.id", deptHisMap, dy);
                this.setBoId("curpostion", "postionhis.id", positionHisMap, dy);
                this.setBoId("curstdpostion", "stdpostionhis.id", stdPositionHisMap, dy);
                this.setBoId("curjob", "job.id", jobHisMap, dy);
            }
            serviceHelper.save(queryResult);
        }
    }

    private void repairContractHAOS(int batch) {
        boolean isLast = false;
        long start = 0L;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contractsource");
        QFilter filter = new QFilter("curcompany", "=", (Object)0L).or("curdept", "=", (Object)0L);
        while (!isLast) {
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            DynamicObject[] queryResult = serviceHelper.query("stdposition.id,signedcompany.id,department.id,position.id,job.id,curcompany.id,curdept.id,curpostion.id,curstdpostion.id,curjob.id", new QFilter[]{filter, idFilter}, "id", batch);
            if (queryResult.length == 0) {
                return;
            }
            if (queryResult.length < batch) {
                isLast = true;
            }
            start = queryResult[queryResult.length - 1].getLong("id");
            HashSet stdPositionHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet companyHisHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet deptHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet positionHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            HashSet jobHisSet = Sets.newHashSetWithExpectedSize((int)batch);
            for (DynamicObject dy : queryResult) {
                companyHisHisSet.add(dy.getLong("signedcompany.id"));
                deptHisSet.add(dy.getLong("department.id"));
                positionHisSet.add(dy.getLong("position.id"));
                stdPositionHisSet.add(dy.getLong("stdposition.id"));
                jobHisSet.add(dy.getLong("job.id"));
            }
            Map<Long, Long> companyHisMap = this.getBoidMap("haos_adminorghr", companyHisHisSet);
            Map<Long, Long> deptHisMap = this.getBoidMap("haos_adminorghr", deptHisSet);
            Map<Long, Long> positionHisMap = this.getBoidMap("hbpm_positionhr", positionHisSet);
            Map<Long, Long> stdPositionHisMap = this.getBoidMap("hbpm_stposition", stdPositionHisSet);
            Map<Long, Long> jobHisMap = this.getBoidMap("hbjm_jobhr", jobHisSet);
            for (DynamicObject dy : queryResult) {
                this.setBoId("curcompany", "signedcompany.id", companyHisMap, dy);
                this.setBoId("curdept", "department.id", deptHisMap, dy);
                this.setBoId("curpostion", "position.id", positionHisMap, dy);
                this.setBoId("curstdpostion", "stdposition.id", stdPositionHisMap, dy);
                this.setBoId("curjob", "job.id", jobHisMap, dy);
            }
            serviceHelper.save(queryResult);
        }
    }

    private Map<Long, Long> getBoidMap(String entityName, Set<Long> hisSet) {
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper(entityName);
        DynamicObject[] result = adminHelper.query("boid", new QFilter[]{new QFilter("id", "in", hisSet)});
        return Stream.of(result).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("boid")));
    }

    private void setBoId(String curFieldName, String hisFieldName, Map<Long, Long> hisMap, DynamicObject dy) {
        long hisFieldValue = dy.getLong(hisFieldName);
        if (hisFieldValue == 0L) {
            return;
        }
        Long boId = hisMap.get(hisFieldValue);
        if (boId == null || boId == 0L) {
            return;
        }
        dy.set(curFieldName, (Object)boId);
    }

    private void preInsertCommonVar() {
        QFilter filter = new QFilter("contempid", "!=", (Object)1555680070209637376L);
        boolean exist = HLCMCommonRepository.exist("hrcs_keywordmapping", filter);
        if (exist) {
            return;
        }
        try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/commonvariable.sql");){
            String sql = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
            boolean flag = DB.execute((DBRoute)DBRoute.of((String)"hmp"), (String)sql);
            if (!flag) {
                LOGGER.error("error execute sql");
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @FunctionalInterface
    static interface ExecuteMethod {
        public void execute();
    }
}

