/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hlcm.business.setcontractstatus.ContractStatusTaskExecutor;
import kd.hr.hlcm.business.setcontractstatus.impl.InvalidContractService;
import kd.hr.hlcm.common.enums.ContractStatusEnum;

public class RepairHisData
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RepairHisData.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contract");
        QFilter contractStatusFilter = new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] invalidContracts = contractHelper.query("boid", new QFilter[]{contractStatusFilter, versionFilter});
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
        for (DynamicObject invalidContract : invalidContracts) {
            Optional<DataVersion> first;
            long boId = invalidContract.getLong("boid");
            QFilter boFilter = new QFilter("boid", "=", (Object)boId);
            DynamicObject[] rows = contractHelper.query("signstatus,cancelreason,iscurrentversion,contractstatus", new QFilter[]{boFilter});
            ArrayList<DataVersion> list = new ArrayList<DataVersion>(10);
            for (DynamicObject row : rows) {
                DataVersion dataVersion = new DataVersion();
                dataVersion.setSignStatus(row.getString("signstatus"));
                dataVersion.setCancelReason(row.getString("cancelreason"));
                dataVersion.setIsCurrentVersion(row.getString("iscurrentversion"));
                dataVersion.setContractStatus(row.getString("contractstatus"));
                list.add(dataVersion);
            }
            if (list.size() != 2 || !(first = list.stream().filter(data -> "1".equals(data.getContractStatus()) && "0".equals(data.getIsCurrentVersion())).findFirst()).isPresent()) continue;
            DataVersion dataVersion = first.get();
            paramsList.add(new Object[]{dataVersion.getSignStatus(), dataVersion.getCancelReason(), "1", boId, "-1", "1"});
        }
        if (!paramsList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"hrb.hlcm"), (String)"update t_hlcm_contract set fsignstatus=?,fcancelreason=?,factualenddate=null,fcontractstatus=? where fboid=? and fcontractstatus=? and fiscurrentversion=?", paramsList);
        }
        new ContractStatusTaskExecutor().addTask(new InvalidContractService()).ExecuteTask();
        HRBaseServiceHelper schServiceHelper = new HRBaseServiceHelper("sch_schedule");
        DynamicObject schDy = schServiceHelper.queryOne("status", (Object)"2PAW3//W+893");
        schDy.set("status", (Object)"0");
        schServiceHelper.updateOne(schDy);
    }

    static class DataVersion {
        private String isCurrentVersion;
        private String cancelReason;
        private String signStatus;
        private String contractStatus;

        DataVersion() {
        }

        public String getIsCurrentVersion() {
            return this.isCurrentVersion;
        }

        public void setIsCurrentVersion(String isCurrentVersion) {
            this.isCurrentVersion = isCurrentVersion;
        }

        public String getCancelReason() {
            return this.cancelReason;
        }

        public void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        public String getSignStatus() {
            return this.signStatus;
        }

        public void setSignStatus(String signStatus) {
            this.signStatus = signStatus;
        }

        public String getContractStatus() {
            return this.contractStatus;
        }

        public void setContractStatus(String contractStatus) {
            this.contractStatus = contractStatus;
        }
    }
}

