/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task.contractstatus;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hlcm.business.setcontractstatus.ContractStatusTaskExecutor;
import kd.hr.hlcm.business.setcontractstatus.impl.EffectContractService;
import kd.hr.hlcm.business.setcontractstatus.impl.InvalidContractService;

public class ContractStatusTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ContractStatusTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("the.ContractStatusTask.is.going..");
        try (TXHandle txHandle = TX.required();){
            new ContractStatusTaskExecutor().addTask(new EffectContractService()).addTask(new InvalidContractService()).ExecuteTask();
        }
        this.refreshTextHis("t_hlcm_signtext");
        this.refreshTextHis("t_hlcm_contracttext");
    }

    private void refreshTextHis(String tableName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        String dbRouteKey = serviceHelper.generateEmptyDynamicObject().getDataEntityType().getDBRouteKey();
        String sql = String.format(Locale.ROOT, "select p.fvid,s.fentryid  from %s s join t_hlcm_contracttemp p on s.ftextid =p.fid  where ftexthisid =0", tableName);
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        DataSet dataSet = DB.queryDataSet((String)"refresh_text_his", (DBRoute)dbRoute, (String)sql);
        ArrayList paramsList = Lists.newArrayListWithCapacity((int)10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            paramsList.add(new Object[]{row.getLong("fvid"), row.getLong("fentryid")});
        }
        if (paramsList.isEmpty()) {
            return;
        }
        String updateSql = String.format(Locale.ROOT, "update %s set ftexthisid=? where fentryid=? and ftexthisid=0", tableName);
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, (List)paramsList);
    }
}

