/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task.sign;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.ActivityTaskStatusEnum;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class AutoArchiveTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AutoArchiveTask.class);
    private static final List<String> CHECK_FORM_IDS = Lists.newArrayList((Object[])new String[]{SignTabEnum.E_CHECK.getSourceListFormId(), SignTabEnum.P_CHECK.getSourceListFormId()});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("AutoArchiveTask Begin");
        int compSignDays = Optional.ofNullable(map.get("compSignDays")).map(Object::toString).map(Integer::valueOf).orElse(3);
        DynamicObject[] activities = CommonRepository.query("hlcm_activity", "signapply.id", new QFilter[]{new QFilter("activity.bizobj.number", "in", CHECK_FORM_IDS), new QFilter("processstatus", "=", (Object)ProcessStatusEnum.PENDING.getValue()), new QFilter("activityins.taskstatus", "in", (Object)ActivityTaskStatusEnum.getToDoStatusList()), new QFilter("activityins.createtime", "<", (Object)HRDateTimeUtils.addDay((Date)new Date(), (long)(-compSignDays)))});
        if (activities.length == 0) {
            return;
        }
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, Arrays.stream(activities).map(activity -> activity.getLong("signapply.id")).collect(Collectors.toList()));
        if (signBills.length == 0) {
            return;
        }
        HashMap<Long, Long> successMap = new HashMap<Long, Long>(signBills.length);
        try (TXHandle txHandle = TX.required();){
            for (DynamicObject signBill2 : signBills) {
                Long activityInsId = signBill2.getLong("activityins.id");
                String result = ISignManageService.getInstance().confirmArchiveHandler(signBill2);
                if (!HRStringUtils.isEmpty((String)result)) continue;
                successMap.put(signBill2.getLong("id"), activityInsId);
            }
        }
        List<DynamicObject> successDys = Arrays.stream(signBills).filter(signBill -> successMap.containsKey(signBill.getLong("id"))).collect(Collectors.toList());
        int size = successDys.size();
        ArrayList<Long> eActivityInsIds = new ArrayList<Long>(size);
        ArrayList<Long> pActivityInsIds = new ArrayList<Long>(size);
        successDys.forEach(signBill -> {
            Long activityInsId = (Long)successMap.get(signBill.getLong("id"));
            String signWay = signBill.getString("signway");
            if (HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey())) {
                eActivityInsIds.add(activityInsId);
            } else {
                pActivityInsIds.add(activityInsId);
            }
        });
        ISignManageService.getInstance().archiveAfterTransaction(successDys.toArray(new DynamicObject[0]));
        ISignActivity.getInstance().batchAssignAndConsentTask(eActivityInsIds, SignTabEnum.E_CHECK);
        ISignActivity.getInstance().batchAssignAndConsentTask(pActivityInsIds, SignTabEnum.P_CHECK);
        LOGGER.info("AutoArchiveTask End");
    }
}

