/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.business.utils.ContractSignUtils;

public class CancelProtocolValidUtils {
    private static final Log LOGGER = LogFactory.getLog(CancelProtocolValidUtils.class);
    private static final CancelProtocolValidUtils CANCEL_PROTOCOL_VALID_UTILS = new CancelProtocolValidUtils();

    public static CancelProtocolValidUtils getInstance() {
        return CANCEL_PROTOCOL_VALID_UTILS;
    }

    public String isKDCloudSignValidate(DynamicObject applyObject) {
        DynamicObjectCollection dynamicObjectCollection = applyObject.getDynamicObjectCollection("oldcontract.entryentity");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
        if (HRStringUtils.equals((String)"1", (String)applyObject.getString("signway")) && !HRObjectUtils.isEmpty((Object)dynamicObject)) {
            String contractNo = dynamicObject.getString("contractno");
            LOGGER.info("CancelProtocolValidUtils.isKDCloudSignValidate={}", (Object)contractNo);
            boolean kdCloudSign = IHRCSService.getInstance().isKDCloudSign(contractNo);
            if (kdCloudSign) {
                return ResManager.loadKDString((String)"\u539f\u6587\u4ef6\u7535\u5b50\u7b7e\u7f72\u7248\u672c\u8f83\u4f4e\uff0c\u6682\u4e0d\u652f\u6301\u7ebf\u4e0a\u89e3\u9664\u5408\u540c\u3002\u5f53\u524d\u60a8\u53ef\u901a\u8fc7\u7eb8\u8d28\u7b7e\u7f72\u7684\u65b9\u5f0f\u7b7e\u8ba2\u89e3\u9664\u534f\u8bae\u3002", (String)"CancelProtocolValidUtils_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public String isInitOrPaperDataValidate(DynamicObject applyObject) {
        long initBatch = applyObject.getLong("oldcontract.initbatch");
        String oldSignWay = applyObject.getString("oldcontract.signway");
        if (initBatch != 0L && "1".equals(applyObject.getString("signway")) || "2".equals(oldSignWay) && "1".equals(applyObject.getString("signway"))) {
            return ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u975e\u521d\u59cb\u5316\uff0c\u4e14\u4e3a\u7535\u5b50\u7b7e\u7f72\u7684\u6570\u636e\u7535\u5b50\u7b7e\u7f72\u89e3\u9664\u534f\u8bae\u3002\u5f53\u524d\u60a8\u53ef\u901a\u8fc7\u7eb8\u8d28\u7b7e\u7f72\u7684\u65b9\u5f0f\u7b7e\u8ba2\u89e3\u9664\u534f\u8bae\u3002", (String)"CancelProtocolValidUtils_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String CancelProtocolMustInputValidate(DynamicObject applyObject) {
        boolean issignprotocol = applyObject.getBoolean("issignprotocol");
        Date signeddate = applyObject.getDate("signeddate");
        DynamicObject contracttype = applyObject.getDynamicObject("contracttype");
        String signway = applyObject.getString("signway");
        DynamicObjectCollection entryentity = applyObject.getDynamicObjectCollection("entryentity");
        if (issignprotocol) {
            DynamicObject dynamicObject;
            DynamicObject contracttemplate;
            if (entryentity.size() == 0) {
                return ResManager.loadKDString((String)"\u60a8\u5df2\u5f00\u542f\u201c\u662f\u5426\u7b7e\u8ba2\u89e3\u9664\u534f\u8bae\u201d\u5f00\u5173\uff0c\u8bf7\u6309\u8981\u6c42\u7ef4\u62a4\u201c\u5f85\u65b0\u7b7e\u7684\u52b3\u52a8\u5408\u540c\u89e3\u9664\u534f\u8bae\u201d\u533a\u57df\u4e2d\u7684\u4fe1\u606f\u3002", (String)"CancelProtocolValidUtils_8", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            if (signeddate == null || HRObjectUtils.isEmpty((Object)contracttype) || HRStringUtils.isEmpty((String)signway) || "1".equals(signway) && entryentity.size() != 1 || entryentity.size() > 1) {
                return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u9700\u7b7e\u8ba2\u89e3\u9664\u534f\u8bae\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u9884\u8ba1\u7b7e\u8ba2\u65e5\u671f\u3001\u5408\u540c\u7c7b\u578b\u3001\u7b7e\u7f72\u65b9\u5f0f\uff0c\u5982\u679c\u7b7e\u7f72\u65b9\u5f0f\u4e3a\u201c\u7535\u5b50\u7b7e\u7f72\u201d\uff0c\u5219\u89e3\u9664\u534f\u8bae\u5408\u540c\u6a21\u677f\u4e3a\u5fc5\u586b\u4e14\u6700\u591a\u586b\u5199\u4e00\u4e2a\u3002", (String)"CancelProtocolValidUtils_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            Long contractCat = applyObject.getLong("contracttype.group.id");
            LOGGER.info("CancelProtocolValidUtils.matchTemplateContractType.contractCat={}", (Object)contractCat);
            if (!HRStringUtils.equals((String)"1366793317483942912", (String)String.valueOf(contractCat))) {
                return ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u7684\u5408\u540c\u5927\u7c7b\u9700\u4e3a\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CancelProtocolValidUtils_6", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            if (!CollectionUtils.isEmpty((Collection)entryentity) && (contracttemplate = (dynamicObject = (DynamicObject)entryentity.get(0)).getDynamicObject("contracttemplate")) != null && !HRStringUtils.equals((String)contracttemplate.getString("contracttype.name"), (String)contracttype.getString("name"))) {
                return ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u7684\u5408\u540c\u7c7b\u578b\u4e0e\u586b\u5199\u7684\u5408\u540c\u7c7b\u578b\u9700\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CancelProtocolValidUtils_7", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
        } else if (!(signeddate == null && HRObjectUtils.isEmpty((Object)contracttype) && HRStringUtils.isEmpty((String)signway) && CollectionUtils.isEmpty((Collection)entryentity))) {
            return ResManager.loadKDString((String)"\u5982\u9700\u7b7e\u8ba2\u89e3\u9664\u534f\u8bae\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u9884\u8ba1\u7b7e\u8ba2\u65e5\u671f\u3001\u5408\u540c\u7c7b\u578b\u3001\u7b7e\u7f72\u65b9\u5f0f\u3001\u5408\u540c\u6a21\u677f\uff08\u81f3\u591a\u586b1\u4e2a\uff09\uff1b\u82e5\u4e0d\u9700\u7b7e\u8ba2\u89e3\u9664\u534f\u8bae\uff0c\u5219\u65e0\u9700\u586b\u5199\u4ee5\u4e0a\u5185\u5bb9\u3002", (String)"CancelProtocolValidUtils_5", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public String matchSignwayValidate(DynamicObject applyObject) {
        String signway = applyObject.getString("signway");
        DynamicObjectCollection dys = applyObject.getDynamicObjectCollection("entryentity");
        String tmpMsg = "";
        if (ContractSignUtils.notCheckEntryData(applyObject)) {
            return tmpMsg;
        }
        if ("1".equals(signway)) {
            tmpMsg = ContractSignApplyRepository.getInstance().checkEleSignOnly(dys);
        }
        if ("2".equals(signway)) {
            tmpMsg = ContractSignApplyRepository.getInstance().checkPaperSign(dys, tmpMsg);
        }
        return tmpMsg;
    }

    public String signDateCannotBeforeOldStartDateValidate(DynamicObject applyObject) {
        Date startDate = applyObject.getDate("oldcontract.startdate");
        Date signedDate = applyObject.getDate("signeddate");
        if (!HRObjectUtils.isEmpty((Object)signedDate) && signedDate.before(startDate)) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u89e3\u9664\u534f\u8bae\u9884\u8ba1\u7b7e\u8ba2\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u539f\u5408\u540c\u5f00\u59cb\u65e5\u671f\u201c%s\u201d\u3002", (String)"CancelProtocolValidUtils_3", (String)"hr-hlcm-business", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)startDate));
        }
        return "";
    }

    public String isExistMultiEntry(DynamicObject applyObject, String protocolType) {
        DynamicObjectCollection entryentity = applyObject.getDynamicObjectCollection("oldcontract.entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity) && entryentity.size() > 1) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u539f%1s\u7b7e\u7f72\u65f6\u4e00\u5e76\u7b7e\u7f72\u4e86\u5176\u5b83\u6587\u4ef6\uff0c%2s\u89e3\u9664\u65f6\uff0c\u5176\u5b83\u6587\u4ef6\u5728\u7cfb\u7edf\u4e2d\u4e5f\u4f1a\u4e00\u5e76\u89e3\u9664\u3002", (String)"CancelProtocolValidUtils_4", (String)"hr-hlcm-business", (Object[])new Object[0]), protocolType, protocolType);
        }
        return "";
    }
}

