/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.utils.ContractDurationCalculateHelper;
import kd.hr.hlcm.common.enums.DateTimeUnitEnum;

public class ContractDurationCalculateEntryHelper {
    private static final Log LOGGER = LogFactory.getLog(ContractDurationCalculateHelper.class);
    private static final int WEEK_DAYS = 7;
    private static final int YEAR_DAYS = 365;
    private static final int MONTH_DAYS = 30;
    private static final int PERIOD_SCALE = 1;
    private static final HashSet<String> PROPERTY_NAMESET_NEEDCALC = Sets.newHashSet((Object[])new String[]{"entryperiod", "entrystartdate", "entryperiodunit", "entryenddate"});
    private IDataModel model;

    public ContractDurationCalculateEntryHelper(IDataModel model) {
        this.model = model;
    }

    public void calcContractDurationRelatedFields(DynamicObject dynamicObject, String propertyNameChanged) {
        if (!PROPERTY_NAMESET_NEEDCALC.contains(propertyNameChanged)) {
            return;
        }
        boolean isPropertyChangedEmpty = HRObjectUtils.isEmpty((Object)dynamicObject.get(propertyNameChanged));
        if (isPropertyChangedEmpty) {
            return;
        }
        switch (propertyNameChanged) {
            case "entryenddate": {
                this.periodDateFieldChanged(dynamicObject, CalculateFieldEnum.START_DATE);
                break;
            }
            case "entrystartdate": {
                this.periodDateFieldChanged(dynamicObject, CalculateFieldEnum.END_DATE);
                break;
            }
            case "entryperiod": 
            case "entryperiodunit": {
                this.periodChanged(dynamicObject);
                break;
            }
        }
    }

    private void periodChanged(DynamicObject dynamicObject) {
        Date startDate = dynamicObject.getDate("entrystartdate");
        Date endDate = dynamicObject.getDate("entryenddate");
        boolean isEmptyStartDateAndEndDate = HRObjectUtils.isEmpty((Object)startDate) && HRObjectUtils.isEmpty((Object)endDate);
        BigDecimal period = dynamicObject.getBigDecimal("entryperiod");
        if (isEmptyStartDateAndEndDate || HRObjectUtils.isEmpty((Object)period) || BigDecimal.ZERO.compareTo(period) == 0) {
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)startDate)) {
            this.calculateStartDateOrEndDate(dynamicObject, CalculateFieldEnum.END_DATE);
        } else {
            this.calculateStartDateOrEndDate(dynamicObject, CalculateFieldEnum.START_DATE);
        }
    }

    private void periodDateFieldChanged(DynamicObject dynamicObject, CalculateFieldEnum startDate2) {
        BigDecimal period = dynamicObject.getBigDecimal("entryperiod");
        Date startDate = dynamicObject.getDate("entrystartdate");
        Date endDate = dynamicObject.getDate("entryenddate");
        switch (startDate2) {
            case START_DATE: {
                if (HRObjectUtils.isEmpty((Object)startDate) || !HRObjectUtils.isEmpty((Object)period) && period.compareTo(BigDecimal.ZERO) != 0) break;
                this.calculateContractDurationAndSetVal(dynamicObject);
                break;
            }
            case END_DATE: {
                if (!HRObjectUtils.isEmpty((Object)period) && period.compareTo(BigDecimal.ZERO) > 0) {
                    this.calculateStartDateOrEndDate(dynamicObject, startDate2);
                    break;
                }
                if (Objects.nonNull(endDate)) {
                    this.calculateContractDurationAndSetVal(dynamicObject);
                    break;
                }
                LOGGER.info("period|{}", (Object)period);
                break;
            }
        }
    }

    private void calculateStartDateOrEndDate(DynamicObject dynamicObject, CalculateFieldEnum CalculateField) {
        String field;
        Date secondDate;
        int periodUnit = dynamicObject.getInt("entryperiodunit");
        DateTimeUnitEnum unitEnumByOrdinal = DateTimeUnitEnum.getUnitEnumByOrdinal((int)periodUnit);
        BigDecimal period = dynamicObject.getBigDecimal("entryperiod");
        if (unitEnumByOrdinal == DateTimeUnitEnum.EMPTY || CalculateField == CalculateFieldEnum.EMPTY || HRObjectUtils.isEmpty((Object)period)) {
            return;
        }
        Date startDate = dynamicObject.getDate("entrystartdate");
        Date endDate = dynamicObject.getDate("entryenddate");
        switch (CalculateField) {
            case START_DATE: {
                secondDate = endDate;
                field = "entrystartdate";
                break;
            }
            case END_DATE: {
                secondDate = startDate;
                field = "entryenddate";
                break;
            }
            default: {
                return;
            }
        }
        Date firstDate = this.getCalculatedDate(unitEnumByOrdinal, period, secondDate, CalculateField);
        this.model.setValue(field, (Object)firstDate);
    }

    public Date getCalculatedDate(DateTimeUnitEnum periodUnit, BigDecimal period, Date secondDate, CalculateFieldEnum calculateField) {
        Date firstDate;
        AssertUtil.notNull((Object)periodUnit, (String)"periodUnit cannot be null!");
        AssertUtil.notNull((Object)period, (String)"period cannot be null!");
        AssertUtil.notNull((Object)secondDate, (String)"secondDate cannot be null!");
        int offsetDay = -1;
        switch (calculateField) {
            case START_DATE: {
                period = BigDecimal.ZERO.subtract(period);
                offsetDay = 0 - offsetDay;
                break;
            }
            case END_DATE: {
                break;
            }
            default: {
                throw new KDBizException("CalculateFieldEnum is incorrect!");
            }
        }
        int periodIntegerPart = period.intValue();
        BigDecimal periodFractionalPart = period.subtract(new BigDecimal(periodIntegerPart));
        switch (periodUnit) {
            case YEAR: {
                Date dateYearResult = HRDateTimeUtils.addYear((Date)secondDate, (int)periodIntegerPart);
                if (periodFractionalPart.compareTo(new BigDecimal("0.5")) == 0) {
                    firstDate = HRDateTimeUtils.addMonth((Date)dateYearResult, (int)6);
                    break;
                }
                int remainderYearDays = periodFractionalPart.multiply(new BigDecimal(365)).setScale(0, 4).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)dateYearResult, (long)remainderYearDays);
                break;
            }
            case MONTH: {
                Date dateMonthResult = HRDateTimeUtils.addMonth((Date)secondDate, (int)periodIntegerPart);
                int remainderMonthDays = periodFractionalPart.multiply(BigDecimal.valueOf(30L)).setScale(0, 4).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)dateMonthResult, (long)remainderMonthDays);
                break;
            }
            case WEEK: {
                int weekResult = period.multiply(new BigDecimal(7)).setScale(0, 0).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)secondDate, (long)weekResult);
                break;
            }
            case DAY: {
                int dayResult = period.setScale(0, 0).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)secondDate, (long)dayResult);
                break;
            }
            default: {
                throw new KDBizException("periodUnit is incorrect!");
            }
        }
        return HRDateTimeUtils.addDay((Date)firstDate, (long)offsetDay);
    }

    private void calculateContractDurationAndSetVal(DynamicObject dynamicObject) {
        BigDecimal daysDiff;
        int periodUnit = dynamicObject.getInt("entryperiodunit");
        Date startDate = dynamicObject.getDate("entrystartdate");
        Date endDate = dynamicObject.getDate("entryenddate");
        DateTimeUnitEnum unitEnumByOrdinal = DateTimeUnitEnum.getUnitEnumByOrdinal((int)periodUnit);
        switch (unitEnumByOrdinal) {
            case YEAR: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L)).divide(BigDecimal.valueOf(365L), 1, 4);
                break;
            }
            case MONTH: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L)).divide(BigDecimal.valueOf(30L), 1, 4);
                break;
            }
            case WEEK: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L)).divide(BigDecimal.valueOf(7L), 1, 4);
                break;
            }
            case DAY: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L));
                break;
            }
            default: {
                return;
            }
        }
        if (BigDecimal.ZERO.compareTo(daysDiff) >= 0) {
            this.model.setValue("entryperiod", (Object)BigDecimal.ZERO);
        } else {
            this.model.setValue("entryperiod", (Object)daysDiff);
        }
    }

    public static enum CalculateFieldEnum {
        EMPTY,
        START_DATE,
        END_DATE;

    }
}

