/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.utils.ModelUtils;
import kd.hr.hlcm.common.enums.DateTimeUnitEnum;

public class ContractDurationCalculateHelper {
    private static final Log LOGGER = LogFactory.getLog(ContractDurationCalculateHelper.class);
    private static final int WEEK_DAYS = 7;
    private static final int YEAR_DAYS = 365;
    private static final int MONTH_DAYS = 30;
    private static final int PERIOD_SCALE = 1;
    private static final HashSet<String> PROPERTY_NAMESET_NEEDCALC = Sets.newHashSet((Object[])new String[]{"period", "startdate", "periodunit", "enddate"});
    private static final ContractDurationCalculateHelper CONTRACT_DURATION_CALCULATE_HELPER = new ContractDurationCalculateHelper();

    public static ContractDurationCalculateHelper getInstance() {
        return CONTRACT_DURATION_CALCULATE_HELPER;
    }

    public void calcContractDurationRelatedFields(IDataModel model, String propertyNameChanged) {
        if (!PROPERTY_NAMESET_NEEDCALC.contains(propertyNameChanged)) {
            return;
        }
        DynamicObject dynamicObject = model.getDataEntity();
        boolean isPropertyChangedEmpty = HRObjectUtils.isEmpty((Object)dynamicObject.get(propertyNameChanged));
        if (isPropertyChangedEmpty) {
            return;
        }
        switch (propertyNameChanged) {
            case "enddate": {
                this.periodDateFieldChanged(model, CalculateFieldEnum.START_DATE);
                break;
            }
            case "startdate": {
                this.periodDateFieldChanged(model, CalculateFieldEnum.END_DATE);
                break;
            }
            case "period": 
            case "periodunit": {
                this.periodChanged(model);
                break;
            }
        }
    }

    private void periodChanged(IDataModel model) {
        DynamicObject dynamicObject = model.getDataEntity();
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        boolean isEmptyStartDateAndEndDate = HRObjectUtils.isEmpty((Object)startDate) && HRObjectUtils.isEmpty((Object)endDate);
        BigDecimal period = dynamicObject.getBigDecimal("period");
        if (isEmptyStartDateAndEndDate || HRObjectUtils.isEmpty((Object)period) || BigDecimal.ZERO.compareTo(period) == 0) {
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)startDate)) {
            this.calculateStartDateOrEndDate(model, CalculateFieldEnum.END_DATE);
        } else {
            this.calculateStartDateOrEndDate(model, CalculateFieldEnum.START_DATE);
        }
    }

    private void periodDateFieldChanged(IDataModel model, CalculateFieldEnum startDate2) {
        DynamicObject dynamicObject = model.getDataEntity();
        BigDecimal period = dynamicObject.getBigDecimal("period");
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        switch (startDate2) {
            case START_DATE: {
                if (HRObjectUtils.isEmpty((Object)startDate) || !HRObjectUtils.isEmpty((Object)period) && period.compareTo(BigDecimal.ZERO) != 0) break;
                this.calculateContractDurationAndSetVal(model);
                break;
            }
            case END_DATE: {
                if (!HRObjectUtils.isEmpty((Object)period) && period.compareTo(BigDecimal.ZERO) > 0) {
                    this.calculateStartDateOrEndDate(model, startDate2);
                    break;
                }
                if (Objects.nonNull(endDate)) {
                    this.calculateContractDurationAndSetVal(model);
                    break;
                }
                LOGGER.info("period|{}", (Object)period);
                break;
            }
        }
    }

    private void calculateStartDateOrEndDate(IDataModel model, CalculateFieldEnum CalculateField) {
        String field;
        Date secondDate;
        DynamicObject dynamicObject = model.getDataEntity();
        int periodUnit = dynamicObject.getInt("periodunit");
        DateTimeUnitEnum unitEnumByOrdinal = DateTimeUnitEnum.getUnitEnumByOrdinal((int)periodUnit);
        BigDecimal period = dynamicObject.getBigDecimal("period");
        if (unitEnumByOrdinal == DateTimeUnitEnum.EMPTY || CalculateField == CalculateFieldEnum.EMPTY || HRObjectUtils.isEmpty((Object)period)) {
            return;
        }
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        switch (CalculateField) {
            case START_DATE: {
                secondDate = endDate;
                field = "startdate";
                break;
            }
            case END_DATE: {
                secondDate = startDate;
                field = "enddate";
                break;
            }
            default: {
                return;
            }
        }
        Date firstDate = this.getCalculatedDate(unitEnumByOrdinal, period, secondDate, CalculateField);
        ModelUtils.setDateValue(field, firstDate, model);
    }

    public Date getCalculatedDate(DateTimeUnitEnum periodUnit, BigDecimal period, Date secondDate, CalculateFieldEnum calculateField) {
        Date firstDate;
        AssertUtil.notNull((Object)periodUnit, (String)"periodUnit cannot be null!");
        AssertUtil.notNull((Object)period, (String)"period cannot be null!");
        AssertUtil.notNull((Object)secondDate, (String)"secondDate cannot be null!");
        int offsetDay = -1;
        switch (calculateField) {
            case START_DATE: {
                period = BigDecimal.ZERO.subtract(period);
                offsetDay = 0 - offsetDay;
                break;
            }
            case END_DATE: {
                break;
            }
            default: {
                throw new KDBizException("CalculateFieldEnum is incorrect!");
            }
        }
        int periodIntegerPart = period.intValue();
        BigDecimal periodFractionalPart = period.subtract(new BigDecimal(periodIntegerPart));
        switch (periodUnit) {
            case YEAR: {
                Date dateYearResult = HRDateTimeUtils.addYear((Date)secondDate, (int)periodIntegerPart);
                if (periodFractionalPart.compareTo(new BigDecimal("0.5")) == 0) {
                    firstDate = HRDateTimeUtils.addMonth((Date)dateYearResult, (int)6);
                    break;
                }
                int remainderYearDays = periodFractionalPart.multiply(new BigDecimal(365)).setScale(0, 4).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)dateYearResult, (long)remainderYearDays);
                break;
            }
            case MONTH: {
                Date dateMonthResult = HRDateTimeUtils.addMonth((Date)secondDate, (int)periodIntegerPart);
                int remainderMonthDays = periodFractionalPart.multiply(BigDecimal.valueOf(30L)).setScale(0, 4).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)dateMonthResult, (long)remainderMonthDays);
                break;
            }
            case WEEK: {
                int weekResult = period.multiply(new BigDecimal(7)).setScale(0, 0).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)secondDate, (long)weekResult);
                break;
            }
            case DAY: {
                int dayResult = period.setScale(0, 0).intValue();
                firstDate = HRDateTimeUtils.addDay((Date)secondDate, (long)dayResult);
                break;
            }
            default: {
                throw new KDBizException("periodUnit is incorrect!");
            }
        }
        return HRDateTimeUtils.addDay((Date)firstDate, (long)offsetDay);
    }

    private void calculateContractDurationAndSetVal(IDataModel model) {
        BigDecimal daysDiff;
        DynamicObject dynamicObject = model.getDataEntity();
        int periodUnit = dynamicObject.getInt("periodunit");
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        DateTimeUnitEnum unitEnumByOrdinal = DateTimeUnitEnum.getUnitEnumByOrdinal((int)periodUnit);
        switch (unitEnumByOrdinal) {
            case YEAR: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L)).divide(BigDecimal.valueOf(365L), 1, 4);
                break;
            }
            case MONTH: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L)).divide(BigDecimal.valueOf(30L), 1, 4);
                break;
            }
            case WEEK: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L)).divide(BigDecimal.valueOf(7L), 1, 4);
                break;
            }
            case DAY: {
                daysDiff = BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate)).add(BigDecimal.valueOf(1L));
                break;
            }
            default: {
                return;
            }
        }
        if (BigDecimal.ZERO.compareTo(daysDiff) >= 0) {
            ModelUtils.setBigDecimalValue("period", BigDecimal.ZERO, model);
        }
        ModelUtils.setBigDecimalValue("period", daysDiff, model);
    }

    public static enum CalculateFieldEnum {
        EMPTY,
        START_DATE,
        END_DATE;

    }
}

