/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.common.enums.PositionTypeEnum;
import kd.hr.hlcm.common.utils.LabelOperateUtils;

public class ContractPageLoadUtils {
    private static final Log LOGGER = LogFactory.getLog(ContractPageLoadUtils.class);
    private static final ContractPageLoadUtils LOAD_PAGE_BASE_UTILS = new ContractPageLoadUtils();
    public static final String CATCH_KEY_ERMANFILEID = "erManFileID";

    public static ContractPageLoadUtils getInstance() {
        return LOAD_PAGE_BASE_UTILS;
    }

    public void loadPage(IFormView view) {
        this.setMainContractInfo(view.getModel().getDataEntity(), view);
    }

    public void setMainContractInfo(DynamicObject dataEntity, IFormView view) {
        DynamicObject actualSignCompanyHis = dataEntity.getDynamicObject("actualsigncompanyhis");
        DynamicObject suggestSignCompanyHis = dataEntity.getDynamicObject("suggestsigncompanyhis");
        if (HRObjectUtils.isEmpty((Object)suggestSignCompanyHis)) {
            LOGGER.warn("suggestSignCompanyHis is null!");
        } else {
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1suggestsigncompany", (String)suggestSignCompanyHis.getString("name"));
        }
        if (!HRObjectUtils.isEmpty((Object)actualSignCompanyHis)) {
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1actualsigncompany", (String)actualSignCompanyHis.getString("name"));
            DynamicObject corporateorg = actualSignCompanyHis.getDynamicObject("reorg");
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1corporateorg", (String)(HRObjectUtils.isEmpty((Object)corporateorg) ? "" : corporateorg.getString("name")));
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1organizationcode", (String)actualSignCompanyHis.getString("unifiedcode"));
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1legalperson", (String)actualSignCompanyHis.getString("representative"));
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1address", (String)actualSignCompanyHis.getString("address"));
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1empphone", (String)actualSignCompanyHis.getString("contactnumber"));
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1postalcode", (String)actualSignCompanyHis.getString("postalcode"));
        } else {
            LOGGER.warn("actualSignCompanyHis is null!");
        }
        LabelOperateUtils.setLabel((IFormView)view, (String)"r1name", (String)dataEntity.getString("name"));
        view.getModel().setValue("r2name", (Object)ContractPageLoadUtils.getStringValue(dataEntity, "name"));
        LabelOperateUtils.setLabel((IFormView)view, (String)"r1cardtype", (String)dataEntity.getString("cardtype.name"));
        LabelOperateUtils.setLabel((IFormView)view, (String)"r1cardnum", (String)dataEntity.getString("cardnumber"));
        view.getModel().setValue("r2cardnum", (Object)ContractPageLoadUtils.getStringValue(dataEntity, "cardnumber"));
        LabelOperateUtils.setLabel((IFormView)view, (String)"r1householdregister", (String)dataEntity.getString("householdregister"));
        view.getModel().setValue("r2householdregister", (Object)ContractPageLoadUtils.getStringValue(dataEntity, "householdregister"));
        LabelOperateUtils.setLabel((IFormView)view, (String)"r1residentialaddress", (String)dataEntity.getString("residentialaddress"));
        view.getModel().setValue("r2residentialaddress", (Object)ContractPageLoadUtils.getStringValue(dataEntity, "residentialaddress"));
        LabelOperateUtils.setLabel((IFormView)view, (String)"r1empphone", (String)dataEntity.getString("empphone"));
        view.getModel().setValue("r2empphone", (Object)view.getModel().getDataEntity().getString("empphone"));
        LabelOperateUtils.setLabel((IFormView)view, (String)"r1signreason", (String)dataEntity.getString("signreason"));
    }

    public static String getStringValue(DynamicObject dataEntity, String fieldName) {
        String value = dataEntity.getString(fieldName);
        if (HRStringUtils.isEmpty((String)value)) {
            return "-";
        }
        return value;
    }

    public void loadPersonInfoCard(IFormView view) {
        Object customParam = view.getFormShowParameter().getCustomParam(CATCH_KEY_ERMANFILEID);
        Long erManFileID = Long.parseLong(customParam.toString());
        String nameSliceField = (String)view.getFormShowParameter().getCustomParam("name");
        String positionSliceField = (String)view.getFormShowParameter().getCustomParam("position");
        String posTypeSliceField = (String)view.getFormShowParameter().getCustomParam("postype");
        String companySliceField = (String)view.getFormShowParameter().getCustomParam("company");
        LOGGER.info("PersonInfoCardFormPlugins_loadPersonInfoCard,erManFileID:{},nameSliceField:{},positionSliceField:{},posTypeSliceField:{},companySliceField:{}", new Object[]{erManFileID, nameSliceField, positionSliceField, posTypeSliceField, companySliceField});
        if (HRObjectUtils.isEmpty((Object)erManFileID) || erManFileID == 0L) {
            return;
        }
        Map<String, Object> erManFileInfo = IHSPMFileService.getInstance().getCardFieldByErManFileId(erManFileID);
        if (CollectionUtils.isEmpty(erManFileInfo)) {
            throw new KDBizException(String.format(Locale.ROOT, "The personnel file with ID#%s does not exist!", customParam));
        }
        String name = (String)erManFileInfo.get("name");
        this.setFieldValue(view, "r2name", name);
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)(HRStringUtils.isEmpty((String)nameSliceField) ? name : nameSliceField), (String)"name", (String[])new String[0]);
        String headSculpture = (String)erManFileInfo.get("headsculpture");
        Image imgHeadSculpture = (Image)view.getControl("avatar");
        String imageFullUrl = HRImageUrlUtil.getImageFullUrl((String)headSculpture);
        if (!HRStringUtils.isEmpty((String)imageFullUrl)) {
            imgHeadSculpture.setUrl(imageFullUrl);
        }
        Object superiorInfo = erManFileInfo.get("superiorinfo");
        List jsonObjects = JSONArray.parseArray((String)JSONArray.toJSONString((Object)superiorInfo), JSONObject.class);
        this.setSuperiorInfoValues(view, jsonObjects);
        String empNumber = (String)erManFileInfo.get("number");
        this.setFieldValue(view, "r2employeeno", empNumber);
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)empNumber, (String)"employeeno", (String[])new String[0]);
        String posStatus = (String)erManFileInfo.get("posstatus");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)posStatus, (String)"labposstatus", (String[])new String[0]);
        String laborrelType = (String)erManFileInfo.get("laborreltype");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)laborrelType, (String)"laborreltype", (String[])new String[0]);
        String posType = (String)erManFileInfo.get("postype");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)(HRStringUtils.isEmpty((String)posTypeSliceField) ? posType : posTypeSliceField), (String)"labpostype", (String[])new String[0]);
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)((String)erManFileInfo.get("adminorg")), (String)"department", (String[])new String[]{"departmentvector", "departmenttitle"});
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)(HRStringUtils.isEmpty((String)companySliceField) ? (String)erManFileInfo.get("company") : companySliceField), (String)"company", (String[])new String[]{"companyvector", "companytitle"});
        String laborrelstatus = (String)erManFileInfo.get("laborrelstatus");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)laborrelstatus, (String)"laborrelstatus", (String[])new String[0]);
        String showPosition = (String)erManFileInfo.get("apositiontypedesc");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)showPosition, (String)"position", (String[])new String[]{"positionvector"});
        String positionType = (String)erManFileInfo.get("apositiontype");
        LabelOperateUtils.setVectorTip((IFormView)view, (String)"positionvector", (String)PositionTypeEnum.getDesc((String)positionType));
        String location = (String)erManFileInfo.get("location");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)location, (String)"baselocation", (String[])new String[]{"baselocationvector"});
        this.setFieldValue(view, "r2baselocation", location);
        String nation = (String)erManFileInfo.get("nationality");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)nation, (String)"nation", (String[])new String[]{"nationvector"});
        this.setFieldValue(view, "r2nation", nation);
        String sex = (String)erManFileInfo.get("gender");
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)sex, (String)"sex", (String[])new String[]{"sexvector"});
        this.setFieldValue(view, "r2sex", sex);
    }

    private void setFieldValue(IFormView view, String fieldName, String value) {
        Control control = view.getControl(fieldName);
        if (Objects.isNull(control)) {
            return;
        }
        view.setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)value)), new String[]{fieldName});
        view.getModel().setValue(fieldName, (Object)value);
    }

    private void setSuperiorInfoValues(IFormView view, List<JSONObject> jsonObjects) {
        view.setVisible(Boolean.FALSE, new String[]{"supervisorap0", "supervisorap1", "supervisorap2", "supervisorap3", "supervisorap4"});
        if (!HRObjectUtils.isEmpty(jsonObjects) && jsonObjects.size() > 0) {
            List supers = jsonObjects.stream().filter(jsonObject -> !HRObjectUtils.isEmpty((Object)jsonObject.getString("name"))).collect(Collectors.toList());
            ArrayList showFlexs = Lists.newArrayListWithCapacity((int)supers.size());
            for (int i = 0; i < supers.size(); ++i) {
                if (i > 2) continue;
                showFlexs.add("supervisorap" + i);
                JSONObject superior = jsonObjects.get(i);
                LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)superior.getString("name"), (String)("supervisor" + i), (String[])new String[0]);
                String superiorHeadSculpture = superior.getString("headsculpture");
                Image superiorImgHeadSculpture = (Image)view.getControl("avatar_supervisor" + i);
                String superiorImageFullUrl = HRImageUrlUtil.getImageFullUrl((String)superiorHeadSculpture);
                if (HRObjectUtils.isEmpty((Object)superiorImgHeadSculpture) || !HRStringUtils.isNotEmpty((String)superiorImageFullUrl)) continue;
                superiorImgHeadSculpture.setUrl(superiorImageFullUrl);
            }
            view.setVisible(Boolean.TRUE, showFlexs.toArray(new String[showFlexs.size()]));
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"labelap31"});
        }
    }
}

