/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.common.entity.ErManQueryParam;
import kd.hr.hlcm.common.entity.ErManQueryResult;
import kd.hr.hlcm.common.entity.PersonInfo;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.utils.LogFilterUtil;
import org.apache.commons.collections.CollectionUtils;

public class HLCMImportUtils {
    private static final Log log = LogFactory.getLog(HLCMImportUtils.class);

    public static void setSignBillPersonInfo(IDataModel signBillModel, PersonInfo personInfo, DynamicObject opPerson) {
        signBillModel.setValue("empname", (Object)personInfo.getEmpName());
        signBillModel.setValue("empnumber", (Object)personInfo.getEmpNumber());
        signBillModel.setValue("postype", (Object)personInfo.getPosTypeId());
        signBillModel.setValue("person", (Object)personInfo.getPersonId());
        signBillModel.setValue("empphone", (Object)personInfo.getEmpPhone());
        signBillModel.setValue("baselocation", (Object)personInfo.getLocationId());
        signBillModel.setValue("nation", (Object)personInfo.getNationalityId());
        DynamicObject dataEntity = signBillModel.getDataEntity();
        if (HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("cardtype"))) {
            signBillModel.setValue("cardtype", (Object)personInfo.getCardTypeId());
        }
        if (HRStringUtils.isEmpty((String)dataEntity.getString("cardnumber"))) {
            signBillModel.setValue("cardnumber", (Object)personInfo.getCardNumber());
        }
        signBillModel.setValue("usestartdate", (Object)personInfo.getStartDate());
        int probationPeriod = personInfo.getProbationperiod();
        Date preRegularDate = personInfo.getProbationendDate();
        if (probationPeriod != 0 && !Objects.isNull(preRegularDate)) {
            signBillModel.setValue("probationstartdate", (Object)personInfo.getProbationstartDate());
            signBillModel.setValue("probationenddate", (Object)HRDateTimeUtils.getBeforeDay((Date)preRegularDate));
            signBillModel.setValue("probationperiod", (Object)personInfo.getProbationperiod());
            signBillModel.setValue("probationunit", (Object)personInfo.getProbationperiodUnit());
            signBillModel.setValue("probationperiodunit", (Object)(personInfo.getProbationperiod() + ProbationUnitEnum.getValueByKey((String)personInfo.getProbationperiodUnit())));
        }
        signBillModel.setValue("householdregister", (Object)personInfo.getHouseholdregister());
        signBillModel.setValue("residentialaddress", (Object)personInfo.getResidentialaddress());
        signBillModel.setValue("signedcompanyhis", (Object)personInfo.getSignedcompanyVid());
        signBillModel.setValue("curcompany", (Object)personInfo.getSignedcompanyId());
        signBillModel.setValue("departmenthis", (Object)personInfo.getAdminOrgVid());
        signBillModel.setValue("curdept", (Object)personInfo.getAdminOrgId());
        signBillModel.setValue("postionhis", (Object)personInfo.getPositionVid());
        signBillModel.setValue("curpostion", (Object)personInfo.getPositionId());
        signBillModel.setValue("stdpostionhis", (Object)personInfo.getStdpositionVid());
        signBillModel.setValue("curstdpostion", (Object)personInfo.getStdpositionId());
        signBillModel.setValue("job", (Object)personInfo.getJobVid());
        signBillModel.setValue("curjob", (Object)personInfo.getJobId());
        signBillModel.setValue("ermanorg", (Object)personInfo.getOrgId());
        signBillModel.setValue("adminororg", (Object)personInfo.getAffiliateadminorgId());
        signBillModel.setValue("ermanperorg", (Object)personInfo.getEmpGroupId());
        signBillModel.setValue("ermanfile", (Object)personInfo.getErManFileId());
        signBillModel.setValue("employee", (Object)personInfo.getEmployeeId());
        DynamicObject acSignComDy = dataEntity.getDynamicObject("actualsigncompany");
        if (acSignComDy != null) {
            signBillModel.setValue("actualsigncompanyhis", (Object)acSignComDy.getLong("vid"));
        }
        Date opDate = new Date();
        DynamicObjectCollection entryEntity = signBillModel.getEntryEntity("entryentity");
        for (DynamicObject dy : entryEntity) {
            dy.set("opperson", (Object)opPerson);
            dy.set("opdate", (Object)opDate);
        }
        HLCMImportUtils.setOldContract(signBillModel);
    }

    public static List<ErManQueryParam> filterRepeatDataRow(InitImportDataEventArgs evt, String signBillId, Set<ErManQueryParam> erManQueryParamSet) {
        List sourceDataList = evt.getSourceDataList();
        for (int sourceDataIndex = 0; sourceDataIndex < sourceDataList.size(); ++sourceDataIndex) {
            Map map = (Map)sourceDataList.get(sourceDataIndex);
            String empNumber = (String)((JSONObject)map.get("person")).get((Object)"number");
            String depNumber = (String)((JSONObject)map.get("orgmodel")).get((Object)"number");
            JSONObject js = (JSONObject)map.get("positionmodel");
            String positionNumber = null;
            if (null != js) {
                positionNumber = js.getString("number");
            }
            js = (JSONObject)map.get("stdpositionmodel");
            String stdPositionNumber = null;
            if (null != js) {
                stdPositionNumber = js.getString("number");
            }
            js = (JSONObject)map.get("job");
            String jobNumber = null;
            if (null != js) {
                jobNumber = js.getString("number");
            }
            ErManQueryParam erManQueryParam = new ErManQueryParam(empNumber, depNumber, positionNumber, stdPositionNumber, jobNumber, sourceDataIndex);
            if (HRStringUtils.equals((String)"hlcm_otheragreements", (String)signBillId)) {
                erManQueryParamSet.add(erManQueryParam);
            } else if (erManQueryParamSet.contains(erManQueryParam)) {
                evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HLCMImportUtils_0", (String)"hr-hlcm-business", (Object[])new Object[0]));
            } else {
                erManQueryParamSet.add(erManQueryParam);
            }
            JSONArray jsonArray = (JSONArray)map.get("entryentity");
            if (null == jsonArray || jsonArray.size() <= 1) continue;
            HashSet<String> templateNumber = new HashSet<String>(jsonArray.size());
            ArrayList<String> tipsResult = new ArrayList<String>(jsonArray.size());
            for (int j = 0; j < jsonArray.size(); ++j) {
                js = (JSONObject)jsonArray.get(j);
                if ((js = js.getJSONObject("contracttemplate")) == null) continue;
                String number = js.getString("number");
                if (templateNumber.contains(number)) {
                    tipsResult.add(number);
                }
                templateNumber.add(number);
            }
            if (templateNumber.size() == jsonArray.size() || tipsResult.size() <= 0) continue;
            String codes = String.join((CharSequence)"\u3001", tipsResult);
            String showTips = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5b58\u5728\u591a\u4efd\u5408\u540c\u7b7e\u7f72\u6a21\u677f\u7f16\u7801\u91cd\u590d\uff08\u6a21\u677f\u7f16\u7801\uff1a%s\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HLCMImportUtils_1", (String)"hr-hlcm-business", (Object[])new Object[0]), codes);
            evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(1), Integer.valueOf(0), showTips);
        }
        return new ArrayList<ErManQueryParam>(erManQueryParamSet);
    }

    public static Map<ErManQueryParam, ErManQueryResult> queryInitErManFile(List<ErManQueryParam> erManQueryParamList) {
        log.info("getErmanFileIdByEmporgRel.queryInitErManFile={}", (Object)(erManQueryParamList.size() == 0 ? "" : erManQueryParamList.get(0).toString()));
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(erManQueryParamList.size());
        erManQueryParamList.forEach(erManQueryParam -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", erManQueryParam.getEmpNumber());
            map.put("position", erManQueryParam.getPositionNumber());
            map.put("adminorg", erManQueryParam.getDepartmentNumber());
            map.put("stdposition", erManQueryParam.getStdpositionNumber());
            map.put("job", erManQueryParam.getJobNumber());
            params.add(map);
        });
        List<Map<String, Object>> erManFileInfos = IHSPMFileService.getInstance().getAllErmanFileIdByEmporgRel(params);
        log.info("==getErmanFileIdByEmporgRel.queryErManFileResult={}", erManFileInfos);
        log.info("==getErmanFileIdByEmporgRel params {}, result {}", (Object)LogFilterUtil.getLogStrForList(params, (Set)Sets.newHashSet((Object[])new String[]{"number"})), (Object)LogFilterUtil.getLogStrForList(erManFileInfos));
        if (!CollectionUtils.isEmpty(erManFileInfos)) {
            erManFileInfos.sort((o1, o2) -> {
                Date startDate1 = (Date)o1.get("startdate");
                Date startDate2 = (Date)o2.get("startdate");
                if (startDate1 == null && startDate2 == null) {
                    return 0;
                }
                if (startDate1 == null) {
                    return 1;
                }
                if (startDate2 == null) {
                    return -1;
                }
                int index = startDate2.compareTo(startDate1);
                if (index == 0) {
                    return -((Long)o1.get("id")).compareTo((Long)o2.get("id"));
                }
                return index;
            });
            HashMap<ErManQueryParam, ErManQueryResult> result = new HashMap<ErManQueryParam, ErManQueryResult>(erManFileInfos.size());
            for (Map<String, Object> map : erManFileInfos) {
                String number = (String)map.get("number");
                String adminOrg = (String)map.get("adminorg");
                String position = (String)map.get("position");
                String stdposition = (String)map.get("stdposition");
                String job = (String)map.get("job");
                erManQueryParamList.stream().filter(erManQueryParam -> HRStringUtils.equals((String)number, (String)erManQueryParam.getEmpNumber()) && HRStringUtils.equals((String)adminOrg, (String)erManQueryParam.getDepartmentNumber()) && (HRStringUtils.isNotEmpty((String)erManQueryParam.getStdpositionNumber()) && HRStringUtils.equals((String)stdposition, (String)erManQueryParam.getStdpositionNumber()) || HRStringUtils.isNotEmpty((String)erManQueryParam.getPositionNumber()) && HRStringUtils.equals((String)position, (String)erManQueryParam.getPositionNumber()) || HRStringUtils.isNotEmpty((String)erManQueryParam.getJobNumber()) && HRStringUtils.equals((String)job, (String)erManQueryParam.getJobNumber()))).forEach(erManQueryParam -> {
                    ErManQueryResult erManQueryResult = new ErManQueryResult();
                    erManQueryResult.setErManFileId((Long)map.get("id"));
                    erManQueryResult.setLaborRelTypeClsId((List)map.get("laborreltypecls"));
                    erManQueryResult.setLabrelStatusPrdId((Long)map.get("labrelstatusprd"));
                    erManQueryResult.setPosTypeId((Long)map.get("postype"));
                    result.putIfAbsent((ErManQueryParam)erManQueryParam, erManQueryResult);
                });
            }
            return result;
        }
        log.info("==getErmanFileIdByEmporgRel.queryErManFileResult is empty ==");
        return new HashMap<ErManQueryParam, ErManQueryResult>();
    }

    @Deprecated
    public static Map<ErManQueryParam, ErManQueryResult> queryErManFile(List<ErManQueryParam> erManQueryParamList) {
        log.info("getErmanFileIdByEmporgRel.queryErManFile={}", (Object)(erManQueryParamList.size() == 0 ? "" : erManQueryParamList.get(0).toString()));
        ArrayList params = new ArrayList(erManQueryParamList.size());
        erManQueryParamList.stream().forEach(erManQueryParam -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", erManQueryParam.getEmpNumber());
            map.put("position", erManQueryParam.getPositionNumber());
            map.put("adminorg", erManQueryParam.getDepartmentNumber());
            map.put("stdposition", erManQueryParam.getStdpositionNumber());
            map.put("job", erManQueryParam.getJobNumber());
            params.add(map);
        });
        List erManFileInfos = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanFileIdByEmporgRel", (Object[])new Object[]{params});
        log.info("getErmanFileIdByEmporgRel.queryErManFileResult={}", (Object)erManFileInfos.toString());
        log.info("getErmanFileIdByEmporgRel params {}, result {}", (Object)LogFilterUtil.getLogStrForList(params, (Set)Sets.newHashSet((Object[])new String[]{"number"})), (Object)LogFilterUtil.getLogStrForList((List)erManFileInfos));
        if (!CollectionUtils.isEmpty((Collection)erManFileInfos)) {
            HashMap<ErManQueryParam, ErManQueryResult> result = new HashMap<ErManQueryParam, ErManQueryResult>(erManFileInfos.size());
            erManFileInfos.forEach(map -> {
                String number = (String)map.get("number");
                String adminOrg = (String)map.get("adminorg");
                String position = (String)map.get("position");
                String stdposition = (String)map.get("stdposition");
                String job = (String)map.get("job");
                erManQueryParamList.stream().filter(erManQueryParam -> HRStringUtils.equals((String)number, (String)erManQueryParam.getEmpNumber()) && HRStringUtils.equals((String)adminOrg, (String)erManQueryParam.getDepartmentNumber()) && (HRStringUtils.isNotEmpty((String)erManQueryParam.getStdpositionNumber()) && HRStringUtils.equals((String)stdposition, (String)erManQueryParam.getStdpositionNumber()) || HRStringUtils.isNotEmpty((String)erManQueryParam.getPositionNumber()) && HRStringUtils.equals((String)position, (String)erManQueryParam.getPositionNumber()) || HRStringUtils.isNotEmpty((String)erManQueryParam.getJobNumber()) && HRStringUtils.equals((String)job, (String)erManQueryParam.getJobNumber()))).forEach(erManQueryParam -> {
                    ErManQueryResult erManQueryResult = new ErManQueryResult();
                    erManQueryResult.setErManFileId((Long)map.get("id"));
                    erManQueryResult.setLaborRelTypeClsId((List)map.get("laborreltypecls"));
                    erManQueryResult.setLabrelStatusPrdId((Long)map.get("labrelstatusprd"));
                    erManQueryResult.setPosTypeId((Long)map.get("postype"));
                    ErManQueryResult preResult = result.putIfAbsent((ErManQueryParam)erManQueryParam, erManQueryResult);
                    if (null != preResult) {
                        // empty if block
                    }
                });
            });
            return result;
        }
        return new HashMap<ErManQueryParam, ErManQueryResult>();
    }

    public static Map<ErManQueryParam, PersonInfo> getPersonInfoByErManFileId(String entityId, Map<Long, ErManQueryParam> erManFileIdMap) {
        HashMap<ErManQueryParam, PersonInfo> map = new HashMap<ErManQueryParam, PersonInfo>(erManFileIdMap.size());
        HashMultimap personIdToInfo = HashMultimap.create();
        HashMultimap employeeIdToInfo = HashMultimap.create();
        ArrayList erManFileIdList = Lists.newArrayList(erManFileIdMap.keySet().iterator());
        List<Map<String, Object>> erManFileInfos = IHSPMFileService.getInstance().getAllCardFieldByErManFileIds(erManFileIdList);
        if (CollectionUtils.isEmpty(erManFileInfos)) {
            return map;
        }
        int size = erManFileInfos.size();
        HashSet companyIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet adminOrgIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet stdPositionIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet positionIdSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet jobIdSet = Sets.newHashSetWithExpectedSize((int)size);
        for (Map<String, Object> erManFileInfo2 : erManFileInfos) {
            companyIdSet.add((Long)erManFileInfo2.get("company_id"));
            adminOrgIdSet.add((Long)erManFileInfo2.get("adminorg_id"));
            positionIdSet.add((Long)erManFileInfo2.get("position_id"));
            stdPositionIdSet.add((Long)erManFileInfo2.get("stdposition_id"));
            jobIdSet.add((Long)erManFileInfo2.get("job_id"));
        }
        IHbpmService instance = IHbpmService.getInstance();
        Map<Long, Long> companyIdMap = instance.getAdminOrgHis(Lists.newArrayList((Iterable)companyIdSet));
        Map<Long, Long> adminOrgIdMap = instance.getAdminOrgHis(Lists.newArrayList((Iterable)adminOrgIdSet));
        Map<Long, Long> stdPositionIdMap = instance.getStdPosHis(Lists.newArrayList((Iterable)stdPositionIdSet));
        Map<Long, Long> positionIdMap = instance.getPosHis(Lists.newArrayList((Iterable)positionIdSet));
        Map<Long, Long> jobIdMap = instance.getJobHis(Lists.newArrayList((Iterable)jobIdSet));
        Set<Long> erManFileIDSet = erManFileIdMap.keySet();
        Map<Long, Boolean> erManFileIsPermissionMap = IHRCSService.getInstance().matchDataRuleForBdProp(entityId, "ermanfile", erManFileIDSet);
        log.info("getImportAuthority params erManFileIDSet={}, erManFileIsPermissionMap={}", erManFileIDSet, (Object)JSONObject.toJSONString(erManFileIsPermissionMap));
        HashSet personIdList = new HashSet(erManFileIdMap.size());
        HashSet employeeIdList = new HashSet(erManFileIdMap.size());
        erManFileInfos.forEach(erManFileInfo -> {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setEmpName((String)erManFileInfo.get("name"));
            personInfo.setEmpNumber((String)erManFileInfo.get("number"));
            personInfo.setPosTypeId((Long)erManFileInfo.get("postype_id"));
            personInfo.setStartDate((Date)erManFileInfo.get("startdate"));
            personInfo.setPersonId((Long)erManFileInfo.get("person_id"));
            personInfo.setEmpPhone((String)erManFileInfo.get("phone"));
            personInfo.setLocationId((Long)erManFileInfo.get("location_id"));
            personInfo.setAffiliateadminorgId((Long)erManFileInfo.get("affiliateadminorg_id"));
            personInfo.setOrgId((Long)erManFileInfo.get("org_id"));
            personInfo.setEmpGroupId((Long)erManFileInfo.get("empgroup_id"));
            personInfo.setEmployeeId((Long)erManFileInfo.get("employee_id"));
            Long companyId = (Long)erManFileInfo.get("company_id");
            personInfo.setSignedcompanyId(companyId);
            personInfo.setSignedcompanyVid((Long)companyIdMap.get(companyId));
            Long adminOrgId = (Long)erManFileInfo.get("adminorg_id");
            personInfo.setAdminOrgId(adminOrgId);
            personInfo.setAdminOrgVid((Long)adminOrgIdMap.get(adminOrgId));
            Long positionId = (Long)erManFileInfo.get("position_id");
            personInfo.setPositionId(positionId);
            personInfo.setPositionVid((Long)positionIdMap.get(positionId));
            Long stdPositionId = (Long)erManFileInfo.get("stdposition_id");
            personInfo.setStdpositionId(stdPositionId);
            personInfo.setStdpositionVid((Long)stdPositionIdMap.get(stdPositionId));
            Long jobId = (Long)erManFileInfo.get("job_id");
            personInfo.setJobId(jobId);
            personInfo.setJobVid((Long)jobIdMap.get(jobId));
            Object pkValue = erManFileInfo.get("id");
            personInfo.setErManFileId((Long)pkValue);
            personInfo.setSignedcompanyId((Long)erManFileInfo.get("company_id"));
            personInfo.setPermission(erManFileIsPermissionMap.getOrDefault(personInfo.getErManFileId(), Boolean.FALSE));
            personIdList.add(personInfo.getPersonId());
            map.put((ErManQueryParam)erManFileIdMap.get(personInfo.getErManFileId()), personInfo);
            personIdToInfo.put((Object)personInfo.getPersonId(), (Object)personInfo);
            employeeIdList.add(personInfo.getEmployeeId());
            employeeIdToInfo.put((Object)personInfo.getEmployeeId(), (Object)personInfo);
        });
        List perCreMap = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{Lists.newArrayList(personIdList), null, "hrpi_percre"});
        List trialPeriodMap = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchEmployeeAttachs", (Object[])new Object[]{Lists.newArrayList(employeeIdList), null, "hrpi_trialperiod"});
        List perAddressDyList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{Lists.newArrayList(personIdList), null, "hrpi_peraddress"});
        log.info("listBatchPersonAttachs params {}, result {}", personIdList, (Object)LogFilterUtil.getLogStrForList((List)perCreMap));
        if (!CollectionUtils.isEmpty((Collection)perCreMap)) {
            perCreMap.forEach(mapData -> {
                Long personId = (Long)mapData.get("person_id");
                Set personInfos = personIdToInfo.get((Object)personId);
                if (null != personInfos) {
                    personInfos.forEach(personInfo -> {
                        personInfo.setCardTypeId((Long)mapData.get("credentialstype_id"));
                        personInfo.setCardTypeName((String)mapData.get("credentialstype"));
                        personInfo.setCardNumber((String)mapData.get("number"));
                        personInfo.setNationalityId((Long)mapData.get("nationality_id"));
                    });
                }
            });
        }
        log.info("listBatchEmployeeAttachs params {}, result {}", employeeIdList, (Object)LogFilterUtil.getLogStrForList((List)trialPeriodMap));
        if (!CollectionUtils.isEmpty((Collection)trialPeriodMap)) {
            trialPeriodMap.forEach(mapData -> {
                Long employeeId = (Long)mapData.get("employee_id");
                Set personInfos = employeeIdToInfo.get((Object)employeeId);
                if (null != personInfos) {
                    personInfos.forEach(personInfo -> {
                        personInfo.setProbationstartDate((Date)mapData.get("startdate"));
                        personInfo.setProbationendDate((Date)mapData.get("preregulardate"));
                        personInfo.setProbationperiod(((Integer)mapData.get("probation")).intValue());
                        personInfo.setProbationperiodUnit((String)mapData.get("probationunit"));
                    });
                }
            });
        }
        log.info("listBatchPersonAttachs params {}, result {}", personIdList, (Object)LogFilterUtil.getLogStrForList((List)perAddressDyList));
        if (!CollectionUtils.isEmpty((Collection)perAddressDyList)) {
            perAddressDyList.forEach(perAddress -> {
                Long addressTypeId = (Long)perAddress.get("addresstype_id");
                Long personId = (Long)perAddress.get("person_id");
                Set personInfos = personIdToInfo.get((Object)personId);
                if (null != personInfos) {
                    personInfos.forEach(personInfo -> {
                        if (1020L == addressTypeId) {
                            personInfo.setHouseholdregister((String)perAddress.get("addressinfo"));
                        } else if (1030L == addressTypeId) {
                            personInfo.setResidentialaddress((String)perAddress.get("addressinfo"));
                        } else {
                            log.info("addressTypeId|{}", (Object)addressTypeId);
                        }
                    });
                }
            });
        }
        return map;
    }

    private static void setOldContract(IDataModel signBillModel) {
        String mainEntityType;
        DynamicObject dataEntity = signBillModel.getDataEntity();
        switch (mainEntityType = dataEntity.getDataEntityType().getName()) {
            case "hlcm_contractapplyrenew": 
            case "hlcm_contractapplychange": {
                DynamicObject oldContract = ContractSignApplyRepository.getInstance().getOldContract(dataEntity);
                signBillModel.setValue("oldcontract", (Object)oldContract);
                if (!HRStringUtils.equals((String)"hlcm_contractapplyrenew", (String)mainEntityType)) break;
                int renewCount = ContractSignApplyRepository.getInstance().getRenewCount(dataEntity);
                signBillModel.setValue("renewcount", (Object)renewCount);
                break;
            }
            case "hlcm_contractapplycancel": 
            case "hlcm_contractapplyend": {
                DynamicObject cancelContract = ContractSignApplyRepository.getInstance().getCancelContractByErManFile(dataEntity);
                signBillModel.setValue("oldcontract", (Object)cancelContract);
                break;
            }
            case "hlcm_empprotocolrelieve": {
                ContractRepository.getInstance().setEmploymentAgreementToBeTerminatedValue(signBillModel);
                break;
            }
        }
    }
}

