/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;

public class SignListPermissionUtils {
    private static final String STOP_PERMISSION = "2BEGMIB+UGLX";
    private static final String ARCHIVE_PERMISSION = "2BEGNF7Y+24F";
    private static final String BEGIN_PERMISSION = "2BEGOC9WTO6A";
    private static final String COMP_PERMISSION = "2BEGPA0K7+N/";
    private static final String C_SIGN_PERMISSION = "2BEGQLHRN9JX";
    private static final String CHANGE_PERMISSION = "4730fc9f000029ae";
    private static final String REFRESH_PERMISSION = "47150e89000000ac";

    public static boolean checkPermission(String formId, String permissionId) {
        return SignListPermissionUtils.checkPermission("1WXBXYCLS05D", formId, permissionId);
    }

    public static boolean checkPermission(String appId, String formId, String permissionId) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)formId, (String)permissionId);
    }

    public static boolean checkDataRulePermission(String formId, String permissionId, Object id) {
        if (HRObjectUtils.isEmpty((Object)id)) {
            return true;
        }
        Map<Object, Boolean> matchDataRule = IHRCSService.getInstance().matchDataRule(formId, permissionId, new Object[]{id});
        if (matchDataRule == null) {
            return true;
        }
        return matchDataRule.get(id);
    }

    public static boolean checkStopSignPermission(String formId) {
        return SignListPermissionUtils.checkPermission(formId, STOP_PERMISSION);
    }

    public static boolean checkStopSignDataRulePermission(String formId, Object id) {
        return SignListPermissionUtils.checkDataRulePermission(formId, STOP_PERMISSION, id);
    }

    public static boolean checkArchiveSignPermission(String formId) {
        return SignListPermissionUtils.checkPermission(formId, ARCHIVE_PERMISSION);
    }

    public static boolean checkArchiveSignDataRulePermission(String formId, Object id) {
        return SignListPermissionUtils.checkDataRulePermission(formId, ARCHIVE_PERMISSION, id);
    }

    public static boolean checkBeginSignPermission(String formId) {
        return SignListPermissionUtils.checkPermission(formId, BEGIN_PERMISSION);
    }

    public static boolean checkBeginSignDataRulePermission(String formId, Object id) {
        return SignListPermissionUtils.checkDataRulePermission(formId, BEGIN_PERMISSION, id);
    }

    public static boolean checkCompSignPermission(String formId) {
        return SignListPermissionUtils.checkPermission(formId, COMP_PERMISSION);
    }

    public static boolean checkCompSignDataRulePermission(String formId, Object id) {
        return SignListPermissionUtils.checkDataRulePermission(formId, COMP_PERMISSION, id);
    }

    public static boolean checkCSignSignPermission(String formId) {
        return SignListPermissionUtils.checkPermission(formId, C_SIGN_PERMISSION);
    }

    public static boolean checkCSignSignDataRulePermission(String formId, Object id) {
        return SignListPermissionUtils.checkDataRulePermission(formId, C_SIGN_PERMISSION, id);
    }

    public static boolean checkRefreshPermission(String formId) {
        return SignListPermissionUtils.checkPermission(formId, REFRESH_PERMISSION);
    }

    public static boolean checkRefreshDataRulePermission(String formId, Object id) {
        return SignListPermissionUtils.checkDataRulePermission(formId, REFRESH_PERMISSION, id);
    }

    public static boolean checkChangePermission(String formId) {
        return SignListPermissionUtils.checkPermission(formId, CHANGE_PERMISSION);
    }
}

