/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.vaildator.AbstractErrorMsgSignValidator;
import kd.hr.hlcm.common.enums.CertificateTypeEnum;

public class IsSignWayValidator
extends AbstractErrorMsgSignValidator {
    private static final Log LOGGER = LogFactory.getLog(IsSignWayValidator.class);
    private static final Set<Long> cardTypeSets = Sets.newHashSet((Object[])new Long[]{CertificateTypeEnum.ID_CARD.getCombKey(), CertificateTypeEnum.PASSPORT.getCombKey(), CertificateTypeEnum.HONG_KONG_AND_MACAO_RESIDENTS_MAINLAND_PASS.getCombKey(), CertificateTypeEnum.TAIWAN_RESIDENTS_MAINLAND_PASS.getCombKey()});

    @Override
    protected String realValidate(DynamicObject dynamicObject) {
        DynamicObject cardType = dynamicObject.getDynamicObject("cardtype");
        String signWay = dynamicObject.getString("signway");
        DynamicObjectCollection dys = dynamicObject.getDynamicObjectCollection("entryentity");
        if (cardType != null && "1".equals(signWay) && !cardTypeSets.contains(cardType.getLong("id"))) {
            this.errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5458\u5de5\u7684\u7b7e\u7f72\u65b9\u5f0f\u4e3a\u201c\u7535\u5b50\u7b7e\u7f72\u201d\uff0c\u8bc1\u4ef6\u7c7b\u578b\u4ec5\u652f\u6301\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u3001\u62a4\u7167\u3001\u6e2f\u6fb3\u5c45\u6c11\u5f80\u6765\u5185\u5730\u901a\u884c\u8bc1\u3001\u53f0\u6e7e\u5c45\u6c11\u6765\u5f80\u5927\u9646\u901a\u884c\u8bc1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IsSignWayValidator_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
            return this.errorMsg;
        }
        String tmpMsg = "";
        if (!CollectionUtils.isEmpty((Collection)dys) && !ContractSignUtils.notCheckEntryData(dynamicObject)) {
            if ("1".equals(signWay)) {
                tmpMsg = ContractSignApplyRepository.getInstance().checkEleSign(dys, tmpMsg);
            } else if ("2".equals(signWay)) {
                tmpMsg = ContractSignApplyRepository.getInstance().checkPaperSign(dys, tmpMsg);
            } else {
                LOGGER.warn("signWay|{}", (Object)signWay);
            }
        }
        this.errorMsg = tmpMsg;
        return this.errorMsg;
    }
}

