/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.vaildator.IsCrossBillTransfersValidator;
import kd.hr.hlcm.business.vaildator.IsCrossBillsQuitValidator;
import kd.hr.hlcm.business.vaildator.ValidatorHolder;
import kd.hr.hlcm.common.entity.NoticeEntity;

public class OtherAgreementValidator {
    private static final OtherAgreementValidator EMP_AGREEMENT_VALIDATOR = new OtherAgreementValidator();

    public static OtherAgreementValidator getInstance() {
        return EMP_AGREEMENT_VALIDATOR;
    }

    List<NoticeEntity> checkPersonInfoTip(DynamicObject applyBill) {
        ArrayList noticeEntities = Lists.newArrayListWithExpectedSize((int)5);
        noticeEntities.addAll(this.checkCommonOtherContractTip(applyBill));
        return noticeEntities;
    }

    private List<NoticeEntity> checkCommonOtherContractTip(DynamicObject appleNill) {
        ArrayList noticeEntitys = Lists.newArrayListWithExpectedSize((int)2);
        ValidatorHolder holder = new ValidatorHolder(appleNill, true);
        ValidatorHolder importValidatorHolderS = OtherAgreementValidator.getCommonValidatorHolderRenewTip(holder);
        Object errorNotice = importValidatorHolderS.startValidate();
        if (!HRObjectUtils.isEmpty((Object)errorNotice)) {
            String[] split;
            for (String errorMssage : split = errorNotice.toString().split(";")) {
                noticeEntitys.add(new NoticeEntity(Integer.valueOf(NoticeEntity.NoticeLevel.NOTICE.getVal()), errorMssage));
            }
        }
        return noticeEntitys.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static ValidatorHolder getCommonValidatorHolderRenewTip(ValidatorHolder holder) {
        holder.addValidator(new IsCrossBillsQuitValidator()).addValidator(new IsCrossBillTransfersValidator());
        return holder;
    }
}

