/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.vaildator.ValidatorBase;

public class ValidatorHolder {
    private boolean validateAll;
    private CopyOnWriteArrayList<ValidatorBase> validators;
    private DynamicObject signObj;

    public CopyOnWriteArrayList<ValidatorBase> getValidators() {
        return this.validators;
    }

    public void setValidators(CopyOnWriteArrayList<ValidatorBase> validators) {
        this.validators = validators;
    }

    public DynamicObject getSignObj() {
        return this.signObj;
    }

    public void setSignObj(DynamicObject signObj) {
        this.signObj = signObj;
    }

    public ValidatorHolder(DynamicObject signObj) {
        this.signObj = signObj;
        this.validateAll = false;
        this.validators = new CopyOnWriteArrayList();
    }

    public ValidatorHolder(DynamicObject signObj, boolean validateAll) {
        this.signObj = signObj;
        this.validateAll = validateAll;
        this.validators = new CopyOnWriteArrayList();
    }

    public ValidatorHolder addValidator(ValidatorBase validator) {
        this.validators.add(validator);
        return this;
    }

    public void removeValidator(ValidatorBase validator) {
        this.validators.remove(validator);
    }

    public Object startValidate() {
        return this.validateAll ? this.validateAll() : this.validateFirst();
    }

    private Object validateFirst() {
        for (ValidatorBase validator : this.validators) {
            Object validateResult = validator.validate(this.signObj);
            if (validator.continueValidate()) continue;
            return validateResult;
        }
        return null;
    }

    private String validateAll() {
        List<Object> allValidateError = this.getAllValidateError();
        String errMsg = allValidateError.stream().filter(validateResult -> !HRObjectUtils.isEmpty((Object)validateResult)).map(Object::toString).collect(Collectors.joining(";"));
        return HRObjectUtils.isEmpty((Object)errMsg) ? null : errMsg;
    }

    private List<Object> getAllValidateError() {
        ArrayList<Object> errorList = new ArrayList<Object>(10);
        for (ValidatorBase validator : this.validators) {
            Object validateResult = validator.validate(this.signObj);
            if (Objects.isNull(validateResult)) continue;
            errorList.add(validateResult);
        }
        return errorList;
    }

    public boolean isValidateAll() {
        return this.validateAll;
    }

    public void setValidateAll(boolean validateAll) {
        this.validateAll = validateAll;
    }
}

