/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.common.enums;

import java.util.Arrays;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;

public enum ActivityProcessStatusEnum {
    E_BEGIN_PENDING(SignTabEnum.E_BEGIN, ProcessStatusEnum.PENDING, new MultiLangEnumBridge("\u5f85\u53d1\u8d77", "ActivityProcessStatusEnum_0", "hr-hlcm-common")),
    E_BEGIN_PROCESSED(SignTabEnum.E_BEGIN, ProcessStatusEnum.PROCESSED, new MultiLangEnumBridge("\u5df2\u53d1\u8d77", "ActivityProcessStatusEnum_1", "hr-hlcm-common")),
    E_BEGIN_TERMINATED(SignTabEnum.E_BEGIN, ProcessStatusEnum.TERMINATED, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ActivityProcessStatusEnum_2", "hr-hlcm-common")),
    P_BEGIN_PENDING(SignTabEnum.P_BEGIN, ProcessStatusEnum.PENDING, new MultiLangEnumBridge("\u5f85\u53d1\u8d77", "ActivityProcessStatusEnum_0", "hr-hlcm-common")),
    P_BEGIN_PROCESSED(SignTabEnum.P_BEGIN, ProcessStatusEnum.PROCESSED, new MultiLangEnumBridge("\u5df2\u53d1\u8d77", "ActivityProcessStatusEnum_1", "hr-hlcm-common")),
    P_BEGIN_TERMINATED(SignTabEnum.P_BEGIN, ProcessStatusEnum.TERMINATED, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ActivityProcessStatusEnum_2", "hr-hlcm-common")),
    E_CSIGN_PENDING(SignTabEnum.E_CSIGN, ProcessStatusEnum.PENDING, new MultiLangEnumBridge("\u5f85\u7b7e\u7f72", "ActivityProcessStatusEnum_3", "hr-hlcm-common")),
    E_CSIGN_PROCESSING(SignTabEnum.E_CSIGN, ProcessStatusEnum.PROCESSING, new MultiLangEnumBridge("\u7b7e\u7f72\u4e2d", "ActivityProcessStatusEnum_7", "hr-hlcm-common")),
    E_CSIGN_PROCESSING_FAIL(SignTabEnum.E_CSIGN, ProcessStatusEnum.PROCESSING_FAIL, new MultiLangEnumBridge("\u7b7e\u7f72\u5931\u8d25", "ActivityProcessStatusEnum_8", "hr-hlcm-common")),
    E_CSIGN_PROCESSED(SignTabEnum.E_CSIGN, ProcessStatusEnum.PROCESSED, new MultiLangEnumBridge("\u5df2\u7b7e\u7f72", "ActivityProcessStatusEnum_4", "hr-hlcm-common")),
    E_CSIGN_TERMINATED(SignTabEnum.E_CSIGN, ProcessStatusEnum.TERMINATED, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ActivityProcessStatusEnum_2", "hr-hlcm-common")),
    P_COMP_PENDING(SignTabEnum.P_COMP, ProcessStatusEnum.PENDING, new MultiLangEnumBridge("\u5f85\u7b7e\u7f72", "ActivityProcessStatusEnum_3", "hr-hlcm-common")),
    P_COMP_PROCESSED(SignTabEnum.P_COMP, ProcessStatusEnum.PROCESSED, new MultiLangEnumBridge("\u5df2\u7b7e\u7f72", "ActivityProcessStatusEnum_4", "hr-hlcm-common")),
    P_COMP_TERMINATED(SignTabEnum.P_COMP, ProcessStatusEnum.TERMINATED, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ActivityProcessStatusEnum_2", "hr-hlcm-common")),
    E_CHECK_PENDING(SignTabEnum.E_CHECK, ProcessStatusEnum.PENDING, new MultiLangEnumBridge("\u5f85\u6838\u9a8c", "ActivityProcessStatusEnum_5", "hr-hlcm-common")),
    E_CHECK_PROCESSED(SignTabEnum.E_CHECK, ProcessStatusEnum.PROCESSED, new MultiLangEnumBridge("\u5df2\u6838\u9a8c", "ActivityProcessStatusEnum_6", "hr-hlcm-common")),
    E_CHECK_TERMINATED(SignTabEnum.E_CHECK, ProcessStatusEnum.TERMINATED, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ActivityProcessStatusEnum_2", "hr-hlcm-common")),
    P_CHECK_PENDING(SignTabEnum.P_CHECK, ProcessStatusEnum.PENDING, new MultiLangEnumBridge("\u5f85\u6838\u9a8c", "ActivityProcessStatusEnum_5", "hr-hlcm-common")),
    P_CHECK_PROCESSED(SignTabEnum.P_CHECK, ProcessStatusEnum.PROCESSED, new MultiLangEnumBridge("\u5df2\u6838\u9a8c", "ActivityProcessStatusEnum_6", "hr-hlcm-common")),
    P_CHECK_TERMINATED(SignTabEnum.P_CHECK, ProcessStatusEnum.TERMINATED, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ActivityProcessStatusEnum_2", "hr-hlcm-common"));

    SignTabEnum signTab;
    ProcessStatusEnum processStatus;
    MultiLangEnumBridge desc;

    private ActivityProcessStatusEnum(SignTabEnum signTab, ProcessStatusEnum processStatus, MultiLangEnumBridge desc) {
        this.signTab = signTab;
        this.processStatus = processStatus;
        this.desc = desc;
    }

    public SignTabEnum getSignTab() {
        return this.signTab;
    }

    public ProcessStatusEnum getProcessStatus() {
        return this.processStatus;
    }

    public MultiLangEnumBridge getDesc() {
        return this.desc;
    }

    public void setDesc(MultiLangEnumBridge desc) {
        this.desc = desc;
    }

    @Deprecated
    public static ActivityProcessStatusEnum getValueByKey(String formId, String processStatus) {
        return Arrays.stream(ActivityProcessStatusEnum.values()).filter(p -> HRStringUtils.equals((String)formId, (String)p.getSignTab().getSourceListFormId()) && HRStringUtils.equals((String)processStatus, (String)p.getProcessStatus().getValue())).findFirst().orElse(null);
    }

    public static ActivityProcessStatusEnum getValueByKey(Long activityId, String processStatus) {
        SignTabEnum signTabEnum = SignTabEnum.getTabEnumByActivity(activityId);
        if (signTabEnum == null) {
            return null;
        }
        return Arrays.stream(ActivityProcessStatusEnum.values()).filter(p -> p.signTab == signTabEnum && HRStringUtils.equals((String)processStatus, (String)p.getProcessStatus().getValue())).findFirst().orElse(null);
    }
}

