/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.common.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.ComboProp;
import kd.hr.hbp.common.util.HRStringUtils;

public class ComboUtils {
    private ComboUtils() {
    }

    public static String getComboOptionLocaleName(DynamicObject dataEntity, String propertyName) {
        LocaleString comboOptionName = ComboUtils.getComboOptionName(dataEntity, propertyName);
        return Optional.ofNullable(comboOptionName).map(LocaleString::getLocaleValue).orElse("");
    }

    public static LocaleString getComboOptionName(DynamicObject dataEntity, String propertyName) {
        Map<String, LocaleString> mapValues = ComboUtils.getComboMapValues(dataEntity, propertyName);
        Object defaultValue = ComboUtils.getComboProp(dataEntity, propertyName).getDefaultValue();
        String enumValue = dataEntity.getString(propertyName);
        if (HRStringUtils.isEmpty((String)enumValue)) {
            return new LocaleString("");
        }
        LocaleString value = mapValues.get(enumValue);
        LocaleString localeString = Optional.ofNullable(value).orElseGet(() -> (LocaleString)mapValues.get(defaultValue));
        if (Objects.isNull(localeString) && !mapValues.isEmpty()) {
            return mapValues.values().stream().findFirst().get();
        }
        return localeString;
    }

    public static Map<String, LocaleString> getComboMapValues(DynamicObject dataEntity, String propertyName) {
        ComboProp comboProp = ComboUtils.getComboProp(dataEntity, propertyName);
        List comboItems = comboProp.getComboItems();
        LinkedHashMap<String, LocaleString> result = new LinkedHashMap<String, LocaleString>(comboItems.size());
        comboItems.forEach(item -> result.put(item.getValue(), item.getName()));
        return result;
    }

    private static ComboProp getComboProp(DynamicObject dataEntity, String propertyName) {
        DynamicProperty property = dataEntity.getDynamicObjectType().getProperty(propertyName);
        if (!(property instanceof ComboProp)) {
            throw new RuntimeException(String.format(Locale.ROOT, "propertyName %s is not instanceof ComboProp", propertyName));
        }
        ComboProp comboProp = (ComboProp)property;
        return comboProp;
    }
}

