/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.common.utils;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DateUtil {
    private static final long ND = 86400000L;
    private static final long NH = 3600000L;

    public static String getDateDiff(Date nowDate, Date endDate) {
        long diff = HRDateTimeUtils.dateDiff((Date)nowDate, (Date)endDate);
        long day = 0L;
        long hour = 0L;
        if (diff != 0L) {
            day = diff / 86400000L;
            long remainHour = diff % 86400000L;
            long l = hour = remainHour == 0L ? 0L : remainHour / 3600000L;
        }
        if (0L == day) {
            return MessageFormat.format(ResManager.loadKDString((String)"{0}\u5c0f\u65f6", (String)"DateUtil_0", (String)"hr-hlcm-common", (Object[])new Object[0]), hour);
        }
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u5929{1}\u5c0f\u65f6", (String)"DateUtil_1", (String)"hr-hlcm-common", (Object[])new Object[0]), day, hour);
    }

    public static boolean isInterSection(Date startDateOne, Date endDateOne, Date startDateTwo, Date endDateTwo) {
        if (HRObjectUtils.isEmpty((Object)startDateOne) || HRObjectUtils.isEmpty((Object)startDateTwo)) {
            return true;
        }
        if (HRObjectUtils.isEmpty((Object)endDateOne) && HRObjectUtils.isEmpty((Object)endDateTwo)) {
            return true;
        }
        if (!HRObjectUtils.isEmpty((Object)endDateOne) && !HRObjectUtils.isEmpty((Object)endDateTwo)) {
            Date minEndDate;
            Date maxStartDate = startDateOne;
            if (maxStartDate.before(startDateTwo)) {
                maxStartDate = startDateTwo;
            }
            if (endDateTwo.before(minEndDate = endDateOne)) {
                minEndDate = endDateTwo;
            }
            return maxStartDate.before(minEndDate) || maxStartDate.getTime() == minEndDate.getTime();
        }
        if (!HRObjectUtils.isEmpty((Object)endDateOne) && HRObjectUtils.isEmpty((Object)endDateTwo)) {
            return startDateTwo.before(endDateOne);
        }
        if (HRObjectUtils.isEmpty((Object)endDateOne) && !HRObjectUtils.isEmpty((Object)endDateTwo)) {
            return startDateOne.before(endDateTwo);
        }
        return true;
    }

    public static Map<String, String> getTimeMask(String entityNumber, List<String> fieldIdList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return map;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        for (ControlAp control : formMeta.getItems()) {
            if (!(control instanceof FieldAp)) continue;
            for (String fieldId : fieldIdList) {
                if (!HRStringUtils.equals((String)control.getKey(), (String)fieldId)) continue;
                map.put(fieldId, ((FieldAp)control).getMask());
            }
        }
        return map;
    }

    public static String formatDateByMask(Date date, String mask) {
        if (date == null) {
            return "";
        }
        if (HRStringUtils.isEmpty((String)mask)) {
            mask = "yyyy-MM-dd";
        }
        String replaceMask = mask.replace("Y", "y").replace("m", "M").replace("D", "d");
        return HRDateTimeUtils.format((Date)date, (String)replaceMask);
    }
}

