/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.common.utils;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.entity.SignHeadInfoEntity;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractCategoryEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.ComboUtils;

public class HeadCardUtil {
    private static final Log LOGGER = LogFactory.getLog(HeadCardUtil.class);
    private static final String PAGE_PERSONCARD = "hlcm_contractperinfo";
    private static final String PAGE_BILLHEAD_NEW = "hlcm_billheadadd";
    private static final String PAGE_BILLHEAD_VIEW = "hlcm_contractheadinfo";
    private static final String HLCM_CONTRACTAPPLYMEW = "hlcm_contractapplynew";
    private static final String HLCM_CONTRACTAPPLYCANCEL = "hlcm_contractapplycancel";

    public static void showSignPersonHead(IFormView view, Object erManFileId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("personcardinfopanelap");
        formShowParameter.setFormId(PAGE_PERSONCARD);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("erManFileID", erManFileId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setStatus(OperationStatus.VIEW);
        view.showForm(formShowParameter);
    }

    private static void showViewParameter(IFormView view, SignHeadInfoEntity info, Long erManFileId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("headviewpanelap");
        formShowParameter.setFormId(PAGE_BILLHEAD_VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        HashMap<String, Serializable> customParams = new HashMap<String, Serializable>(1);
        customParams.put("data", info);
        customParams.put("erManFileID", erManFileId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setStatus(OperationStatus.VIEW);
        view.showForm(formShowParameter);
    }

    public static void showBillHeadView(IFormView view, DynamicObject dataEntity, String billTag) {
        view.setVisible(Boolean.FALSE, new String[]{"billheadpanelap", "personcardinfopanelap"});
        view.setVisible(Boolean.TRUE, new String[]{"headviewpanelap"});
        SignHeadInfoEntity info = new SignHeadInfoEntity();
        info.setOrg(dataEntity.getDynamicObject("org").getLocaleString("name").getLocaleValue());
        info.setBillname(HeadCardUtil.getBillName(dataEntity, billTag));
        info.setHandlestatus(ComboUtils.getComboOptionLocaleName(dataEntity, "handlestatus"));
        String formatCreateDate = HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYMEW, (String)"createtime", (Date)dataEntity.getDate("createtime"));
        info.setCreatetime(formatCreateDate);
        info.setCreator(dataEntity.getString("creator.name"));
        info.setBillno(dataEntity.getString("billno"));
        if (!HRStringUtils.equals((String)dataEntity.getString("businesstype"), (String)BusinessTypeEnum.CANCEL.getCombKey())) {
            info.setSignway(ComboUtils.getComboOptionLocaleName(dataEntity, "signway"));
        }
        info.setProtocoltype(dataEntity.getString("protocoltype"));
        HeadCardUtil.showViewParameter(view, info, dataEntity.getLong("ermanfile.id"));
    }

    public static String getBillName(DynamicObject dataEntity, String tag) {
        String billName = "";
        switch (tag) {
            case "1": {
                billName = ResManager.loadKDString((String)"\u7533\u8bf7\u5355", (String)"HeadCardUtil_0", (String)"hr-hlcm-common", (Object[])new Object[0]);
                break;
            }
            case "2": {
                billName = ResManager.loadKDString((String)"\u529e\u7406\u5355", (String)"HeadCardUtil_1", (String)"hr-hlcm-common", (Object[])new Object[0]);
                break;
            }
            case "3": {
                billName = ResManager.loadKDString((String)"\u7b7e\u7f72\u5355", (String)"HeadCardUtil_2", (String)"hr-hlcm-common", (Object[])new Object[0]);
                break;
            }
        }
        String protocolType = dataEntity.getString("protocoltype");
        String businessType = dataEntity.getString("businesstype");
        return ProtocolTypeEnum.loadKDStringByKey(protocolType) + BusinessTypeEnum.getValueByKey(businessType) + billName;
    }

    public static void showContractFileHeadOnViewStatus(IFormView view, DynamicObject dataEntity) {
        SignHeadInfoEntity info = new SignHeadInfoEntity();
        String contractcategory = dataEntity.getString("contractcategory");
        String contractCatString = ContractCategoryEnum.getValueByKey(contractcategory);
        LOGGER.warn("The.labor.contract.category.is={}", (Object)contractCatString);
        info.setName(contractCatString);
        String protocolType = dataEntity.getString("protocoltype");
        info.setBillname(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6863\u6848", (String)"HeadCardUtil_3", (String)"hr-hlcm-common", (Object[])new Object[0]), ProtocolTypeEnum.loadKDStringByKey(protocolType)));
        DynamicObject ermanOrg = dataEntity.getDynamicObject("ermanorg");
        info.setErmanorg(HRObjectUtils.isEmpty((Object)ermanOrg) ? "" : ermanOrg.getLocaleString("name").getLocaleValue());
        info.setSignstatus(ComboUtils.getComboOptionLocaleName(dataEntity, "signstatus"));
        info.setContractstatus(ComboUtils.getComboOptionLocaleName(dataEntity, "contractstatus"));
        info.setBusinesstype(ComboUtils.getComboOptionLocaleName(dataEntity, "businesstype"));
        info.setBillno(dataEntity.getString("number"));
        info.setSignway(ComboUtils.getComboOptionLocaleName(dataEntity, "signway"));
        HeadCardUtil.showViewParameter(view, info, dataEntity.getLong("ermanfile.id"));
    }

    public static void showEmpAndOtherContractFileHeadOnViewStatus(IFormView view, DynamicObject dataEntity) {
        SignHeadInfoEntity info = new SignHeadInfoEntity();
        String protocolType = dataEntity.getString("protocoltype");
        info.setBillname(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6863\u6848", (String)"HeadCardUtil_3", (String)"hr-hlcm-common", (Object[])new Object[0]), ProtocolTypeEnum.loadKDStringByKey(protocolType)));
        DynamicObject ermanOrg = dataEntity.getDynamicObject("ermanorg");
        info.setErmanorg(HRObjectUtils.isEmpty((Object)ermanOrg) ? "" : ermanOrg.getLocaleString("name").getLocaleValue());
        info.setSignstatus(ComboUtils.getComboOptionLocaleName(dataEntity, "signstatus"));
        info.setContractstatus(ComboUtils.getComboOptionLocaleName(dataEntity, "contractstatus"));
        info.setBusinesstype(ComboUtils.getComboOptionLocaleName(dataEntity, "businesstype"));
        info.setBillno(dataEntity.getString("number"));
        info.setSignway(ComboUtils.getComboOptionLocaleName(dataEntity, "signway"));
        HeadCardUtil.showViewParameter(view, info, dataEntity.getLong("ermanfile.id"));
    }

    public static void showBillHeadNew(IFormView view, DynamicObject dataEntity) {
        SignHeadInfoEntity info = new SignHeadInfoEntity();
        info.setBillname(HeadCardUtil.getBillName(dataEntity, "1"));
        info.setBillno(dataEntity.getString("billno"));
        String formatCreateDate = HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYCANCEL, (String)"createtime", (Date)dataEntity.getDate("createtime"));
        info.setCreatetime(formatCreateDate);
        info.setCreator(RequestContext.get().getUserName());
        String handleStatus = dataEntity.getString("handlestatus");
        info.setHandlestatus(HRStringUtils.isEmpty((String)handleStatus) ? "1" : handleStatus);
        HeadCardUtil.showNewParameter(view, info);
    }

    public static void showNewParameter(IFormView view, SignHeadInfoEntity info) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("billheadpanelap");
        formShowParameter.setFormId(PAGE_BILLHEAD_NEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        HashMap<String, SignHeadInfoEntity> customParams = new HashMap<String, SignHeadInfoEntity>(1);
        customParams.put("data", info);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setStatus(OperationStatus.VIEW);
        view.showForm(formShowParameter);
    }
}

