/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.contract;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.utils.EntityMetadataUtils;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.opplugin.validator.BatchSignValidator;
import kd.hr.hlcm.opplugin.validator.CancelProtocolMustInputValidator;
import kd.hr.hlcm.opplugin.validator.ContractBaseSaveValidator;
import kd.hr.hlcm.opplugin.validator.ContractTemplatePropValidator;
import kd.hr.hlcm.opplugin.validator.IDCardNumberValidator;
import kd.hr.hlcm.opplugin.validator.IsInitOrPaperDataValidator;
import kd.hr.hlcm.opplugin.validator.IsKDCloudSignValidator;
import kd.hr.hlcm.opplugin.validator.MatchSignWayValidator;
import kd.hr.hlcm.opplugin.validator.MuchValueValidator;
import kd.hr.hlcm.opplugin.validator.MustMainContractValidator;
import kd.hr.hlcm.opplugin.validator.NewSignRangesOverlapValidator;
import kd.hr.hlcm.opplugin.validator.SignDateCannotBeforeStartDateValidator;

public class ContractBaseSaveOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.addAll(EntityMetadataUtils.getEntityFields((String)"hlcm_contractapplybase"));
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new IsKDCloudSignValidator());
        args.addValidator((AbstractValidator)new IsInitOrPaperDataValidator());
        args.addValidator((AbstractValidator)new ContractBaseSaveValidator());
        args.addValidator((AbstractValidator)new MustMainContractValidator());
        args.addValidator((AbstractValidator)new NewSignRangesOverlapValidator());
        args.addValidator((AbstractValidator)new IDCardNumberValidator());
        args.addValidator((AbstractValidator)new MuchValueValidator());
        args.addValidator((AbstractValidator)new CancelProtocolMustInputValidator());
        args.addValidator((AbstractValidator)new MatchSignWayValidator());
        args.addValidator((AbstractValidator)new SignDateCannotBeforeStartDateValidator());
        args.addValidator((AbstractValidator)new BatchSignValidator());
        args.addValidator((AbstractValidator)new ContractTemplatePropValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("handlestatus"))) {
                dynamicObject.set("handlestatus", (Object)HandleStatusEnum.TOSUBMIT.getCombKey());
            }
            if (HRStringUtils.equals((String)dynamicObject.getString("handlestatus"), (String)HandleStatusEnum.ARCHIVE.getCombKey())) {
                dynamicObject.set("handlestatus", (Object)HandleStatusEnum.TOSUBMIT.getCombKey());
                dynamicObject.set("businessstatus", (Object)" ");
                dynamicObject.set("signstatus", (Object)" ");
                dynamicObject.set("auditor", null);
                dynamicObject.set("auditdate", null);
            }
            if (HRStringUtils.equals((String)"4", (String)dynamicObject.getString("businesstype"))) {
                DynamicObject cancelContract = dynamicObject.getDynamicObject("oldcontract");
                dynamicObject.set("actualsigncompany", (Object)cancelContract.getDynamicObject("actualsigncompany"));
                dynamicObject.set("actualsigncompanyhis", (Object)cancelContract.getDynamicObject("actualsigncompanyhis"));
                dynamicObject.set("periodtype", (Object)cancelContract.getDynamicObject("periodtype"));
                dynamicObject.set("periodunit", (Object)cancelContract.getString("periodunit"));
                dynamicObject.set("period", cancelContract.get("period"));
                dynamicObject.set("enddate", (Object)cancelContract.getDate("enddate"));
                dynamicObject.set("startdate", (Object)cancelContract.getDate("startdate"));
            }
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("period"))) {
                dynamicObject.set("period", (Object)BigDecimal.ZERO);
            }
            ContractSignApplyRepository.getInstance().setContractCode(dynamicObject);
            ContractSignUtils.setPeriodUnit((DynamicObject)dynamicObject);
            ContractSignUtils.setContractCategory((DynamicObject)dynamicObject);
            ContractSignUtils.HandleEntryInfo((DynamicObject)dynamicObject);
            ContractSignUtils.setSignTemplateHis((DynamicObject)dynamicObject);
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        SyncStartStatusService.getInstance().syncSignBillHandleStatusToPreWarn(dataEntities);
        SyncStartStatusService.getInstance().syncHirePersonStartStatus(dataEntities);
    }
}

