/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.contract;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.utils.EntityMetadataUtils;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.SignStatusEnum;
import kd.hr.hlcm.opplugin.validator.BatchSignValidator;
import kd.hr.hlcm.opplugin.validator.CancelProtocolMustInputValidator;
import kd.hr.hlcm.opplugin.validator.ContractBaseSaveValidator;
import kd.hr.hlcm.opplugin.validator.ContractTemplatePropValidator;
import kd.hr.hlcm.opplugin.validator.IsInitOrPaperDataValidator;
import kd.hr.hlcm.opplugin.validator.IsKDCloudSignValidator;
import kd.hr.hlcm.opplugin.validator.MatchSignWayValidator;
import kd.hr.hlcm.opplugin.validator.MuchValueValidator;
import kd.hr.hlcm.opplugin.validator.MustMainContractValidator;
import kd.hr.hlcm.opplugin.validator.NewSignRangesOverlapValidator;
import kd.hr.hlcm.opplugin.validator.SignDateCannotBeforeStartDateValidator;
import kd.hr.hlcm.opplugin.validator.SubmitExistProcValidator;

public class ContractBaseSubmitOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.addAll(EntityMetadataUtils.getEntityFields((String)"hlcm_contractapplybase"));
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SubmitExistProcValidator());
        args.addValidator((AbstractValidator)new IsKDCloudSignValidator());
        args.addValidator((AbstractValidator)new IsInitOrPaperDataValidator());
        args.addValidator((AbstractValidator)new ContractBaseSaveValidator());
        args.addValidator((AbstractValidator)new MustMainContractValidator());
        args.addValidator((AbstractValidator)new NewSignRangesOverlapValidator());
        args.addValidator((AbstractValidator)new MuchValueValidator());
        args.addValidator((AbstractValidator)new CancelProtocolMustInputValidator());
        args.addValidator((AbstractValidator)new MatchSignWayValidator());
        args.addValidator((AbstractValidator)new SignDateCannotBeforeStartDateValidator());
        args.addValidator((AbstractValidator)new BatchSignValidator());
        args.addValidator((AbstractValidator)new ContractTemplatePropValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            dynamicObject.set("handlestatus", (Object)HandleStatusEnum.PROCESSIN.getCombKey());
            dynamicObject.set("signstatus", (Object)SignStatusEnum.TO_SIGN.getCombKey());
            dynamicObject.set("billstatus", (Object)BillStatusEnum.STATUS_SUBMITED.getCode());
            ContractSignApplyRepository.getInstance().setContractCode(dynamicObject);
            ContractSignUtils.HandleEntryInfo((DynamicObject)dynamicObject);
            ContractSignUtils.setSignTemplateHis((DynamicObject)dynamicObject);
            ContractSignUtils.setPeriodUnit((DynamicObject)dynamicObject);
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        SyncStartStatusService.getInstance().syncSignBillHandleStatusToPreWarn(dataEntities);
        SyncStartStatusService.getInstance().syncHirePersonStartStatus(dataEntities);
    }
}

