/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.contract;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.opplugin.validator.ContractBaseUnSubmitValidator;

public class ContractBaseUnSubmitOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("handlestatus");
        fieldKeys.add("businessstatus");
        fieldKeys.add("person");
        fieldKeys.add("postype");
        fieldKeys.add("businesstype");
        fieldKeys.add("protocoltype");
        fieldKeys.add("employee");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new ContractBaseUnSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            dynamicObject.set("handlestatus", (Object)HandleStatusEnum.TOSUBMIT.getCombKey());
            dynamicObject.set("businessstatus", (Object)"");
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Object[] signApplyIds = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("id")).toArray();
        ISignActivity.getInstance().deletePreActivity(signApplyIds);
        SyncStartStatusService.getInstance().syncSignBillHandleStatusToPreWarn(dataEntities);
        SyncStartStatusService.getInstance().syncHirePersonStartStatus(dataEntities);
        List successIds = this.getOperationResult().getSuccessPkIds().stream().map(Object::toString).collect(Collectors.toList());
        ISignActivity.getInstance().batchRevocation(successIds, Long.valueOf(RequestContext.get().getCurrUserId()));
    }
}

