/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.contract;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hlcm.business.domian.service.hismodel.helper.ContractHisHelper;
import kd.hr.hlcm.opplugin.validator.ContractInitDeleteValidator;

public class ContractListDeleteOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("ermanfile");
        fieldKeys.add("boid");
        fieldKeys.add("person");
        fieldKeys.add("initbatch");
        fieldKeys.add("initstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new ContractInitDeleteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        String billType = this.billEntityType.getName();
        DynamicObject[] dataEntities = evt.getDataEntities();
        ContractHisHelper.getInstance().callHisModelForDelete(dataEntities);
        if (HRStringUtils.equals((String)"hlcm_contractfileother", (String)billType)) {
            return;
        }
        List pkList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        HRBaseServiceHelper otherProtocolHelper = new HRBaseServiceHelper("hlcm_contractsource");
        QFilter qFilter = new QFilter("maincontract", "in", pkList);
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter protocolFilter = new QFilter("protocoltype", "=", (Object)"3");
        QFilter[] qFilters = new QFilter[]{qFilter, protocolFilter, isCurrentVersion};
        DynamicObject[] otherProtocolDys = otherProtocolHelper.loadDynamicObjectArray(qFilters);
        ContractHisHelper.getInstance().callHisModelForUpdate(otherProtocolDys);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
    }
}

