/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.contract.activity;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;
import kd.hr.hlcm.opplugin.contract.activity.validator.ArchiveValidator;
import kd.hr.hlcm.opplugin.prevalidate.AbstractValidateOp;
import kd.hr.hlcm.opplugin.prevalidate.PreValidateOp;
import kd.hr.hlcm.opplugin.prevalidate.ValidatorOp;

@PreValidateOp(onPrepareProperties={"signapply"})
@ValidatorOp(validateIdKey="signapply.id")
public class ArchiveOp
extends AbstractValidateOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new ArchiveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        int length = dataEntities.length;
        ArrayList eActivityInsIds = new ArrayList(length);
        ArrayList pActivityInsIds = new ArrayList(length);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            Long activityInsId = dataEntity.getLong("signapply.activityins.id");
            String signWay = dataEntity.getString("signapply.signway");
            if (HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey())) {
                eActivityInsIds.add(activityInsId);
            } else {
                pActivityInsIds.add(activityInsId);
            }
        });
        ISignManageService.getInstance().archiveAfterTransaction((DynamicObject[])Arrays.stream(dataEntities).map(activity -> activity.getDynamicObject("signapply")).toArray(DynamicObject[]::new));
        ISignActivity.getInstance().batchAssignAndConsentTask(eActivityInsIds, SignTabEnum.E_CHECK);
        ISignActivity.getInstance().batchAssignAndConsentTask(pActivityInsIds, SignTabEnum.P_CHECK);
    }
}

