/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.contract.sign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;
import kd.hr.hlcm.opplugin.contract.sign.validator.BeginSignValidator;
import kd.hr.hlcm.opplugin.prevalidate.AbstractValidateOp;
import kd.hr.hlcm.opplugin.prevalidate.ValidatorOp;

@ValidatorOp
public class BeginSignOp
extends AbstractValidateOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new BeginSignValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List<DynamicObject> dataEntities = Arrays.stream(e.getDataEntities()).filter(dataEntity -> SignTabEnum.P_BEGIN.getActivityId().equals(dataEntity.getLong("activityins.activity.id")) || SignTabEnum.E_BEGIN.getActivityId().equals(dataEntity.getLong("activityins.activity.id"))).collect(Collectors.toList());
        int size = dataEntities.size();
        if (size == 0) {
            return;
        }
        ArrayList eActivityInsIds = new ArrayList(size);
        ArrayList pActivityInsIds = new ArrayList(size);
        dataEntities.forEach(dataEntity -> {
            Long activityInsId = dataEntity.getLong("activityins.id");
            String signWay = dataEntity.getString("signway");
            if (HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey())) {
                eActivityInsIds.add(activityInsId);
            } else {
                pActivityInsIds.add(activityInsId);
            }
        });
        ISignActivity.getInstance().batchAssignAndConsentTask(eActivityInsIds, SignTabEnum.E_BEGIN.getSourceListFormId());
        ISignActivity.getInstance().batchAssignAndConsentTask(pActivityInsIds, SignTabEnum.P_BEGIN.getSourceListFormId());
    }
}

