/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.contract.sign;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;
import kd.hr.hlcm.opplugin.contract.sign.validator.ConfirmArchiveValidator;
import kd.hr.hlcm.opplugin.prevalidate.AbstractValidateOp;
import kd.hr.hlcm.opplugin.prevalidate.PreValidateOp;
import kd.hr.hlcm.opplugin.prevalidate.ValidatorOp;

@ValidatorOp
@PreValidateOp(onPrepareProperties={"signway", "activityins.id", "contractnumber"})
public class ConfirmArchiveOp
extends AbstractValidateOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new ConfirmArchiveValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        int length = dataEntities.length;
        ArrayList eActivityInsIds = new ArrayList(length);
        ArrayList pActivityInsIds = new ArrayList(length);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            Long activityInsId = dataEntity.getLong("activityins.id");
            String signWay = dataEntity.getString("signway");
            if (HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey())) {
                eActivityInsIds.add(activityInsId);
            } else {
                pActivityInsIds.add(activityInsId);
            }
        });
        ISignManageService.getInstance().archiveAfterTransaction(dataEntities);
        ISignActivity.getInstance().batchAssignAndConsentTask(eActivityInsIds, SignTabEnum.E_CHECK.getSourceListFormId());
        ISignActivity.getInstance().batchAssignAndConsentTask(pActivityInsIds, SignTabEnum.P_CHECK.getSourceListFormId());
        String entityId = e.getDataEntities()[0].getDataEntityType().getName();
        for (DynamicObject dataEntity2 : dataEntities) {
            ISignActivity.getInstance().terminateOrDeleteTask(dataEntity2, entityId, null);
        }
    }
}

