/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSKeywordMappingService;
import kd.hr.hlcm.common.constants.HLCMTemplateConstants;

public class TemplateEditSaveOp
extends HRDataBaseOp {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final Log logger = LogFactory.getLog(TemplateEditSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("enable");
        fieldKeys.add("varmap_entryentity");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(KEY_ENTRYENTITY);
        DynamicObject entryNew = entryEntity.addNew();
        entryNew.set("changedate", (Object)dataEntity.getDate("modifytime"));
        entryNew.set("chchangereason", (Object)dataEntity.getString("changereason"));
        entryNew.set("hisid", (Object)dataEntity.getLong("vid"));
        entryNew.set("changeperson", (Object)dataEntity.getLong("modifier.id"));
        HRBaseServiceHelper hisServiceHelper = new HRBaseServiceHelper("hlcm_contracttemplatehis");
        DynamicObject dynamicObject = hisServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)dynamicObject, (Set)HLCMTemplateConstants.IGNORE_KEYS);
        long conTempId = dataEntity.getLong("id");
        long featureId = dataEntity.getLong("futurevid");
        long conTempVid = dataEntity.getLong("vid");
        dynamicObject.set("vid", (Object)conTempId);
        dynamicObject.set("id", (Object)featureId);
        dynamicObject = (DynamicObject)hisServiceHelper.saveOne(dynamicObject);
        long hisId = dynamicObject.getLong("id");
        dataEntity.set("vid", (Object)hisId);
        DynamicObjectCollection varMapEntryEntity = dataEntity.getDynamicObjectCollection("varmap_entryentity");
        long id = dataEntity.getLong("id");
        long vid = dataEntity.getLong("vid");
        try (TXHandle txHandle = TX.notSupported();){
            IHRCSKeywordMappingService.getInstance().saveKeyMapping(varMapEntryEntity, vid, id);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        String pkId = dataEntity.getString("id");
        HRBaseServiceHelper attachmentService = new HRBaseServiceHelper("bos_attachment");
        QFilter idFilter = new QFilter("finterid", "=", (Object)pkId);
        QFilter typeFilter1 = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplate");
        QFilter typeFilter2 = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplatech");
        DynamicObject[] queryAtt = attachmentService.loadDynamicObjectArray(new QFilter[]{idFilter, typeFilter2});
        ArrayList<DynamicObject> attachments = new ArrayList<DynamicObject>();
        for (DynamicObject att : queryAtt) {
            DynamicObject dynamicObject = attachmentService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)att, (DynamicObject)dynamicObject);
            dynamicObject.set("fbilltype", (Object)"hlcm_contracttemplatehis");
            dynamicObject.set("finterid", (Object)dataEntity.getString("vid"));
            String number = String.join((CharSequence)"-", "rc-upload", "templatehis", dynamicObject.getString("finterid"));
            dynamicObject.set("FNUMBER", (Object)number);
            attachments.add(dynamicObject);
        }
        if (attachments.size() > 0) {
            attachmentService.save(attachments.toArray(new DynamicObject[0]));
        }
        attachmentService.deleteByFilter(new QFilter[]{idFilter, typeFilter1});
        ArrayList<DynamicObject> attachments2 = new ArrayList<DynamicObject>();
        for (DynamicObject att : queryAtt) {
            DynamicObject dynamicObject = attachmentService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)att, (DynamicObject)dynamicObject);
            dynamicObject.set("fbilltype", (Object)"hlcm_contracttemplate");
            String number = String.join((CharSequence)"-", "rc-upload", "template", dynamicObject.getString("finterid"));
            dynamicObject.set("FNUMBER", (Object)number);
            attachments2.add(dynamicObject);
        }
        if (attachments.size() > 0) {
            attachmentService.save(attachments2.toArray(new DynamicObject[0]));
        }
    }

    public static void copyKeywordMapping(Long currentVid, Long featureVid) {
        try (TXHandle notSupported = TX.notSupported();){
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSKeywordMappingService", (String)"copyKeywordMappingFromOldToNew", (Object[])new Object[]{null, "hlcm_contracttemplate", currentVid, featureVid});
        }
        catch (Exception exception) {
            logger.error("IHRCSKeywordMappingService_copyKeywordMapping_error", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8005\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TemplateEditSaveOp_0", (String)"hr-hlcm-opplugin", (Object[])new Object[0]));
        }
    }
}

