/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.database;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.message.ISendMessageService;
import kd.hr.hlcm.business.message.SendMessageUtils;
import kd.hr.hlcm.business.mq.MsgCollaborationProducer;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.business.utils.OperationLogUtils;
import kd.hr.hlcm.common.enums.AuditStatusEnum;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.EmpCompSignStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.SignStatusEnum;
import kd.hr.hlcm.opplugin.validator.TerminateValidator;

public class TerminateWorkflowOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs propertysEventArgs) {
        List fieldKeys = propertysEventArgs.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("businessstatus");
        fieldKeys.add("empname");
        fieldKeys.add("empnumber");
        fieldKeys.add("terminatereason");
        fieldKeys.add("terminatereasondesc");
        fieldKeys.add("terminatedate");
        fieldKeys.add("terminateperson");
        fieldKeys.add("signstatus");
        fieldKeys.add("handlestatus");
        fieldKeys.add("protocoltype");
        fieldKeys.add("postype");
        fieldKeys.add("person");
        fieldKeys.add("businesstype");
        fieldKeys.add("activityins");
        fieldKeys.add("deadline");
        fieldKeys.add("empsignstatus");
        fieldKeys.add("compsignstatus");
        fieldKeys.add("entryentity.entryempsignstatus");
        fieldKeys.add("entryentity.entrycompsignstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new TerminateValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        String operationKey = beginOperationTransactionArgs.getOperationKey();
        String terminateReasonID = (String)this.getOption().getVariables().get("terminateReason");
        String terminateReasonDesc = (String)this.getOption().getVariables().get("terminateReasonDesc");
        Date nowDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        if (HRStringUtils.equals((String)operationKey, (String)"terminate")) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("terminatereason", (Object)terminateReasonID);
                dataEntity.set("terminatereasondesc", (Object)terminateReasonDesc);
                dataEntity.set("terminatedate", (Object)nowDate);
                dataEntity.set("terminateperson", (Object)currUserId);
                dataEntity.set("billstatus", (Object)BillStatusEnum.STATUS_DEPRECATED.getCode());
                dataEntity.set("auditstatus", (Object)AuditStatusEnum.STATUS_DEPRECATED.getCode());
                dataEntity.set("signstatus", (Object)SignStatusEnum.STOP_SIGNED.getCombKey());
                dataEntity.set("handlestatus", (Object)HandleStatusEnum.PROCESSEND.getCombKey());
                dataEntity.set("deadline", null);
                if (HRStringUtils.isNotEmpty((String)dataEntity.getString("businessstatus"))) {
                    dataEntity.set("businessstatus", (Object)"6");
                }
                dataEntity.set("empsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                dataEntity.set("compsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                for (DynamicObject entryEntityDy : dataEntity.getDynamicObjectCollection("entryentity")) {
                    entryEntityDy.set("entryempsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                    entryEntityDy.set("entrycompsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                }
                String entityId = beginOperationTransactionArgs.getDataEntities()[0].getDataEntityType().getName();
                ISignActivity.getInstance().terminateOrDeleteTask(dataEntity, entityId, null);
                ISignActivity.getInstance().terminateActivity(dataEntity);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.writeLog();
        DynamicObject[] dataEntities = e.getDataEntities();
        boolean isEmpty = HRObjectUtils.isEmpty((Object)dataEntities);
        if (!isEmpty && dataEntities.length > 0) {
            DynamicObject dataEntity = dataEntities[0];
            String name = dataEntity.getDataEntityType().getName();
            String tempMsgTerminate = SendMessageUtils.getTempNumTerminate((String)name);
            ArrayList personNumList = Lists.newArrayList();
            for (DynamicObject data : dataEntities) {
                String empNum = data.getString("empnumber");
                personNumList.add(empNum);
                MsgCollaborationProducer.getInstance().releaseMessage(data);
                SyncStartStatusService.getInstance().syncSignBillHandleStatusToPreWarn(data);
            }
            if (!CollectionUtils.isEmpty((Collection)personNumList) && HRStringUtils.isNotEmpty((String)tempMsgTerminate)) {
                long bizDataId = dataEntity.getLong("id");
                ISendMessageService.getInstance().sendTerminateMsg(Long.valueOf(bizDataId), tempMsgTerminate);
            }
        }
    }

    private void writeLog() {
        Map nameMap = (Map)this.operateMeta.get("name");
        String operationName = (String)nameMap.get("zh_CN");
        String entityId = this.billEntityType.getName();
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityId);
        MultiLangEnumBridge opDescription = null;
        opDescription = this.getOperationResult().isSuccess() ? new MultiLangEnumBridge("\u7ec8\u6b62\u6d41\u7a0b\u64cd\u4f5c\u6267\u884c\u6210\u529f\u3002", "TerminateWorkflowOp_0", "hr-hlcm-opplugin") : new MultiLangEnumBridge("\u7ec8\u6b62\u6d41\u7a0b\u64cd\u4f5c\u6267\u884c\u5931\u8d25\u3002", "TerminateWorkflowOp_1", "hr-hlcm-opplugin");
        Object key = this.operateMeta.get("key");
        OperationLogUtils.writeLog((String)appId, (String)entityId, (String)String.valueOf(key), (String)operationName, (MultiLangEnumBridge)opDescription, null);
    }
}

