/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.prevalidate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmEnum;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.opplugin.prevalidate.AbstractPreValidateOp;
import kd.hr.hlcm.opplugin.prevalidate.ValidatorOp;

public class AbstractValidateOp
extends AbstractPreValidateOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ValidatorOp validatorOp = ((Object)((Object)this)).getClass().getAnnotation(ValidatorOp.class);
        if (validatorOp == null) {
            return;
        }
        String validateIdKey = validatorOp.validateIdKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        List signBillIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getLong(validateIdKey)).collect(Collectors.toList());
        MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate((String)e.getOperationKey());
        Map errorMap = template.doOperation(signBillIds);
        ArrayList successDataEntities = new ArrayList(dataEntities.length - errorMap.size());
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            long id = dataEntity.getLong(validateIdKey);
            String errMsg = (String)errorMap.get(id);
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.operationResult.addErrorInfo((OperateErrorInfo)this.validationErrorInfo(dataEntity.getPkValue(), errMsg));
            } else {
                successDataEntities.add(dataEntity);
            }
        });
        this.operationResult.setSuccess(successDataEntities.size() == dataEntities.length);
        e.setDataEntities(successDataEntities.toArray(new DynamicObject[0]));
    }

    ValidationErrorInfo validationErrorInfo(Object pkValue, String errMsg) {
        ValidationErrorInfo validationErrorInfo = new ValidationErrorInfo();
        validationErrorInfo.setErrorLevel(ErrorLevel.FatalError.name());
        validationErrorInfo.setMessage(errMsg);
        validationErrorInfo.setPkValue(pkValue);
        return validationErrorInfo;
    }
}

