/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class BatchSignValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject signBill = extendedDataEntity.getDataEntity();
            if (!ProtocolTypeEnum.CON.getCombKey().equals(signBill.getString("protocoltype")) || !SignWayEnum.ELECTRONIC.getCombKey().equals(signBill.getString("signway"))) continue;
            DynamicObjectCollection entryEntityCollection = signBill.getDynamicObjectCollection("entryentity");
            long otherCount = entryEntityCollection.stream().map(dy -> dy.getLong("entrycontracttype.group.id")).filter(group -> !Objects.equals(ContractTypeCatEnum.CON.getPkId(), group)).count();
            if (!signBill.getBoolean("issignother") || IHRCSService.getInstance().isSupportBatchSign() || otherCount <= 0L) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4f7f\u7528\u7684\u7535\u5b50\u7b7e\u7f72\u5e73\u53f0\u4e0d\u652f\u6301\u6279\u91cf\u7b7e\u7f72\u529f\u80fd\uff0c\u8bf7\u4ec5\u9009\u62e9\u4e00\u4efd\u5408\u540c\u6216\u534f\u8bae\u3002", (String)"SignModeValidator_0", (String)"hr-hlcm-opplugin", (Object[])new Object[0]));
        }
    }
}

