/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;

public class ContractInitDeleteValidator
extends AbstractValidator {
    public void validate() {
        String entityKey = this.getEntityKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Object> pkList = new ArrayList<Object>(dataEntities.length);
        HashMap<Long, DynamicObject> pkAndDyMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            Object pkValue = dy.getPkValue();
            pkList.add(pkValue);
            pkAndDyMap.put((Long)dy.getPkValue(), dy);
        }
        HRBaseServiceHelper signHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        QFilter qFilter = new QFilter("oldcontract", "in", pkList);
        QFilter[] signFilters = new QFilter[]{qFilter};
        DynamicObject[] signDynamicObjects = signHelper.loadDynamicObjectArray(signFilters);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String message;
            DynamicObject dy = dataEntity.getDataEntity();
            if ((long)dy.getInt("initbatch") == 0L) {
                message = ResManager.loadKDString((String)"\u53ea\u53ef\u5220\u9664\u521d\u59cb\u5316\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"ContractInitDeleteValidator_4", (String)"hr-hlcm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, message);
                continue;
            }
            if ("0".equals(dy.getString("initstatus")) || "1".equals(dy.getString("initstatus"))) {
                message = ResManager.loadKDString((String)"\u53ea\u53ef\u5220\u9664\u521d\u59cb\u5316\u5b8c\u6210\u7684\u6570\u636e\u3002", (String)"ContractInitDeleteValidator_5", (String)"hr-hlcm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, message);
                continue;
            }
            StringBuilder errMsg = new StringBuilder();
            switch (entityKey) {
                case "hlcm_contract": {
                    HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contract");
                    QFilter oldFilter = new QFilter("oldcontract", "in", pkList);
                    QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"1");
                    QFilter protocolFilter = new QFilter("protocoltype", "=", (Object)"1");
                    QFilter[] qFilters = new QFilter[]{oldFilter, protocolFilter, isCurrentVersion};
                    DynamicObject[] oldDynamicObjects = contractHelper.loadDynamicObjectArray(qFilters);
                    errMsg.append(this.checkIsReference(oldDynamicObjects, signDynamicObjects, dy, pkAndDyMap));
                    break;
                }
                case "hlcm_contractfileemp": {
                    List signs = Arrays.stream(signDynamicObjects).filter(dynamicObject -> dynamicObject.getLong("oldcontract.id") == ((Long)dy.getPkValue()).longValue()).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(signs)) break;
                    errMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1s\u7684\u7528\u5de5\u534f\u8bae%2s\u5df2\u5728%3s\u7533\u8bf7\u5355%4s\u4e2d\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ContractInitDeleteValidator_6", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), dy.getString("name"), dy.getString("number"), BusinessTypeEnum.getValueByKey((String)((DynamicObject)signs.get(0)).getString("businesstype")), ((DynamicObject)signs.get(0)).getString("billno")));
                    break;
                }
                case "hlcm_contractfileother": {
                    break;
                }
            }
            if (!HRStringUtils.isNotEmpty((String)errMsg.toString())) continue;
            this.addFatalErrorMessage(dataEntity, errMsg.toString());
        }
    }

    private String checkIsReference(DynamicObject[] oldDynamicObjects, DynamicObject[] signDynamicObjects, DynamicObject dy, Map<Long, DynamicObject> pkAndDyMap) {
        List contracts = Arrays.stream(oldDynamicObjects).filter(dynamicObject -> dynamicObject.getLong("oldcontract.id") == ((Long)dy.getPkValue()).longValue()).collect(Collectors.toList());
        StringBuilder msg = new StringBuilder();
        if (!CollectionUtils.isEmpty(contracts)) {
            DynamicObject dynamicObject2 = (DynamicObject)contracts.get(0);
            if (!HRObjectUtils.isEmpty((Object)pkAndDyMap.get((Long)dynamicObject2.getPkValue()))) {
                String checkMsg = this.checkIsReference(oldDynamicObjects, signDynamicObjects, pkAndDyMap.get((Long)dynamicObject2.getPkValue()), pkAndDyMap);
                if (!HRStringUtils.isEmpty((String)checkMsg)) {
                    String number = dynamicObject2.getString("number");
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8be5\u5408\u540c\u662f\u52b3\u52a8\u5408\u540c%1$s\u7684\u539f\u5408\u540c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ContractInitDeleteValidator_0", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), number));
                }
            } else {
                String number = dynamicObject2.getString("number");
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8be5\u5408\u540c\u662f\u52b3\u52a8\u5408\u540c%1$s\u7684\u539f\u5408\u540c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ContractInitDeleteValidator_0", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), number));
            }
        }
        if (HRStringUtils.isNotEmpty((String)msg.toString())) {
            return msg.toString();
        }
        List signs = Arrays.stream(signDynamicObjects).filter(dynamicObject -> dynamicObject.getLong("oldcontract.id") == ((Long)dy.getPkValue()).longValue()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(signs)) {
            if (HRStringUtils.isNotEmpty((String)msg.toString())) {
                msg.append(';');
            }
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u7684\u52b3\u52a8\u5408\u540c%2$s\u5df2\u5b58\u5728\u3002", (String)"ContractInitDeleteValidator_1", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), dy.getString("name"), dy.getString("number")));
            for (int i = 0; i < signs.size(); ++i) {
                DynamicObject sign = (DynamicObject)signs.get(i);
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7533\u8bf7\u5355%2$s", (String)"ContractInitDeleteValidator_2", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), BusinessTypeEnum.getValueByKey((String)sign.getString("businesstype")), sign.getString("billno")));
                if (i >= signs.size() - 1) continue;
                msg.append('\u3001');
            }
            msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e2d\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"ContractInitDeleteValidator_3", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)msg.toString())) {
            msg.append('\u3002');
        }
        return msg.toString().trim();
    }
}

