/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.utils.HLCMDateUtils;
import kd.hr.hlcm.common.entity.PosTypePerson;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class NewSignRangesOverlapValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList filters = Lists.newArrayListWithCapacity((int)dataEntities.length);
        Function<DynamicObject, PosTypePerson> keyFunction = dataEntity -> {
            long posTypeId = Optional.ofNullable(dataEntity.getDynamicObject("postype")).map(dy -> dy.getLong("id")).orElse(0L);
            return new PosTypePerson(Long.valueOf(posTypeId), Long.valueOf(dataEntity.getLong("person_id")));
        };
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
            if (!HRStringUtils.equals((String)dataEntity2.getString("businesstype"), (String)BusinessTypeEnum.NEW.getCombKey()) || !HRStringUtils.equals((String)dataEntity2.getString("protocoltype"), (String)ProtocolTypeEnum.CON.getCombKey())) continue;
            PosTypePerson posTypePerson = keyFunction.apply(dataEntity2);
            QFilter personFilter = new QFilter("person", "=", (Object)posTypePerson.getPersonId()).and(new QFilter("postype", "=", (Object)posTypePerson.getPosTypeId()));
            filters.add(personFilter);
        }
        if (filters.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey())).and(new QFilter("initstatus", "=", (Object)"2"));
        filters.stream().reduce((f1, f2) -> f1.or(f2)).ifPresent(arg_0 -> ((QFilter)filter).and(arg_0));
        DynamicObject[] personContracts = HLCMCommonRepository.queryDynamicObjects((String)"hlcm_contractsource", (String)"number,person.id,postype.id,startdate,enddate,actualenddate,planenddate", (QFilter[])new QFilter[]{filter});
        Map<PosTypePerson, List<DynamicObject>> contractMap = Arrays.stream(personContracts).collect(Collectors.groupingBy(keyFunction));
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            List<DynamicObject> contracts;
            DynamicObject dataEntity3 = extendedDataEntity.getDataEntity();
            if (!HRStringUtils.equals((String)dataEntity3.getString("businesstype"), (String)BusinessTypeEnum.NEW.getCombKey()) || !HRStringUtils.equals((String)dataEntity3.getString("protocoltype"), (String)ProtocolTypeEnum.CON.getCombKey()) || CollectionUtils.isEmpty(contracts = contractMap.get(keyFunction.apply(dataEntity3)))) continue;
            Date startDate0 = dataEntity3.getDate("startdate");
            Date endDate0 = dataEntity3.getDate("enddate");
            this.contractRangesOverlap(startDate0, endDate0, contracts).ifPresent(dy -> this.addMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3001\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e0e%s\u7684\u5408\u540c\u751f\u6548\u65f6\u95f4\u5b58\u5728\u4ea4\u53c9\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"NewSignRangesOverlapValidator_0", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), dy.getString("number"))));
        }
    }

    private Optional<DynamicObject> contractRangesOverlap(Date startDate0, Date endDate0, List<DynamicObject> contracts) {
        for (DynamicObject contract : contracts) {
            Date endDate;
            Date startDate = contract.getDate("startdate");
            if (!HLCMDateUtils.rangesOverlap((Date)startDate0, (Date)endDate0, (Date)startDate, (Date)(endDate = contract.getDate("actualenddate") != null ? contract.getDate("actualenddate") : (contract.getDate("planenddate") != null ? contract.getDate("planenddate") : contract.getDate("enddate"))))) continue;
            return Optional.of(contract);
        }
        return Optional.empty();
    }
}

