/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.contractapply;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.business.utils.ContractPageLoadUtils;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.CrossTypeEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.PeriodUnitEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.enums.RuleEngineSceneEnum;
import kd.hr.hlcm.common.utils.HeadCardUtil;
import kd.hr.hlcm.formplugin.utils.CardInfoHelper;

public class ContractSignServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ContractSignServiceHelper.class);
    private static final ContractSignServiceHelper CONTRACT_BASE_SIGN_SERVICE_HELPER = new ContractSignServiceHelper();

    private ContractSignServiceHelper() {
    }

    public static ContractSignServiceHelper getInstance() {
        return CONTRACT_BASE_SIGN_SERVICE_HELPER;
    }

    public void setProbationPeriod(IDataModel model) {
        int probationPeriod = model.getDataEntity().getInt("probationperiod");
        if (probationPeriod == 0) {
            model.setValue("probationperiodunit", null);
        } else {
            String probationUnit = ProbationUnitEnum.getValueByKey((String)model.getDataEntity().getString("probationunit"));
            model.setValue("probationperiodunit", (Object)(probationPeriod + probationUnit));
        }
    }

    public void setPersonCardAllInfo(IFormView view, IDataModel model) {
        CardInfoHelper instance = CardInfoHelper.getInstance();
        String businessType = model.getDataEntity().getString("businesstype");
        if (HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.NEW.getCombKey())) {
            instance.setMainConInfo(model.getDataEntity(), view);
            instance.setNewConInfo(model, view);
        } else if (HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.RENEW.getCombKey())) {
            instance.setMainConInfo(model.getDataEntity(), view);
            instance.setRenewConInfo(model, view);
        } else if (HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.CHANGE.getCombKey())) {
            instance.setMainConInfo(model.getDataEntity(), view);
            instance.setChangeConInfo(model, view);
        } else if (Arrays.asList(BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()).contains(businessType)) {
            DynamicObject oldContract = model.getDataEntity().getDynamicObject("oldcontract");
            if (Objects.nonNull(oldContract)) {
                DynamicObject dataEntity = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_contract", null, (Object)oldContract.getPkValue());
                ContractPageLoadUtils.getInstance().setMainContractInfo(dataEntity, view);
            }
        } else {
            LOGGER.warn("businessType|{}", (Object)businessType);
        }
    }

    public String getCrossIdTypeByCrossType(String crossType) {
        String crossId = null;
        if (HRStringUtils.equals((String)CrossTypeEnum.QUITE.getCode(), (String)crossType)) {
            crossId = "crossquiteactionId";
        } else if (HRStringUtils.equals((String)CrossTypeEnum.TRANSFER.getCode(), (String)crossType)) {
            crossId = "crosstransferactionId";
        } else if (HRStringUtils.equals((String)CrossTypeEnum.RETIRE.getCode(), (String)crossType)) {
            crossId = "crossretireactionId";
        } else if (HRStringUtils.equals((String)CrossTypeEnum.EXIST_FUTURE.getCode(), (String)crossType)) {
            crossId = "existfutureactionid";
        } else {
            LOGGER.warn("crossType|{}", (Object)crossType);
        }
        return crossId;
    }

    protected void setContractInfoByRuleEngine(IFormView view, IDataModel model, String operatorId) {
        if (HRObjectUtils.isEmpty((Object)model.getValue("ermanfile"))) {
            return;
        }
        String billFormId = view.getEntityId();
        String businessTypeEnum = ContractSignUtils.getBusinessTypeByBillFormId((String)billFormId);
        if (Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.STOP.getCombKey()}).contains(businessTypeEnum)) {
            return;
        }
        RuleEngineSceneEnum sceneEnum = null;
        if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessTypeEnum)) {
            sceneEnum = RuleEngineSceneEnum.CONTRACT_NEW;
        } else if (HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessTypeEnum)) {
            sceneEnum = RuleEngineSceneEnum.CONTRACT_RENEW;
        } else if (HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessTypeEnum)) {
            sceneEnum = RuleEngineSceneEnum.CONTRACT_CHANGE;
        } else if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessTypeEnum)) {
            sceneEnum = RuleEngineSceneEnum.CONTRACT_CANCEL;
        } else {
            LOGGER.warn("businessTypeEnum|{}", (Object)businessTypeEnum);
        }
        if (sceneEnum != null) {
            this.callRuleEngine(view, model, sceneEnum.getSceneNumber(), sceneEnum.getCommonParam(), operatorId);
        }
    }

    public void setProtocolInfoByRuleEngine(IFormView view, IDataModel model, String operatorId) {
        String billFormId = view.getEntityId();
        if (HRStringUtils.equals((String)"hlcm_empprotocolrelieve", (String)billFormId)) {
            return;
        }
        RuleEngineSceneEnum sceneEnum = null;
        switch (billFormId) {
            case "hlcm_empprotocolnew": {
                sceneEnum = RuleEngineSceneEnum.EMP_NEW;
                break;
            }
            case "hlcm_otheragreements": {
                sceneEnum = RuleEngineSceneEnum.OTHER_NEW;
                break;
            }
        }
        if (sceneEnum != null) {
            this.callRuleEngine(view, model, sceneEnum.getSceneNumber(), sceneEnum.getCommonParam(), operatorId);
        }
    }

    private void callRuleEngine(IFormView view, IDataModel model, String sceneNumber, String commonInOutParam, String operatorId) {
        DynamicObject erManFile = (DynamicObject)model.getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            LOGGER.info("ContractSignServiceHelper========callRuleEngine======erManFile=is=empty");
            return;
        }
        Long erManFileId = (Long)erManFile.getPkValue();
        Map erManFileInfo = IHSPMFileService.getInstance().getCardFieldByErManFileId(erManFileId);
        if (CollectionUtils.isEmpty((Map)erManFileInfo)) {
            LOGGER.info("ContractSignServiceHelper========callRuleEngine======erManFileId|{}======erManFileInfos|{}", (Object)erManFileId, (Object)JSONObject.toJSONString((Object)erManFileInfo));
            return;
        }
        Map<String, Object> inputMap = this.getInputMap(erManFileInfo, model, commonInOutParam);
        try {
            Map ruleEngineResult = ContractSignUtils.callRuleEngine((String)"hlcm", (String)sceneNumber, (String)model.getDataEntity().getString("org.number"), null, inputMap);
            LOGGER.info("ContractSignServiceHelper========callRuleEngine======stringObjectMap|{}", (Object)ruleEngineResult.toString());
            if (!HRStringUtils.equals((String)"200", (String)((String)ruleEngineResult.get("responseCode")))) {
                LOGGER.info("ContractSignServiceHelper========callRuleEngine======responseCode|{}", ruleEngineResult.get("responseCode"));
                return;
            }
            List policyResultsList = (List)ruleEngineResult.get("policyResults");
            if (CollectionUtils.isEmpty((Collection)policyResultsList)) {
                LOGGER.info("ContractSignServiceHelper========callRuleEngine======policyResultsList=is=Empty");
                return;
            }
            Collections.reverse(policyResultsList);
            HashMap<String, String> tipResult = new HashMap<String, String>(4);
            for (Object policy : policyResultsList) {
                Map policyMap = (Map)policy;
                List ruleResultList = (List)policyMap.get("ruleResults");
                if (!CollectionUtils.isEmpty((Collection)ruleResultList)) {
                    ruleResultList.forEach(rule -> {
                        Map matchResults = (Map)rule.get("matchResults");
                        this.setValueByRuleEngineResult(matchResults, commonInOutParam, operatorId, view, model, tipResult);
                    });
                }
                Map defaultResults = (Map)policyMap.get("defaultResults");
                this.setValueByRuleEngineResult(defaultResults, commonInOutParam, operatorId, view, model, tipResult);
            }
            this.showTipResult(tipResult, view);
            LOGGER.info("ContractSignServiceHelper========callRuleEngine======tipResult|{}", (Object)tipResult.size());
        }
        catch (Exception ex) {
            LOGGER.error("ContractSignServiceHelper========callRuleEngine======error..", (Throwable)ex);
        }
    }

    private Map<String, Object> getInputMap(Map<String, Object> erManFileInfo, IDataModel model, String commonInOutParam) {
        List empJobRelList;
        List contrWorkLoc;
        HashMap<String, Object> inputMap = new HashMap<String, Object>(7);
        inputMap.put("hrpi_employee", CommonRepository.queryDynamicObjectByPk((String)"hrpi_employee", (String)"", (Object)erManFileInfo.get("employee_id")));
        inputMap.put("hrpi_depemp", CommonRepository.queryDynamicObjectByPk((String)"hrpi_depemp", (String)"", (Object)erManFileInfo.get("depemp_id")));
        inputMap.put("hrpi_cmpemp", CommonRepository.queryDynamicObjectByPk((String)"hrpi_cmpemp", (String)"", (Object)erManFileInfo.get("cmpemp_id")));
        inputMap.put(commonInOutParam, model.getDataEntity());
        List perNonPropList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{erManFileInfo.get("person_id"), "hrpi_pernontsprop"});
        if (!CollectionUtils.isEmpty((Collection)perNonPropList)) {
            inputMap.put("hrpi_pernontsprop", CommonRepository.queryDynamicObjectByPk((String)"hrpi_pernontsprop", (String)"", ((Map)perNonPropList.get(0)).get("id")));
        }
        if (!CollectionUtils.isEmpty((Collection)(contrWorkLoc = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{erManFileInfo.get("employee_id"), "hrpi_contrworkloc"})))) {
            inputMap.put("hrpi_contrworkloc", CommonRepository.queryDynamicObjectByPk((String)"hrpi_contrworkloc", (String)"", ((Map)contrWorkLoc.get(0)).get("id")));
        }
        if (!CollectionUtils.isEmpty((Collection)(empJobRelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{erManFileInfo.get("employee_id"), "hrpi_empjobrel"})))) {
            inputMap.put("hrpi_empjobrel", CommonRepository.queryDynamicObjectByPk((String)"hrpi_empjobrel", (String)"", ((Map)empJobRelList.get(0)).get("id")));
        }
        return inputMap;
    }

    private void setValueByRuleEngineResult(Map defaultResults, String commonInOutParam, String operatorId, IFormView formView, IDataModel dataModel, Map<String, String> tipResult) {
        String entityId = formView.getEntityId();
        if (!CollectionUtils.isEmpty((Map)defaultResults)) {
            Object tempObject;
            DynamicObject applyObject = (DynamicObject)defaultResults.get(commonInOutParam);
            if (!HRStringUtils.equals((String)"actualsigncompany", (String)operatorId) && !HRStringUtils.equals((String)"hlcm_contractapplycancel", (String)entityId)) {
                this.setSignCompany(applyObject, dataModel, tipResult);
            }
            if (!HRStringUtils.equals((String)"signway", (String)operatorId)) {
                this.setSignWay(applyObject, dataModel, tipResult);
            }
            if ((tempObject = defaultResults.get("hlcm_contracttemplate")) instanceof DynamicObject) {
                this.setContractTemplate(new DynamicObject[]{(DynamicObject)tempObject}, formView, dataModel, tipResult);
            } else if (tempObject instanceof DynamicObject[]) {
                this.setContractTemplate((DynamicObject[])tempObject, formView, dataModel, tipResult);
            } else if (tempObject instanceof DynamicObjectCollection) {
                DynamicObjectCollection dc = (DynamicObjectCollection)tempObject;
                this.setContractTemplate((DynamicObject[])dc.toArray((Object[])new DynamicObject[0]), formView, dataModel, tipResult);
            } else {
                LOGGER.warn("tempObject is not instanceof DynamicObject");
            }
            if (!HRStringUtils.equals((String)"cardtype", (String)operatorId) && !HRStringUtils.equals((String)"hlcm_contractapplycancel", (String)entityId)) {
                this.setCardType(applyObject, dataModel, tipResult);
            }
        }
    }

    private void setSignCompany(DynamicObject dy, IDataModel model, Map<String, String> tipResult) {
        HRBaseServiceHelper signCompanyHelper;
        DynamicObject signCompanyDy;
        DynamicObject suggestSignCompany;
        if (!Objects.isNull(dy) && !Objects.isNull(suggestSignCompany = dy.getDynamicObject("suggestsigncompany")) && Objects.nonNull(signCompanyDy = (signCompanyHelper = new HRBaseServiceHelper("hbss_signcompany")).queryOne("id,vid,enable", suggestSignCompany.getPkValue())) && signCompanyDy.getBoolean("enable")) {
            model.setValue("suggestsigncompany", (Object)signCompanyDy);
            model.setValue("suggestsigncomphis", (Object)signCompanyDy.getLong("vid"));
            model.setValue("actualsigncompany", (Object)signCompanyDy);
            model.setValue("actualsigncompanyhis", (Object)signCompanyDy.getLong("vid"));
            tipResult.put("suggestsigncompany", ResManager.loadKDString((String)"\u5e94\u7b7e\u5355\u4f4d", (String)"ContractSignServiceHelper_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setSignWay(DynamicObject dy, IDataModel model, Map<String, String> tipResult) {
        String signWay;
        if (!Objects.isNull(dy) && !HRStringUtils.isEmpty((String)(signWay = dy.getString("signway")))) {
            model.setValue("signway", (Object)signWay);
            tipResult.put("signway", ResManager.loadKDString((String)"\u7b7e\u7f72\u65b9\u5f0f", (String)"ContractSignServiceHelper_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setCardType(DynamicObject dy, IDataModel model, Map<String, String> tipResult) {
        if (dy != null) {
            DynamicObject cardTypeDy = dy.getDynamicObject("cardtype");
            DynamicObject cardTypeValue = model.getDataEntity().getDynamicObject("cardtype");
            LOGGER.info("setCardType#cardTypeDy={},cardTypeValue={}", (Object)cardTypeDy, (Object)cardTypeValue);
            if (!HRObjectUtils.isEmpty((Object)cardTypeDy) && !HRObjectUtils.isEmpty((Object)cardTypeValue)) {
                Long engineCardTypeId = (Long)cardTypeDy.getPkValue();
                Long cardTypeId = (Long)cardTypeValue.getPkValue();
                LOGGER.info("setCardType#engineCardTypeId={},cardTypeId={}", (Object)engineCardTypeId, (Object)cardTypeId);
                if (!HRObjectUtils.equals((Object)engineCardTypeId, (Object)cardTypeId)) {
                    model.setValue("cardtype", (Object)cardTypeDy);
                    model.setValue("cardnumber", (Object)"");
                }
                tipResult.put("cardtype", ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"ContractSignServiceHelper_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setContractTemplate(DynamicObject[] dynamicObjects, IFormView formView, IDataModel dataModel, Map<String, String> tipResult) {
        List selectedIds = dataModel.getDataEntity(true).getDynamicObjectCollection("entryentity").stream().map(dy -> dy.getLong("contracttemplate.id")).collect(Collectors.toList());
        List<Long> templateIds = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).filter(id -> !selectedIds.contains(id)).collect(Collectors.toList());
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("status", "=", (Object)"C").and("id", "in", templateIds);
        DynamicObject[] contractTemplates = CommonRepository.query((String)"hlcm_contracttemplate", (String)"id,contracttype", (QFilter[])new QFilter[]{filter});
        if (contractTemplates.length == 0) {
            return;
        }
        DynamicObject entryRowEntity = dataModel.getEntryRowEntity("entryentity", 0);
        if (entryRowEntity != null && HRObjectUtils.isEmpty((Object)entryRowEntity.getDynamicObject("contracttemplate"))) {
            dataModel.deleteEntryRow("entryentity", 0);
        }
        formView.getModel().beginInit();
        boolean isConNew = ContractSignUtils.isConNew((String)formView.getEntityId());
        if (isConNew || "hlcm_contractapplycancel".equals(formView.getEntityId())) {
            if (isConNew) {
                this.setContractInfoTemplate(templateIds, contractTemplates, formView);
            }
            contractTemplates = (DynamicObject[])Arrays.stream(contractTemplates).filter(val -> val.getLong("contracttype.group.id") == ContractTypeCatEnum.OTHER.getPkId()).toArray(DynamicObject[]::new);
        }
        if ((contractTemplates = this.keepLastOneTemplate(formView.getEntityId(), dynamicObjects, contractTemplates)).length == 0) {
            LOGGER.info("contractTemplates length is zero");
            return;
        }
        int[] rows = dataModel.batchCreateNewEntryRow("entryentity", contractTemplates.length);
        for (int i = 0; i < contractTemplates.length; ++i) {
            dataModel.setValue("contracttemplate", (Object)contractTemplates[i], rows[i]);
            dataModel.setValue("opperson", (Object)RequestContext.get().getCurrUserId(), rows[i]);
            dataModel.setValue("opdate", (Object)new Date(), rows[i]);
            dataModel.setValue("attachmentfield1", (Object)this.getAttachmentName(contractTemplates[i]), rows[i]);
            if (!ContractSignUtils.isContractNotStop((String)formView.getEntityId())) continue;
            this.setContractForOther(formView, contractTemplates, rows, i);
        }
        formView.getModel().endInit();
        formView.updateView("entryentity");
        tipResult.put("contracttemplate", ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f", (String)"ContractSignServiceHelper_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject[] keepLastOneTemplate(String entityId, DynamicObject[] dynamicObjects, DynamicObject[] contractTemplates) {
        if (HRStringUtils.equals((String)"hlcm_contractapplycancel", (String)entityId) && contractTemplates.length > 1) {
            Map<Long, DynamicObject> templateIdToDyn = Arrays.stream(contractTemplates).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
            for (int i = dynamicObjects.length - 1; i >= 0; --i) {
                long id = dynamicObjects[i].getLong("id");
                if (!templateIdToDyn.containsKey(id)) continue;
                contractTemplates = new DynamicObject[]{templateIdToDyn.get(id)};
                break;
            }
        }
        return contractTemplates;
    }

    private void setContractForOther(IFormView formView, DynamicObject[] contractTemplates, int[] rows, int index) {
        IDataModel dataModel = formView.getModel();
        dataModel.setValue("entrycontracttype", contractTemplates[index].get("contracttype"), rows[index]);
        dataModel.setValue("opperson", (Object)RequestContext.get().getCurrUserId(), rows[index]);
        if ("hlcm_contractapplycancel".equals(formView.getEntityId())) {
            Object entryperiodtype;
            Date enddate = dataModel.getDataEntity().getDate("canceldate");
            if (enddate != null) {
                Date entrystartdate = HRDateTimeUtils.addDay((Date)enddate, (long)1L);
                dataModel.setValue("entrystartdate", (Object)entrystartdate, rows[index]);
            }
            if ((entryperiodtype = dataModel.getValue("entryperiodtype")) != null && ((DynamicObject)entryperiodtype).getLong("id") == ContractPeriodTypeEnum.NONFIXED.getPkId()) {
                dataModel.setValue("entryperiodunit", (Object)0, rows[index]);
                formView.setEnable(Boolean.valueOf(false), rows[index], new String[]{"entryenddate"});
                formView.setEnable(Boolean.valueOf(false), rows[index], new String[]{"entryperiodunit"});
                formView.setEnable(Boolean.valueOf(false), rows[index], new String[]{"entryperiod"});
            }
            BasedataEdit contracttemplate = (BasedataEdit)formView.getControl("contracttemplate");
            if ("2".equals(dataModel.getDataEntity().getString("signway"))) {
                contracttemplate.setMustInput(false);
            } else {
                contracttemplate.setMustInput(true);
            }
        } else {
            dataModel.setValue("entrystartdate", dataModel.getDataEntity().get("startdate"), rows[index]);
        }
        ContractSignUtils.setOtherProtocolNumberForEntity((IFormView)formView, (int)rows[index]);
    }

    private void setContractInfoTemplate(List<Long> templateIds, DynamicObject[] contractTemplates, IFormView formView) {
        Map<Long, DynamicObject> tempMap = Arrays.stream(contractTemplates).collect(Collectors.toMap(val -> val.getLong("id"), val -> val));
        for (int index = templateIds.size() - 1; index >= 0; --index) {
            if (tempMap.get(templateIds.get(index)) == null || ContractTypeCatEnum.CON.getPkId() != tempMap.get(templateIds.get(index)).getLong("contracttype.group.id")) continue;
            formView.getModel().setValue("contractemplate", (Object)tempMap.get(templateIds.get(index)));
            formView.updateView("contractemplate");
            break;
        }
    }

    private String getAttachmentName(DynamicObject contractTemplate) {
        QFilter[] filters = new QFilter[]{new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplate"), new QFilter("finterid", "=", (Object)String.valueOf(contractTemplate.getPkValue()))};
        DynamicObject[] attachments = CommonRepository.query((String)"bos_attachment", (String)String.join((CharSequence)",", "ffileid", "fattachmentname"), (QFilter[])filters);
        return Stream.of(attachments).findFirst().map(attachment -> attachment.getString("fattachmentname")).orElse(null);
    }

    private void showTipResult(Map<String, String> tipResult, IFormView view) {
        if (!CollectionUtils.isEmpty(tipResult)) {
            String prefixTip = ResManager.loadKDString((String)"\u5df2\u6839\u636e\u4e1a\u52a1\u89c4\u5219\u81ea\u52a8\u4e3a\u60a8\u5339\u914d\u51fa\u5bf9\u5e94\u7684\u6570\u636e\uff1a", (String)"ContractSignServiceHelper_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            String splitTip = ResManager.loadKDString((String)"\u3001", (String)"ContractSignServiceHelper_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            StringBuilder tips = new StringBuilder(prefixTip);
            for (Map.Entry<String, String> entry : tipResult.entrySet()) {
                tips.append(entry.getValue()).append(splitTip);
            }
            String showTips = tips.toString();
            view.showSuccessNotification(showTips.substring(0, showTips.length() - 1));
        }
    }

    public void setPersonCardMain(IFormView view, IDataModel model, DynamicObject signDy) {
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            HeadCardUtil.showBillHeadNew((IFormView)view, (DynamicObject)signDy);
            view.setVisible(Boolean.TRUE, new String[]{"billinfopanelap"});
            view.setVisible(Boolean.FALSE, new String[]{"personcardinfopanelap", "employeeinfopanelap"});
        } else if (status.equals((Object)OperationStatus.EDIT)) {
            this.setProbationPeriod(model);
            DynamicObject erManFile = (DynamicObject)signDy.get("ermanfile");
            HeadCardUtil.showSignPersonHead((IFormView)view, (Object)erManFile.getPkValue());
            HeadCardUtil.showBillHeadNew((IFormView)view, (DynamicObject)signDy);
            view.setVisible(Boolean.TRUE, new String[]{"billheadpanelap", "personcardinfopanelap", "billinfopanelap"});
            view.setVisible(Boolean.FALSE, new String[]{"headviewpanelap"});
        } else {
            this.setProbationPeriod(model);
            HeadCardUtil.showBillHeadView((IFormView)view, (DynamicObject)signDy, (String)"1");
            view.setVisible(Boolean.FALSE, new String[]{"billheadpanelap", "personcardinfopanelap", "billinfopanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"headviewpanelap"});
        }
    }

    public void setPersonCardNew(IFormView view, IDataModel model, DynamicObject signDy) {
        String handleStatus = signDy.getString("handlestatus");
        String billStatus = signDy.getString("billstatus");
        boolean isExistsWorkflow = signDy.getBoolean("isexistsworkflow");
        if (HRStringUtils.equals((String)HandleStatusEnum.ARCHIVE.getCombKey(), (String)handleStatus)) {
            this.setPersonCardAllInfo(view, model);
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_modify", "bar_submit", "bar_submiteffect", "bar_unsubmit", "bar_termprocess", "bar_viewflowchart"});
            view.setVisible(Boolean.FALSE, new String[]{"employeeinfopanelap", "signcompanypanelap", "contractinfopanel", "presignpanelap", "stopinfoflexpanela", "flexrightpanelap", "oldcontractpanelap", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel", "tosignpanelap"});
        } else if (HRStringUtils.equals((String)HandleStatusEnum.PROCESSEND.getCombKey(), (String)handleStatus)) {
            this.handleProcessEnd(view, model, billStatus);
            view.setVisible(Boolean.FALSE, new String[]{"employeeinfopanelap", "signcompanypanelap", "contractinfopanel", "presignpanelap", "flexrightpanelap", "oldcontractpanelap", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel", "tosignpanelap"});
        } else if (HRStringUtils.equals((String)HandleStatusEnum.PROCESSIN.getCombKey(), (String)handleStatus)) {
            if (HRStringUtils.equals((String)BillStatusEnum.STATUS_RESUBMIT.getCode(), (String)billStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_submiteffect"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_termprocess", "bar_modify", "bar_submit", "bar_close"});
                view.setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel", "contractinfopanel", "stopinfoflexpanela", "flexrightpanelap"});
                view.setVisible(Boolean.TRUE, new String[]{"employeeinfopanelap", "signcompanypanelap", "tosignpanelap"});
                view.setEnable(Boolean.FALSE, new String[]{"signway"});
            } else {
                this.setPersonCardAllInfo(view, model);
                view.setVisible(Boolean.TRUE, new String[]{"bar_termprocess", "bar_unsubmit"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submit", "bar_save", "bar_submiteffect"});
                view.setVisible(Boolean.FALSE, new String[]{"employeeinfopanelap", "signcompanypanelap", "contractinfopanel", "presignpanelap", "stopinfoflexpanela", "oldcontractpanelap"});
                view.setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel", "tosignpanelap", "flexrightpanelap"});
            }
        } else if (HRStringUtils.equals((String)HandleStatusEnum.TOSUBMIT.getCombKey(), (String)handleStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_termprocess", "bar_unsubmit", "bar_viewflowchart"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_modify", "bar_submit", "bar_submiteffect", "bar_close"});
            view.setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel", "contractinfopanel", "stopinfoflexpanela", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"employeeinfopanelap", "signcompanypanelap", "tosignpanelap"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_termprocess", "bar_submiteffect", "bar_submit"});
            view.setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel", "contractinfopanel", "employeeinfopanelap", "stopinfoflexpanela", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"signcompanypanelap", "tosignpanelap"});
        }
        view.setVisible(Boolean.valueOf(HRStringUtils.equals((String)BillStatusEnum.STATUS_SUBMITED.getCode(), (String)billStatus)), new String[]{"bar_unsubmit"});
        if (view.getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_termprocess"});
        }
        this.handleAudit(view, isExistsWorkflow);
    }

    public void setPersonCardRenew(IFormView view, IDataModel model, DynamicObject signDy) {
        String handleStatus = signDy.getString("handlestatus");
        String billStatus = signDy.getString("billstatus");
        boolean isExistsWorkflow = signDy.getBoolean("isexistsworkflow");
        if (HRStringUtils.equals((String)HandleStatusEnum.ARCHIVE.getCombKey(), (String)handleStatus)) {
            this.setPersonCardAllInfo(view, model);
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_modify", "bar_submit", "bar_submiteffect", "bar_unsubmit", "bar_termprocess", "bar_viewflowchart"});
            view.setVisible(Boolean.FALSE, new String[]{"employeeinfopanelap", "signcompanypanelap", "tosignpanelap", "oldcontractpanelap", "presignpanelap", "stopinfoflexpanela", "flexrightpanelap", "oldcontractpanelap", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel", "contractinfopanel"});
        } else if (HRStringUtils.equals((String)HandleStatusEnum.PROCESSEND.getCombKey(), (String)handleStatus)) {
            this.handleProcessEnd(view, model, billStatus);
            view.setVisible(Boolean.FALSE, new String[]{"employeeinfopanelap", "signcompanypanelap", "tosignpanelap", "oldcontractpanelap", "presignpanelap", "flexrightpanelap", "oldcontractpanelap", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel", "contractinfopanel"});
        } else if (HRStringUtils.equals((String)HandleStatusEnum.PROCESSIN.getCombKey(), (String)handleStatus)) {
            if (HRStringUtils.equals((String)BillStatusEnum.STATUS_RESUBMIT.getCode(), (String)billStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_submiteffect"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_termprocess", "bar_save", "bar_modify", "bar_submit", "bar_close"});
                view.setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel", "contractinfopanel", "stopinfoflexpanela", "flexrightpanelap"});
                view.setVisible(Boolean.TRUE, new String[]{"employeeinfopanelap", "signcompanypanelap", "tosignpanelap", "oldcontractpanelap"});
                view.setEnable(Boolean.FALSE, new String[]{"signway"});
            } else {
                this.setPersonCardAllInfo(view, model);
                view.setVisible(Boolean.TRUE, new String[]{"bar_termprocess", "bar_unsubmit"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submit", "bar_save", "bar_submiteffect"});
                view.setVisible(Boolean.FALSE, new String[]{"employeeinfopanelap", "signcompanypanelap", "tosignpanelap", "oldcontractpanelap", "presignpanelap", "stopinfoflexpanela", "oldcontractpanelap"});
                view.setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel", "contractinfopanel", "flexrightpanelap"});
            }
        } else if (HRStringUtils.equals((String)HandleStatusEnum.TOSUBMIT.getCombKey(), (String)handleStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_termprocess", "bar_unsubmit", "bar_viewflowchart"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_modify", "bar_submit", "bar_submiteffect", "bar_close"});
            view.setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel", "contractinfopanel", "stopinfoflexpanela", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"employeeinfopanelap", "signcompanypanelap", "tosignpanelap", "oldcontractpanelap"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_termprocess", "bar_submiteffect", "bar_submit"});
            view.setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel", "contractinfopanel", "employeeinfopanelap", "stopinfoflexpanela", "flexrightpanelap"});
            view.setVisible(Boolean.TRUE, new String[]{"signcompanypanelap", "tosignpanelap", "oldcontractpanelap"});
        }
        view.setVisible(Boolean.valueOf(HRStringUtils.equals((String)BillStatusEnum.STATUS_SUBMITED.getCode(), (String)billStatus)), new String[]{"bar_unsubmit"});
        this.handleAudit(view, isExistsWorkflow);
    }

    private void handleProcessEnd(IFormView view, IDataModel model, String billStatus) {
        this.setPersonCardAllInfo(view, model);
        if (HRStringUtils.equals((String)BillStatusEnum.STATUS_NO_PASS.getCode(), (String)billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"stopinfoflexpanela"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"stopinfoflexpanela"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submit", "bar_submiteffect", "bar_unsubmit", "bar_termprocess"});
    }

    private void handleAudit(IFormView view, boolean isExistsWorkflow) {
        boolean isAudit;
        String showWay = (String)view.getFormShowParameter().getCustomParam("showway");
        boolean isSsc = HRStringUtils.equals((String)"hstc", (String)showWay);
        boolean bl = isAudit = ContractSignUtils.isAuditView((IFormView)view) || isSsc;
        if (isAudit) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_submiteffect", "bar_termprocess", "bar_modify"});
        }
        if (!isExistsWorkflow || isAudit) {
            view.setVisible(Boolean.FALSE, new String[]{"flexrightpanelap"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"flexrightpanelap", "bar_viewflowchart"});
        }
    }

    public void setPersonCardStop(IFormView view, IDataModel model, DynamicObject signDy) {
        String handleStatus = signDy.getString("handlestatus");
        String billStatus = signDy.getString("billstatus");
        boolean isExistsWorkflow = signDy.getBoolean("isexistsworkflow");
        view.setVisible(Boolean.valueOf(HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())), new String[]{"stopinfoflexpanela"});
        if (Arrays.asList(BillStatusEnum.STATUS_STAGING.getCode(), BillStatusEnum.STATUS_RESUBMIT.getCode()).contains(billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel"});
            view.setVisible(Boolean.TRUE, new String[]{"signcompanyfilepanelap", "employeeinfopanelap"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel"});
            view.setVisible(Boolean.FALSE, new String[]{"signcompanyfilepanelap", "employeeinfopanelap"});
        }
        if (HRStringUtils.equals((String)HandleStatusEnum.ARCHIVE.getCombKey(), (String)handleStatus)) {
            this.setPersonCardAllInfo(view, model);
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_modify", "bar_submit", "bar_submiteffect", "bar_unsubmit", "bar_termprocess", "bar_viewflowchart"});
        } else if (HRStringUtils.equals((String)HandleStatusEnum.PROCESSEND.getCombKey(), (String)handleStatus)) {
            this.handleProcessEnd(view, model, billStatus);
        } else if (HRStringUtils.equals((String)HandleStatusEnum.PROCESSIN.getCombKey(), (String)handleStatus)) {
            if (HRStringUtils.equals((String)BillStatusEnum.STATUS_RESUBMIT.getCode(), (String)billStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_submiteffect"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_termprocess", "bar_save", "bar_modify", "bar_submit", "bar_close"});
            } else {
                this.setPersonCardAllInfo(view, model);
                view.setVisible(Boolean.TRUE, new String[]{"bar_termprocess", "bar_unsubmit"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submit", "bar_save", "bar_submiteffect"});
            }
        } else if (HRStringUtils.equals((String)HandleStatusEnum.TOSUBMIT.getCombKey(), (String)handleStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_termprocess", "bar_unsubmit", "bar_viewflowchart"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_modify", "bar_submit", "bar_submiteffect", "bar_close"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_termprocess", "bar_submiteffect", "bar_submit"});
        }
        view.setVisible(Boolean.TRUE, new String[]{"oldcontractpanelap"});
        view.setVisible(Boolean.valueOf(HRStringUtils.equals((String)BillStatusEnum.STATUS_SUBMITED.getCode(), (String)billStatus)), new String[]{"bar_unsubmit"});
        this.handleAudit(view, isExistsWorkflow);
    }

    public void clearBillInfo(IFormView view, IDataModel model) {
        ArrayList<String> controls = new ArrayList<String>(64);
        controls.add("suggestsigncompany");
        controls.add("suggestsigncomphis");
        controls.add("actualsigncompany");
        controls.add("actualsigncompanyhis");
        controls.add("contracttype");
        controls.add("periodtype");
        controls.add("signway");
        controls.add("empname");
        controls.add("empnumber");
        controls.add("empphone");
        controls.add("cardtype");
        controls.add("cardnumber");
        controls.add("householdregister");
        controls.add("residentialaddress");
        controls.add("position");
        controls.add("department");
        controls.add("startdate");
        controls.add("enddate");
        controls.add("signeddate");
        controls.add("probationstartdate");
        controls.add("probationenddate");
        controls.add("probationunit");
        controls.add("probationperiodunit");
        controls.add("oldcontract");
        controls.add("signreason");
        controls.add("usestartdate");
        controls.add("cancelreason");
        controls.add("canceldate");
        ContractSignUtils.setControlListIsEmpty((IFormView)view, controls);
        int cnt = model.getEntryRowCount("entryentity");
        if (cnt > 0) {
            int[] deleteIndex = new int[cnt];
            for (int j = 0; j < cnt; ++j) {
                deleteIndex[j] = j;
            }
            DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", 0);
            if (!HRObjectUtils.isEmpty((Object)entryRowEntity.getDynamicObject("contracttemplate")) || !HRStringUtils.isEmpty((String)entryRowEntity.getString("seq"))) {
                model.deleteEntryRows("entryentity", deleteIndex);
            }
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("attachmentpanel");
        AttachmentUtils.clearAttachmentData((AttachmentPanel)attachmentPanel);
        DynamicObject dataEntity = model.getDataEntity();
        AttachmentServiceHelper.remove((String)dataEntity.getDataEntityType().getName(), (Object)dataEntity.getPkValue());
        model.setValue("periodunit", (Object)PeriodUnitEnum.YEAR.getCombKey());
        model.setValue("signreason", null);
        model.setValue("cancelreason", null);
        model.setValue("period", (Object)BigDecimal.ZERO);
        model.setValue("probationperiod", (Object)BigDecimal.ZERO);
    }
}

