/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.contractfile;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.domian.repository.BosAttachmentRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.business.utils.ContractPageLoadUtils;
import kd.hr.hlcm.business.utils.ContractRecordCardUtils;
import kd.hr.hlcm.common.enums.ContractFileSignStatusEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;
import kd.hr.hlcm.common.utils.FormTitleUtils;
import kd.hr.hlcm.common.utils.HeadCardUtil;

public class ContractFileBaseFormPlugin
extends HRDataBaseEdit {
    public void beforeBindData(EventObject event) {
        String entityId = this.getView().getEntityId();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.VIEW || status == OperationStatus.EDIT) {
            this.setFieldVisible();
            FormTitleUtils.getInstance().updateFileFormTitleOnViewStatus(this.getView(), this.getModel().getDataEntity().getString("person.name"));
            if (HRStringUtils.equals((String)"hlcm_contract", (String)entityId)) {
                HeadCardUtil.showContractFileHeadOnViewStatus((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity());
            } else {
                HeadCardUtil.showEmpAndOtherContractFileHeadOnViewStatus((IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity());
            }
            ContractPageLoadUtils contractPageLoadHelper = ContractPageLoadUtils.getInstance();
            contractPageLoadHelper.loadPage(this.getView());
            ContractRecordCardUtils instance = ContractRecordCardUtils.getInstance();
            QFilter dataRule = IHRCSService.getInstance().getCurrUserDataRuleByEntityNumberAndPermItemId(entityId, "47150e89000000ac");
            if (HRStringUtils.equals((String)"hlcm_contractfileother", (String)entityId)) {
                instance.showMainContractList(this.getView(), dataRule);
            } else {
                instance.showOtherHisCardList(this.getView(), dataRule);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"contractmaininfopanel"});
            instance.showHisCardList(this.getView(), dataRule);
            if (status == OperationStatus.EDIT) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"contractmaininfopanel"});
                this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
                this.getModel().setValue("modifytime", (Object)new Date());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "save".equals(operateKey)) {
            String entityId = this.getView().getEntityId();
            QFilter filter = new QFilter("datastatus", "=", (Object)"0").and("number", "=", (Object)this.getModel().getDataEntity().getString("number"));
            DynamicObject preDy = CommonRepository.queryOne((String)this.getView().getEntityId(), (String)"", (QFilter[])new QFilter[]{filter});
            if (preDy != null) {
                ContractRepository.getInstance().reviseData(this.getView(), preDy);
                ContractRepository.getInstance().reviseAttach(this.getView(), entityId, preDy);
            }
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("revise".equals(operateKey)) {
            String entityId = this.getView().getEntityId();
            DynamicObject dy = this.getModel().getDataEntity();
            if (dy.getBoolean("iscurrentversion")) {
                long sourceId = dy.getLong("sourcevid");
                long id = dy.getLong("id");
                BosAttachmentRepository.getInstance().modifyCurrAttachNum(entityId, id);
                if (sourceId != 0L) {
                    BosAttachmentRepository.getInstance().repairAttach(entityId, sourceId, id);
                }
            }
        }
    }

    private void setFieldVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap captionMap = Maps.newHashMapWithExpectedSize((int)2);
        captionMap.put(ContractFileSignStatusEnum.CANCEL_SIGN.getCombKey(), ResManager.getLocaleString((String)"\u89e3\u9664\u539f\u56e0", (String)"ContractFileBaseFormPlugin_1", (String)"hr-hlcm-formplugin"));
        captionMap.put(ContractFileSignStatusEnum.STOP_SIGNED.getCombKey(), ResManager.getLocaleString((String)"\u7ec8\u6b62\u539f\u56e0", (String)"ContractFileBaseFormPlugin_2", (String)"hr-hlcm-formplugin"));
        String signStatus = dataEntity.getString("signstatus");
        LocaleString caption = (LocaleString)captionMap.get(signStatus);
        boolean isVisible = null != caption;
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"cancelreason"});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"cancelreasontype"});
        if (isVisible) {
            BasedataEdit contractReason = (BasedataEdit)this.getControl("cancelreasontype");
            contractReason.setCaption(caption);
        }
        String signWay = dataEntity.getString("signway");
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)signWay, (String)SignWayEnum.PAPER.getCombKey())), new String[]{"paperattachment"});
    }
}

