/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.contractfile;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hlcm.business.service.PermissionService;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.ListShowUtil;

public class ContractFileProtocolListPlugins
extends AbstractListPlugin {
    private static final String CONTRACT_FILE_LIST_ORDERBY = "enddate asc,startdate asc,empnumber asc";

    public void filterContainerInit(FilterContainerInitArgs args) {
        DynamicObject[] baseDataDys;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        ((FilterColumn)commonFilterColumns.get(0)).setDefaultValues(new Object[0]);
        FilterColumn filterColumn = args.getFilterColumn("actualsigncompany.name");
        if (filterColumn != null && (baseDataDys = PermissionService.getBaseDataDys((String)"hbss_signcompany", (boolean)true)) != null) {
            ((CommonBaseDataFilterColumn)filterColumn).setComboItems(ListShowUtil.buildComboItems((DynamicObject[])baseDataDys));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        QFilter filter;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (("actualsigncompany.id".equals(fieldName) || "actualsigncompany.name".equals(fieldName)) && (filter = PermissionService.getBaseDataFilterByOrg((String)"hbss_signcompany", (boolean)true)) != null) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            QFilter enableFilter = new QFilter("status", "=", (Object)"C");
            qFilterList.add(filter);
            qFilterList.add(enableFilter);
            args.setQfilters(qFilterList);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        List qFilters = setFilterEvent.getQFilters();
        qFilters.removeIf(Objects::isNull);
        switch (billFormId) {
            case "hlcm_contractfileother": {
                qFilters.add(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.FS.getCombKey()));
                break;
            }
            case "hlcm_contractfileemp": {
                qFilters.add(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.YG.getCombKey()));
                break;
            }
            case "hlcm_contract": {
                qFilters.add(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey()));
                break;
            }
        }
        setFilterEvent.setOrderBy(CONTRACT_FILE_LIST_ORDERBY);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView view = (IListView)this.getView();
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(primaryKeyValue);
        billShowParameter.setFormId(view.getBillFormId());
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

