/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.empprotocolapply;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.utils.ContractDurationCalculateHelper;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.formplugin.billapply.empprotocolapply.ContractProtocolBaseFormPlugin;
import kd.hr.hlcm.formplugin.utils.WorkBenchHelper;

public class ContractEmpProtocolFormPlugin
extends ContractProtocolBaseFormPlugin {
    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "startdate": {
                this.checkStartDate();
                break;
            }
            case "enddate": {
                this.checkEndDate();
                break;
            }
            case "signeddate": {
                this.checkSignDateInfo();
                break;
            }
            case "actualsigncompany": {
                this.setCompanyAndHisInfo();
                break;
            }
            case "contracttype": {
                break;
            }
            case "ermanfile": {
                this.clearBillInfoWhenSwitchFileID();
                DynamicObject ermanfile = this.getModel().getDataEntity().getDynamicObject("ermanfile");
                this.ermanFileChangeHandle(ermanfile);
                break;
            }
            case "periodtype": {
                ContractSignUtils.updateEndDateControlMustByPeriodType((IFormView)this.getView(), (boolean)true);
                break;
            }
            case "cardnumber": {
                String msg = ContractSignApplyRepository.getInstance().checkIDCard(this.getView().getModel().getDataEntity());
                if (!HRStringUtils.isNotEmpty((String)msg)) break;
                this.getView().showErrorNotification(msg);
                break;
            }
            case "cardtype": {
                this.getModel().setValue("cardnumber", (Object)"");
                break;
            }
        }
        ContractDurationCalculateHelper.getInstance().calcContractDurationRelatedFields(this.getModel(), propertyName);
    }

    @Override
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (WorkBenchHelper.isWorkBenchSkip(this.getView())) {
            DynamicObject ermanfile = WorkBenchHelper.fillErmanFile(this.getView());
            this.ermanFileChangeHandle(ermanfile);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            entryEntity.forEach(entry -> {
                entry.getDataEntityState().setPushChanged(true);
                entry.getDataEntityState().setBizChanged(true);
            });
        }
    }

    private void ermanFileChangeHandle(DynamicObject ermanfile) {
        if (HRObjectUtils.isEmpty((Object)ermanfile)) {
            this.getModel().setValue("paneltype", (Object)"0");
            return;
        }
        String erManFileID = ermanfile.getString("id");
        String erManFileIDCache = this.getPageCache().get(erManFileID);
        if (HRStringUtils.equals((String)erManFileIDCache, (String)"1")) {
            this.checkErManFileIDPassLoadPageInfo();
            this.getPageCache().remove(erManFileIDCache);
        } else if (this.checkPersonPanel()) {
            this.checkErManFileIDPassLoadPageInfo();
        } else {
            this.initEmptyPage();
        }
    }

    private void checkEndDate() {
        boolean checkResult = ContractSignUtils.setStartDateAndEndDateInfo((IFormView)this.getView());
        if (!checkResult) {
            this.checkSignDateInfo();
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (WorkBenchHelper.isWorkBenchSkip(this.getView())) {
            WorkBenchHelper.setFormTitle(this.getView());
        }
    }

    @Override
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        if (WorkBenchHelper.isWorkBenchSkip(this.getView())) {
            WorkBenchHelper.setEnable(this.getView());
        }
    }
}

