/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.empprotocolapply;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.formplugin.billapply.empprotocolapply.ContractProtocolBaseFormPlugin;

public class EmpProtocolOfTerminateFormPlugin
extends ContractProtocolBaseFormPlugin {
    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit erManFile = (BasedataEdit)this.getControl("oldcontract");
        if (Objects.nonNull(erManFile)) {
            erManFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (propertyName) {
            case "canceldate": {
                String checkCancelDateResult = ContractSignApplyRepository.getInstance().checkCancelDate(dataEntity);
                if (!HRStringUtils.isNotEmpty((String)checkCancelDateResult)) break;
                this.getView().showErrorNotification(checkCancelDateResult);
                break;
            }
            case "ermanfile": {
                this.clearBillInfoWhenSwitchFileID();
                DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
                if (HRObjectUtils.isEmpty((Object)erManFile)) {
                    this.getModel().setValue("paneltype", (Object)"0");
                    break;
                }
                String erManFileId = this.getPageCache().get(this.getModel().getDataEntity().getString("ermanfile_id"));
                if (HRStringUtils.equals((String)erManFileId, (String)"1")) {
                    this.loadPageInfo();
                    this.getPageCache().remove(erManFileId);
                    break;
                }
                if (this.checkPersonPanel()) {
                    this.loadPageInfo();
                    break;
                }
                this.initEmptyPage();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        IDataEntityProperty property = evt.getProperty();
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        if (HRStringUtils.equals((String)"oldcontract", (String)property.getName())) {
            String empNumber = this.getModel().getDataEntity().getDynamicObject("ermanfile").getString("number");
            qFilters.add(new QFilter("empnumber", "=", (Object)empNumber));
            qFilters.add(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.YG.getCombKey()));
            qFilters.add(new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode()));
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
    }
}

