/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.otherprotocolapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.utils.ContractDurationCalculateHelper;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.common.entity.NoticeEntity;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.ComboUtils;
import kd.hr.hlcm.formplugin.billapply.empprotocolapply.ContractProtocolBaseFormPlugin;

public class OtherAncillaryAgreementApplyPlugins
extends ContractProtocolBaseFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(OtherAncillaryAgreementApplyPlugins.class);
    private static final String CONFIRM = "Yes";
    private static final String CONFIRM_CHECK = "confirmFileIdSwitch";
    private static final String CHECK_ERMANFILE_FLAG = "1";
    private static final String CHECK_CONTRACT_CALLBACK = "check_contract_type";
    private static final List<String> CHECK_NOT_AUDITTYPE = Arrays.asList(BillStatusEnum.STATUS_PASS.getCode(), BillStatusEnum.STATUS_NO_PASS.getCode(), BillStatusEnum.STATUS_DEPRECATED.getCode());

    @Override
    public void registerListener(EventObject eventObject) {
        BasedataEdit signCompany;
        BasedataEdit erManFile;
        super.registerListener(eventObject);
        BasedataEdit mainContract = (BasedataEdit)this.getControl("maincontract");
        if (Objects.nonNull(mainContract)) {
            mainContract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(erManFile = (BasedataEdit)this.getControl("ermanfile"))) {
            erManFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(signCompany = (BasedataEdit)this.getControl("actualsigncompany"))) {
            signCompany.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String caption;
        super.beforeF7Select(evt);
        IDataEntityProperty property = evt.getProperty();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List filters = listFilterParameter.getQFilters();
        if (HRStringUtils.equals((String)"maincontract", (String)property.getName())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            filters.add(new QFilter("person", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "person"))));
            filters.add(new QFilter("postype", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "postype"))));
            filters.add(new QFilter("protocoltype", "in", (Object)Lists.newArrayList((Object[])new String[]{ProtocolTypeEnum.CON.getCombKey(), ProtocolTypeEnum.YG.getCombKey()})));
            filters.add(new QFilter("contractstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ContractStatusEnum.STATUS_PENDING.getCode(), ContractStatusEnum.STATUS_IN_EFFECT.getCode()})));
            filters.add(new QFilter("iscurrentversion", "=", (Object)CHECK_ERMANFILE_FLAG));
        }
        if (HRStringUtils.equals((String)"ermanfile", (String)property.getName())) {
            caption = ResManager.loadKDString((String)"\u5458\u5de5", (String)"OtherAncillaryAgreementApplyPlugins_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("org")).ifPresent(org -> listFilterParameter.getQFilters().add(new QFilter("org", "=", org.getPkValue())));
            formShowParameter.setCaption(caption);
        }
        if (HRStringUtils.equals((String)"actualsigncompany", (String)property.getName())) {
            caption = ResManager.loadKDString((String)"\u5b9e\u7b7e\u5355\u4f4d", (String)"OtherAncillaryAgreementApplyPlugins_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            formShowParameter.setCaption(caption);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)CONFIRM) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("save");
        } else if (HRStringUtils.equals((String)callBackId, (String)CONFIRM_CHECK)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Cancel)) {
                this.getModel().setValue("ermanfile", null);
            } else {
                String fileId = this.getPageCache().get("ermanfile");
                this.showPopConfirm(callBackId, fileId);
            }
        } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel && HRStringUtils.equals((String)CHECK_CONTRACT_CALLBACK, (String)messageBoxClosedEvent.getCallBackId())) {
            this.getModel().setValue("contracttype", null);
        } else {
            LOGGER.warn("callBackId|{}", (Object)callBackId);
        }
    }

    private void showPopConfirm(String callBackId, String fileId) {
        Optional<NoticeEntity> first;
        String show2 = this.getPageCache().get("secondaryPops");
        List noticeEntities = JSONArray.parseArray((String)show2, NoticeEntity.class);
        for (NoticeEntity noticeEntity2 : noticeEntities) {
            if (!noticeEntity2.getNoticeStatus().equals(NoticeEntity.NoticeStatusEnum.PENDING.ordinal())) continue;
            noticeEntity2.setNoticeStatus(Integer.valueOf(NoticeEntity.NoticeStatusEnum.AGREED.ordinal()));
        }
        long count = noticeEntities.stream().filter(noticeEntity -> noticeEntity.getNoticeStatus().intValue() != NoticeEntity.NoticeStatusEnum.AGREED.ordinal()).count();
        if (count == 0L) {
            this.getPageCache().remove("secondaryPops");
            this.getPageCache().put(fileId, CHECK_ERMANFILE_FLAG);
            this.getModel().setValue("ermanfile", (Object)fileId);
        }
        if ((first = noticeEntities.stream().filter(a -> a.getNoticeStatus().equals(NoticeEntity.NoticeStatusEnum.NO_PROCESS.ordinal())).findFirst()).isPresent()) {
            NoticeEntity noticeEntity3 = first.get();
            this.getView().showConfirm(noticeEntity3.getErrorMsg(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
            noticeEntity3.setNoticeStatus(Integer.valueOf(NoticeEntity.NoticeStatusEnum.PENDING.ordinal()));
        }
        this.getPageCache().put("secondaryPops", JSON.toJSONString((Object)noticeEntities));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "startdate": {
                this.checkStartDate();
                break;
            }
            case "enddate": {
                ContractSignUtils.setStartDateAndEndDateInfo((IFormView)this.getView());
                this.checkSignDateInfo();
                break;
            }
            case "signeddate": {
                this.checkSignDateInfo();
                break;
            }
            case "actualsigncompany": {
                this.setCompanyAndHisInfo();
                break;
            }
            case "period": {
                ContractSignUtils.calcEndDateInfo((IDataModel)this.getModel());
                break;
            }
            case "ermanfile": {
                this.clearBillInfoWhenSwitchFileID();
                DynamicObject erManFile = this.getModel().getDataEntity().getDynamicObject("ermanfile");
                if (HRObjectUtils.isEmpty((Object)erManFile)) {
                    this.getModel().setValue("paneltype", (Object)"0");
                    break;
                }
                String erManFileID = erManFile.getString("id");
                String erManFileIdCache = this.getPageCache().get(erManFileID);
                if (HRStringUtils.equals((String)erManFileIdCache, (String)CHECK_ERMANFILE_FLAG)) {
                    this.getPageCache().remove(erManFileIdCache);
                    this.checkErManFileIDPassLoadPageInfo();
                    break;
                }
                if (this.checkPersonPanel()) {
                    this.checkErManFileIDPassLoadPageInfo();
                    break;
                }
                this.getPageCache().put("ermanfile", erManFileID);
                this.initEmptyPage();
                break;
            }
            case "periodtype": {
                ContractSignUtils.updateEndDateControlMustByPeriodType((IFormView)this.getView(), (boolean)true);
                break;
            }
            case "contracttype": {
                this.validateContractType();
                break;
            }
            case "cardnumber": {
                String msg = ContractSignApplyRepository.getInstance().checkIDCard(this.getView().getModel().getDataEntity());
                if (!HRStringUtils.isNotEmpty((String)msg)) break;
                this.getView().showErrorNotification(msg);
                break;
            }
            case "cardtype": {
                this.getModel().setValue("cardnumber", (Object)"");
                break;
            }
        }
        ContractDurationCalculateHelper.getInstance().calcContractDurationRelatedFields(this.getModel(), propertyName);
    }

    @Override
    protected void clearBillInfoWhenSwitchFileID() {
        super.clearBillInfoWhenSwitchFileID();
        this.getModel().setValue("maincontract", null);
        this.getModel().setValue("maincontractimport", null);
    }

    private void validateContractType() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject erManFile = dataEntity.getDynamicObject("ermanfile");
        DynamicObject contractType = dataEntity.getDynamicObject("contracttype");
        if (Objects.isNull(erManFile) || Objects.isNull(contractType)) {
            return;
        }
        QFilter personFilter = new QFilter("person", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "person")));
        QFilter posTypeFilter = new QFilter("postype", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "postype")));
        QFilter contractTypeFilter = new QFilter("contracttype", "=", contractType.getPkValue());
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)CHECK_ERMANFILE_FLAG);
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.FS.getCombKey());
        QFilter contractStatusFilter = new QFilter("contractstatus", "!=", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
        DynamicObject[] otherAgreements = HLCMCommonRepository.queryDynamicObjects((String)"hlcm_contract", (String)String.join((CharSequence)",", "number", "contractstatus"), (QFilter[])new QFilter[]{personFilter, posTypeFilter, contractTypeFilter, protocolTypeFilter, currentVersionFilter, contractStatusFilter});
        String erManFileName = erManFile.getString("name");
        List tips = Stream.of(otherAgreements).map(otherAgreement -> String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709%2$s\u7684%3$s\u8bb0\u5f55\uff0c\u5408\u540c\u7f16\u53f7\u4e3a\u201c%4$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OtherAncillaryAgreementApplyPlugins_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), erManFileName, ComboUtils.getComboOptionLocaleName((DynamicObject)otherAgreement, (String)"contractstatus"), contractType.getString("name"), otherAgreement.getString("number"))).collect(Collectors.toList());
        tips.addAll(this.checkOtherProtocolInValue(dataEntity));
        if (tips.isEmpty()) {
            return;
        }
        String joinTips = String.join((CharSequence)"\r\n", tips);
        this.getView().showConfirm(joinTips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHECK_CONTRACT_CALLBACK, (IFormPlugin)this));
    }

    private List<String> checkOtherProtocolInValue(DynamicObject dataEntity) {
        Object pkValue = dataEntity.getPkValue();
        DynamicObject erManFile = dataEntity.getDynamicObject("ermanfile");
        String businessType = dataEntity.getString("businesstype");
        QFilter personFilter = new QFilter("person", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "person")));
        QFilter posTypeFilter = new QFilter("postype", "=", (Object)dataEntity.getLong(String.format(Locale.ROOT, "%s_id", "postype")));
        QFilter billStatusFilter = new QFilter("billstatus", "not in", CHECK_NOT_AUDITTYPE);
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.FS.getCombKey());
        QFilter idFilter = new QFilter("id", "!=", pkValue);
        QFilter handleStatusFilter = new QFilter("handlestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{HandleStatusEnum.PROCESSIN.getCombKey(), HandleStatusEnum.TOSUBMIT.getCombKey()}));
        QFilter businessTypeFilter = new QFilter("businesstype", "=", (Object)businessType);
        DynamicObject contractType = dataEntity.getDynamicObject("contracttype");
        QFilter contractTypeFilter = new QFilter("contracttype", "=", contractType.getPkValue());
        DynamicObject[] contractDys = HLCMCommonRepository.queryDynamicObjects((String)"hlcm_contractapplybase", (String)"id,businesstype,billno", (QFilter[])new QFilter[]{handleStatusFilter, personFilter, posTypeFilter, protocolTypeFilter, billStatusFilter, businessTypeFilter, idFilter, contractTypeFilter});
        ArrayList tips = Lists.newArrayListWithExpectedSize((int)contractDys.length);
        String empName = erManFile.getString("name");
        for (DynamicObject contractDy : contractDys) {
            String billNo = contractDy.getString("billno");
            tips.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u76f8\u540c\u5408\u540c\u7c7b\u578b\u7684\u5176\u4ed6\u9644\u5c5e\u534f\u8bae%2$s\u7533\u8bf7\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c%3$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OtherAncillaryAgreementApplyPlugins_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), empName, ComboUtils.getComboOptionLocaleName((DynamicObject)contractDy, (String)"businesstype"), billNo));
        }
        return tips;
    }
}

