/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.common;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmEnum;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.business.utils.SignUploadUtil;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class ConfirmCommonFormPlugin
extends HRDataBaseEdit {
    private static final String IS_COMP_SIGN_UPLOADED = "isCompSignUploaded";
    private static final String IS_SUBMIT_EFFECT_UPLOADED = "isSubmitEffectUploaded";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (args.isCancel() || Arrays.asList("contractdownload", "contractpreview", "topcontractdownload", "topcontractpreview").contains(operateKey)) {
            return;
        }
        IFormView formView = this.getView();
        String permissionValidateErrorInfo = ISignManageService.getInstance().permissionValidate(formView, operateKey, operate.getOperateName().getLocaleValue());
        if (HRStringUtils.isNotEmpty((String)permissionValidateErrorInfo)) {
            formView.showErrorNotification(permissionValidateErrorInfo);
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            return;
        }
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate((String)operateKey);
        if (template == null) {
            return;
        }
        String isPre = pageCache.get("ispre");
        if ("true".equals(isPre)) {
            pageCache.remove("ispre");
            return;
        }
        args.setCancel(true);
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        Object pkValue = dataEntity.getPkValue();
        String errorInfo = template.invokeOperation(formView, "pre" + operateKey, new Object[]{pkValue});
        if (HRStringUtils.isEmpty((String)errorInfo)) {
            boolean isPaperSubmitEffect;
            boolean isCompSign = HRStringUtils.equals((String)operateKey, (String)"compsign");
            boolean bl = isPaperSubmitEffect = HRStringUtils.equals((String)operateKey, (String)"submiteffect") && HRStringUtils.equals((String)dataEntity.getString("signway"), (String)SignWayEnum.PAPER.getCombKey());
            if (isCompSign || isPaperSubmitEffect) {
                String isCompSignUploaded = pageCache.get(IS_COMP_SIGN_UPLOADED);
                String isSubmitEffectUploaded = pageCache.get(IS_SUBMIT_EFFECT_UPLOADED);
                if (HRStringUtils.equals((String)isCompSignUploaded, (String)"true")) {
                    pageCache.remove(IS_COMP_SIGN_UPLOADED);
                } else if (HRStringUtils.equals((String)isSubmitEffectUploaded, (String)"true")) {
                    pageCache.remove(IS_SUBMIT_EFFECT_UPLOADED);
                } else {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    if (isPaperSubmitEffect) {
                        formShowParameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u63d0\u4ea4\u5e76\u751f\u6548", (String)"ConfirmCommonFormPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                    }
                    formShowParameter.setFormId("hlcm_papersign_attach");
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "upload"));
                    formShowParameter.setCustomParam("id", dataEntity.getPkValue());
                    formShowParameter.setCustomParam("enddate", (Object)dataEntity.getDate("enddate"));
                    formShowParameter.setCustomParam("signeddate", (Object)dataEntity.getDate("signeddate"));
                    SignUploadUtil.setHeight((FormShowParameter)formShowParameter, (DynamicObject)dataEntity);
                    formView.showForm(formShowParameter);
                    pageCache.put("ispre", "true");
                    pageCache.put(isCompSign ? IS_COMP_SIGN_UPLOADED : IS_SUBMIT_EFFECT_UPLOADED, "false");
                }
            } else {
                template.singleOkCancelBox(formView, pkValue, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
            }
        } else {
            if (!HRStringUtils.equals((String)operateKey, (String)"submiteffect")) {
                formView.showErrorNotification(errorInfo);
            }
            pageCache.remove("ispre");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.startsWithIgnoreCase((String)args.getOperateKey(), (String)"pre") || Arrays.asList("contractdownload", "contractpreview", "topcontractdownload", "topcontractpreview").contains(args.getOperateKey())) {
            IFormView formView = this.getView();
            AttachmentUtils.bindAttachment((IFormView)formView);
            formView.updateView("attachmentpanel");
            String formId = this.getView().getFormShowParameter().getFormId();
            if (SignTabEnum.P_ARCHIVE.getSourceListFormId().equals(formId) || SignTabEnum.P_CHECK.getSourceListFormId().equals(formId) || SignTabEnum.P_STOP.getSourceListFormId().equals(formId)) {
                formView.updateView("paperattachment");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        IFormView formView = this.getView();
        MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate((String)callBackId);
        if (template != null && event.getResult() == MessageBoxResult.Yes) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put("ispre", "true");
            String permissionValidateErrorInfo = ISignManageService.getInstance().permissionValidate(formView, callBackId, template.getName());
            if (!HRStringUtils.isEmpty((String)permissionValidateErrorInfo)) {
                formView.showErrorNotification(permissionValidateErrorInfo);
                return;
            }
            String errorInfo = template.invokeOperation(formView, callBackId, new Object[]{this.getModel().getDataEntity().getPkValue()});
            if (HRStringUtils.isEmpty((String)errorInfo)) {
                if (!HRStringUtils.equals((String)callBackId, (String)"unsubmit") && !HRStringUtils.equals((String)callBackId, (String)"submiteffect")) {
                    formView.showSuccessNotification(template.getSingleOkSuccessMessage());
                }
                formView.invokeOperation("refresh");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"upload", (String)actionId)) {
            IPageCache pageCache = this.getPageCache();
            if (Boolean.TRUE.equals(closedCallBackEvent.getReturnData())) {
                String isCompSignUploaded = pageCache.get(IS_COMP_SIGN_UPLOADED);
                boolean isCompSignUploading = HRStringUtils.equals((String)isCompSignUploaded, (String)"false");
                pageCache.put(isCompSignUploading ? IS_COMP_SIGN_UPLOADED : IS_SUBMIT_EFFECT_UPLOADED, "true");
                String operateKey = isCompSignUploading ? "compsign" : "submiteffect";
                MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate((String)operateKey);
                IFormView formView = this.getView();
                String permissionValidateErrorInfo = ISignManageService.getInstance().permissionValidate(formView, operateKey, template.getName());
                if (!HRStringUtils.isEmpty((String)permissionValidateErrorInfo)) {
                    formView.showErrorNotification(permissionValidateErrorInfo);
                } else {
                    Object pkValue = this.getModel().getDataEntity().getPkValue();
                    template.invokeOperation(formView, operateKey, new Object[]{pkValue});
                }
            } else {
                pageCache.remove("ispre");
            }
            pageCache.remove(IS_COMP_SIGN_UPLOADED);
            pageCache.remove(IS_SUBMIT_EFFECT_UPLOADED);
        }
    }
}

