/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.handlebill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.enums.ActivityStatusEnum;
import kd.hr.hlcm.common.enums.ActivityTaskStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;

public class HandleCheckPlugin
extends AbstractFormPlugin {
    private static final String COLOR_GREY = "#666666";
    private static final String COLOR_ORANGE = "#FF991C";
    private static final String COLOR_GREEN = "#1BA854";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector vector = (Vector)this.getControl("vectorap2");
        vector.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long applyId = (Long)this.getView().getFormShowParameter().getCustomParam("signapplyid");
        HRBaseServiceHelper signApplyHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        DynamicObject signBill = signApplyHelper.queryOne("handlestatus", (Object)applyId);
        Container container = (Container)this.getControl("flexpane7");
        container.deleteControls(new String[]{"flexpanelap71", "flexpanelap5"});
        String handleStatus = signBill.getString("handlestatus");
        if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.ARCHIVE.getCombKey())) {
            this.deleteControls();
        } else {
            HashMap<String, String> ctrl = new HashMap<String, String>(3);
            ctrl.put("fc", "#FB2323");
            this.getView().updateControlMetadata("labelap1", ctrl);
            ctrl.put("fontClass", "kdfont kdfont-jinggao");
            this.getView().updateControlMetadata("vectorap11", ctrl);
            Label labelap = (Label)this.getControl("labelap1");
            if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())) {
                String termText = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"HandleCheckPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                labelap.setText(termText);
                this.deleteControls();
            } else {
                String rate = this.showActivityInfo(applyId, container);
                String unCompletedText = ResManager.loadKDString((String)"\u672a\u5b8c\u6210", (String)"HandleCheckPlugin_6", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                labelap.setText(String.format("%s %s", unCompletedText, rate));
            }
        }
    }

    private String showActivityInfo(Long applyId, Container container) {
        HRBaseServiceHelper activityHelper = new HRBaseServiceHelper("hlcm_activity");
        QFilter signApplyFilter = new QFilter("signapply", "=", (Object)applyId);
        DynamicObject[] querySet = activityHelper.query("activity.id,activity.name,activityins.taskstatus,signapply.handlestatus", new QFilter[]{signApplyFilter}, "activity.number");
        ArrayList<Map> items = new ArrayList<Map>(querySet.length);
        int completionCount = 0;
        int index = 1;
        for (DynamicObject row : querySet) {
            String activityName = row.getString("activity.name");
            String taskStatus = row.getString("activityins.taskstatus");
            String handleStatus = row.getString("signapply.handlestatus");
            if (HRStringUtils.equals((String)taskStatus, (String)ActivityTaskStatusEnum.COMPLETED.getCombKey())) {
                ++completionCount;
            }
            FlexPanelAp flexPanel = this.createOuterFlexPanel(activityName, row.getLong("activity.id"), handleStatus, taskStatus, index);
            ++index;
            items.add(flexPanel.createControl());
        }
        container.addControls(items);
        this.getView().setVisible(Boolean.FALSE, new String[]{"coophandledetail"});
        return String.format("%s/%s", completionCount, querySet.length);
    }

    private FlexPanelAp createOuterFlexPanel(String activityName, Long activityId, String handleStatus, String taskStatus, int index) {
        FlexPanelAp outerFlexPanel = new FlexPanelAp();
        outerFlexPanel.setKey("activityInsout" + index);
        outerFlexPanel.setName(new LocaleString("activityInsout" + index));
        outerFlexPanel.setLazyLoad(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("20px");
        style.setMargin(margin);
        outerFlexPanel.setStyle(style);
        LabelAp leftAp = new LabelAp();
        leftAp.setKey("activityname" + index);
        leftAp.setForeColor(COLOR_GREY);
        leftAp.setName(new LocaleString(activityName));
        FlexPanelAp innerFlexPanel = this.createInnerFlexPanel(handleStatus, taskStatus, activityId, index);
        outerFlexPanel.getItems().add(leftAp);
        outerFlexPanel.getItems().add(innerFlexPanel);
        return outerFlexPanel;
    }

    private FlexPanelAp createInnerFlexPanel(String handleStatus, String taskStatus, Long activityId, int index) {
        ActivityStatusEnum activityStatusEnum;
        FlexPanelAp innerFlexPanel = new FlexPanelAp();
        innerFlexPanel.setKey("activityInsin" + index);
        innerFlexPanel.setName(new LocaleString("activityInsin" + index));
        innerFlexPanel.setLazyLoad(true);
        innerFlexPanel.setJustifyContent("flex-end");
        innerFlexPanel.setGrow(1);
        innerFlexPanel.setShrink(1);
        LabelAp rightLabel = new LabelAp();
        rightLabel.setKey("activitystatus" + index);
        String foreColor = COLOR_GREY;
        String text = ResManager.loadKDString((String)"\u9884\u4f30", (String)"HandleCheckPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
        if (HRStringUtils.isNotEmpty((String)taskStatus) && Objects.nonNull(activityStatusEnum = ActivityStatusEnum.getActivityStatusEnum((String)handleStatus, (Long)activityId, (String)taskStatus))) {
            switch (activityStatusEnum) {
                case P_LUNCHED: 
                case P_COMPLETED: 
                case P_CHECKED: 
                case E_C_SIGNED: 
                case E_P_SIGNED: 
                case E_LUNCHED: 
                case E_CONFIRMED: 
                case E_CHECKED: {
                    foreColor = COLOR_GREEN;
                    break;
                }
                case P_TO_LAUNCH: 
                case P_TO_COMPLETE: 
                case E_TO_LAUNCH: 
                case E_TO_CONFIRM: 
                case E_P_TO_SIGN: 
                case E_C_TO_SIGN: 
                case E_TO_CHECK: 
                case P_TO_CHECK: {
                    foreColor = COLOR_ORANGE;
                    break;
                }
            }
            text = Optional.of(activityStatusEnum).map(ActivityStatusEnum::loadKDString).orElse("-");
        }
        rightLabel.setName(new LocaleString(text));
        rightLabel.setForeColor(foreColor);
        innerFlexPanel.getItems().add(rightLabel);
        return innerFlexPanel;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "vectorap2": {
                this.setVisible();
                break;
            }
        }
    }

    private void setVisible() {
        String visible = this.getView().getPageCache().get("visible");
        if (HRStringUtils.isEmpty((String)visible)) {
            this.getView().getPageCache().put("visible", "false");
        }
        Boolean curVisible = Boolean.valueOf(this.getView().getPageCache().get("visible"));
        this.getView().setVisible(Boolean.valueOf(curVisible == false), new String[]{"coophandledetail"});
        this.getView().getPageCache().put("visible", Boolean.toString(curVisible == false));
        HashMap<String, String> ctrl = new HashMap<String, String>(3);
        ctrl.put("fontClass", curVisible != false ? "kdfont kdfont-shouqi7" : "kdfont kdfont-zhankai4");
        this.getView().updateControlMetadata("vectorap2", ctrl);
    }

    private void deleteControls() {
        Container pContainer1 = (Container)this.getControl("coophandle");
        Container pContainer2 = (Container)this.getControl("flexpanelap12");
        pContainer1.deleteControls(new String[]{"vectorap2"});
        pContainer2.deleteControls(new String[]{"coophandledetail"});
    }
}

