/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.importplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.formplugin.importplugin.SignImportBasePlugin;

public class OtherProtocolImportPlugin
extends SignImportBasePlugin {
    public static final String BASE_DATA_CONTRACT = "main_contract";

    @Override
    protected String doCheckErManFile(Long posTypeId, List<Long> laborRelTypeClsId, Long labrelStatusPrdId) {
        return "";
    }

    @Override
    protected void fillVirtualFieldSignBillInfo(ImportDataEventArgs evt, Map<String, Object> sourceData, Map<String, Map<String, DynamicObject>> baseDataMaps) {
        Map<String, DynamicObject> contract = baseDataMaps.get(BASE_DATA_CONTRACT);
        OtherProtocolImportPlugin.checkValVirtualFieldMainContract(evt, sourceData, contract);
        OtherProtocolImportPlugin.setValVirtualFieldMainContract(this.getModel(), sourceData, contract);
    }

    @Override
    public Map<String, Map<String, DynamicObject>> getBaseDataMaps(InitImportDataEventArgs evt, String signBillId) {
        HashMap baseDataMaps = Maps.newHashMapWithExpectedSize((int)1);
        HashMap baseData = Maps.newHashMap();
        List sourceDataList = evt.getSourceDataList();
        if (HRStringUtils.equals((String)"hlcm_otheragreements", (String)signBillId)) {
            DynamicObject[] query;
            Set mainContractNumSet = sourceDataList.stream().map(sourceData -> {
                String propMainContractStr = JSON.toJSONString(sourceData.get("maincontractimport"));
                JSONObject propMainContract = JSON.parseObject((String)propMainContractStr);
                if (Objects.nonNull(propMainContract) && HRObjectUtils.equals((Object)propMainContract.getString("importprop"), (Object)"number")) {
                    return propMainContract.getString("number");
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (mainContractNumSet.isEmpty()) {
                return baseDataMaps;
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hlcm_contract");
            QFilter qFilter = new QFilter("number", "in", mainContractNumSet);
            QFilter qFilter1 = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{qFilter, qFilter1};
            for (DynamicObject dynamicObject : query = hrBaseServiceHelper.query("id,number,empnumber,contractstatus", qFilters)) {
                baseData.put(dynamicObject.getString("number"), dynamicObject);
            }
        }
        baseDataMaps.put(BASE_DATA_CONTRACT, baseData);
        return baseDataMaps;
    }

    public static void checkValVirtualFieldMainContract(ImportDataEventArgs evt, Map<String, Object> sourceData, Map<String, DynamicObject> contractMap) {
        Object contractImportObj = sourceData.get("maincontractimport");
        Object empNumberSource = sourceData.get("empnumber");
        if (HRObjectUtils.isEmpty(contractMap) || contractMap.isEmpty() || HRObjectUtils.isEmpty((Object)contractImportObj)) {
            return;
        }
        String contractImportObjStr = JSON.toJSONString((Object)contractImportObj);
        JSONObject contractImportJsonObj = JSONObject.parseObject((String)contractImportObjStr);
        String contractNum = contractImportJsonObj.getString("number");
        DynamicObject contractFile = contractMap.get(contractNum);
        String empNumber = contractFile.getString("empnumber");
        String contractStatus = contractFile.getString("contractstatus");
        if (!HRObjectUtils.isEmpty((Object)empNumberSource) && !HRStringUtils.equals((String)empNumber, (String)empNumberSource.toString())) {
            evt.setCancel(true);
            evt.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u201c{0}\u201d\u4e0d\u662f\u8be5\u5458\u5de5\u7684\u5408\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherProtocolImportPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[]{contractNum}));
        }
        if (HRStringUtils.equals((String)ContractStatusEnum.STATUS_NO_EFFECT.getCode(), (String)contractStatus)) {
            evt.setCancel(true);
            evt.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u201c{0}\u201d\u5df2\u5931\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherProtocolImportPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[]{contractNum}));
        }
    }

    public static void setValVirtualFieldMainContract(IDataModel signBillModel, Map<String, Object> sourceData, Map<String, DynamicObject> contractMap) {
        Object contractImportObj = sourceData.get("maincontractimport");
        if (HRObjectUtils.isEmpty(contractMap) || contractMap.isEmpty() || HRObjectUtils.isEmpty((Object)contractImportObj)) {
            return;
        }
        String contractImportObjStr = JSON.toJSONString((Object)contractImportObj);
        JSONObject contractImportJsonObj = JSONObject.parseObject((String)contractImportObjStr);
        String number = contractImportJsonObj.getString("number");
        DynamicObject contractFile = contractMap.get(number);
        if (HRObjectUtils.isEmpty((Object)contractFile)) {
            return;
        }
        signBillModel.setValue("maincontract", (Object)contractFile.getLong("id"));
    }
}

