/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.mobile;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Label;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.ClientViewProxy;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.utils.SignUploadUtil;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.PeriodUnitEnum;
import org.apache.commons.lang3.RandomUtils;

public class ContractInformationPlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SignUploadUtil.class);
    private static final String MOBILESIGNSTATUS_PENDING = "0";
    private static final String MOBILESIGNSTATUS_SIGNING = "1";
    private static final String MOBILESIGNSTATUS_FINISH = "2";
    private static final String MOBILESIGNSTATUS_STOP = "3";

    public void afterBindData(EventObject eventObject) {
        FormShowParameter formShowParameter;
        String isToSign;
        super.afterBindData(eventObject);
        Object billId = this.getView().getFormShowParameter().getCustomParam("id");
        if (billId == null) {
            LOGGER.error("billId is null");
            return;
        }
        DynamicObject dynamicObject = CommonRepository.queryById((String)"hlcm_contractapplybase", null, (Long)Long.valueOf(billId.toString()));
        if (dynamicObject == null) {
            LOGGER.error("no data\uff0c billId:{}", billId);
            return;
        }
        int count = 0;
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("entryentity");
        if (dynamicObjects != null) {
            count += dynamicObjects.size();
        }
        String title = HRStringUtils.equals((String)(isToSign = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("isToSign")), (String)Boolean.TRUE.toString()) ? ResManager.loadKDString((String)"\u672c\u6b21\u5171\u6709 %s \u4efd\u5408\u540c\u548c\u534f\u8bae\u5f85\u7b7e\u7f72", (String)"ContractInformationPlugin_9", (String)"hr-hlcm-formplugin", (Object[])new Object[]{count++}) : ResManager.loadKDString((String)"\u672c\u6b21\u5171\u6709 %s \u4efd\u5408\u540c\u548c\u534f\u8bae\u53d1\u8d77\u7b7e\u7f72", (String)"ContractInformationPlugin_8", (String)"hr-hlcm-formplugin", (Object[])new Object[]{count++});
        Label countLabel = (Label)this.getControl("contractcount");
        countLabel.setText(title);
        Label company = (Label)this.getControl("actualsigncompany");
        company.setText(dynamicObject.getString("actualsigncompany.name"));
        if (dynamicObjects != null) {
            try {
                FlexPanelAp containerFlex = new HRFlexPanelAp.Builder("contractcontent").setShrink(1).setGrow(1).setWidth("100%").setWrap(false).setDirection("column").build();
                for (DynamicObject entryRow : dynamicObjects) {
                    if (Objects.equals(ContractTypeCatEnum.CON.getPkId(), entryRow.getLong("entrycontracttype.group.id"))) {
                        containerFlex.getItems().add(0, this.getItem(entryRow));
                        continue;
                    }
                    containerFlex.getItems().add(this.getItem(entryRow));
                }
                if (containerFlex.getItems().size() > 1) {
                    ((ControlAp)containerFlex.getItems().get(containerFlex.getItems().size() - 1)).getStyle().getBorder().setBottom("");
                }
                this.getView().updateControlMetadata("contractcontent", containerFlex.createControl());
            }
            catch (Exception ex) {
                LOGGER.error("showlistcontent ex:", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38", (String)"ContractInformationPlugin_7", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private FlexPanelAp getItem(DynamicObject entryRow) {
        FlexPanelAp fileRow;
        FlexPanelAp dateRow;
        String uniqKey = "con" + entryRow.get("id");
        FlexPanelAp itemFlex = this.getItemFlex(uniqKey);
        itemFlex.getItems().add(this.createTitleRow(uniqKey, entryRow));
        FlexPanelAp periodRow = this.createPeriodRow(uniqKey, entryRow);
        if (periodRow != null) {
            itemFlex.getItems().add(periodRow);
        }
        if ((dateRow = this.createDateRow(uniqKey, entryRow)) != null) {
            itemFlex.getItems().add(dateRow);
        }
        if ((fileRow = this.createFileRow(uniqKey, entryRow)) != null) {
            itemFlex.getItems().add(fileRow);
        }
        return itemFlex;
    }

    private FlexPanelAp createTitleRow(String uniqKey, DynamicObject entryRow) {
        FlexPanelAp titleRowFlex = this.getBaseRowFlex(uniqKey + "titleRow");
        DynamicObject templateDy = entryRow.getDynamicObject("texthis");
        if (templateDy != null) {
            titleRowFlex.setJustifyContent("space-between");
            LabelAp temNameLabel = new HRLabelAp.Builder(uniqKey + "temName").setForeColor("#212121").setFontSize(16).setName(templateDy.getString("name")).setHeight(new LocaleString("24px")).build();
            titleRowFlex.getItems().add(temNameLabel);
        } else {
            titleRowFlex.setJustifyContent("flex-end");
        }
        String status = null;
        String empStatus = entryRow.getString("entryempsignstatus");
        String compStatus = entryRow.getString("entrycompsignstatus");
        if (MOBILESIGNSTATUS_PENDING.equals(empStatus) || MOBILESIGNSTATUS_FINISH.equals(empStatus)) {
            status = MOBILESIGNSTATUS_PENDING;
        } else if (MOBILESIGNSTATUS_SIGNING.equals(empStatus)) {
            status = MOBILESIGNSTATUS_SIGNING.equals(compStatus) ? MOBILESIGNSTATUS_FINISH : MOBILESIGNSTATUS_SIGNING;
        }
        if (MOBILESIGNSTATUS_STOP.equals(empStatus)) {
            status = MOBILESIGNSTATUS_STOP;
        }
        titleRowFlex.getItems().add(this.getStatusLabel(uniqKey, status));
        return titleRowFlex;
    }

    private LabelAp getStatusLabel(String uniqKey, String status) {
        HRLabelAp.Builder statusBuilder = (HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(uniqKey + "status").setFontSize(12).setRadius("2px").setPaddingLeft("8px")).setPaddingRight("8px");
        if (status == null || MOBILESIGNSTATUS_PENDING.equals(status) || MOBILESIGNSTATUS_SIGNING.equals(status)) {
            ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)statusBuilder.setBorderLeft("#276FF5 solid 0.5px")).setBorderRight("#276FF5 solid 0.5px")).setBorderTop("#276FF5 solid 0.5px")).setBorderBottom("#276FF5 solid 0.5px")).setForeColor("#85B8FF").setBackColor("#F2F9FF");
            if (MOBILESIGNSTATUS_PENDING.equals(status)) {
                statusBuilder.setName(ResManager.loadKDString((String)"\u5f85\u7b7e\u7f72", (String)"ContractInformationPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            } else if (MOBILESIGNSTATUS_SIGNING.equals(status)) {
                statusBuilder.setName(ResManager.loadKDString((String)"\u7b7e\u7f72\u4e2d", (String)"ContractInformationPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            } else {
                statusBuilder.setName(ResManager.loadKDString((String)"\u6682\u65e0\u72b6\u6001", (String)"ContractInformationPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
        } else if (MOBILESIGNSTATUS_FINISH.equals(status)) {
            ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)statusBuilder.setBorderLeft("#6DD18E solid 0.5px")).setBorderRight("#6DD18E solid 0.5px")).setBorderTop("#6DD18E solid 0.5px")).setBorderBottom("#6DD18E solid 0.5px")).setForeColor("#1BA854").setBackColor("#F2FFF5");
            statusBuilder.setName(ResManager.loadKDString((String)"\u5b8c\u6210\u7b7e\u7f72", (String)"ContractInformationPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        } else if (MOBILESIGNSTATUS_STOP.equals(status)) {
            ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)statusBuilder.setBorderLeft("#FF8088 solid 0.5px")).setBorderRight("#FF8088 solid 0.5px")).setBorderTop("#FF8088 solid 0.5px")).setBorderBottom("#FF8088 solid 0.5px")).setForeColor("#FB2323").setBackColor("#FFF2F4");
            statusBuilder.setName(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"ContractInformationPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
        LabelAp labelAp = statusBuilder.build();
        labelAp.setLineHeight("20px");
        return labelAp;
    }

    private FlexPanelAp createPeriodRow(String uniqKey, DynamicObject entryRow) {
        String typeName = entryRow.getString("entryperiodtype.name");
        if (HRStringUtils.isNotEmpty((String)typeName)) {
            FlexPanelAp periodRowFlex = this.getBaseRowFlex(uniqKey + "periodRow");
            boolean nonFixed = ContractPeriodTypeEnum.NONFIXED.getPkId() == entryRow.getLong("entryperiodtype.id");
            String unitName = null;
            if (!nonFixed) {
                BigDecimal entryperiod = entryRow.getBigDecimal("entryperiod");
                String entryperiodunit = entryRow.getString("entryperiodunit");
                if (entryperiod != null) {
                    String per = entryperiod.setScale(1, RoundingMode.HALF_UP).toString();
                    if (per.length() > 2 && per.endsWith(".0")) {
                        per = per.substring(0, per.length() - 2);
                    }
                    unitName = per + PeriodUnitEnum.getValueByKey((String)entryperiodunit);
                }
            }
            LabelAp periodTypelabel = new HRLabelAp.Builder(uniqKey + "periodtype").setShrink(1).setGrow(0).setFontSize(14).setName(nonFixed || unitName == null ? typeName : typeName + " : " + unitName).setHeight(new LocaleString("22px")).setForeColor("#999999").build();
            periodRowFlex.getItems().add(periodTypelabel);
            return periodRowFlex;
        }
        return null;
    }

    private FlexPanelAp createDateRow(String uniqKey, DynamicObject entryRow) {
        Date startDate = entryRow.getDate("entrystartdate");
        Date endDate = entryRow.getDate("entryenddate");
        if (startDate != null) {
            String str = endDate == null ? String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u4e8e%s", (String)"ContractInformationPlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")) : String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u4e8e%1$s\uff0c\u7ed3\u675f\u4e8e%2$s", (String)"ContractInformationPlugin_6", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            FlexPanelAp dateRowFlex = this.getBaseRowFlex(uniqKey + "dateRow");
            LabelAp periodlabel = new HRLabelAp.Builder("period").setShrink(1).setGrow(0).setFontSize(14).setName(str).setHeight(new LocaleString("22px")).setForeColor("#212121").build();
            dateRowFlex.getItems().add(periodlabel);
            return dateRowFlex;
        }
        return null;
    }

    private FlexPanelAp createFileRow(String uniqKey, DynamicObject entryRow) {
        List<Map<String, Object>> attachDataList = ContractInformationPlugin.getAttachDataList(entryRow);
        if (attachDataList != null) {
            FlexPanelAp dateRowFlex = this.getBaseRowFlex(uniqKey + "file");
            dateRowFlex.getStyle().getPadding().setLeft("0px");
            dateRowFlex.getStyle().getPadding().setRight("0px");
            AttachmentPanelAp attachmentPanelAp = new AttachmentPanelAp();
            attachmentPanelAp.setCollapsible(false);
            attachmentPanelAp.setKey(uniqKey + "attachment");
            attachmentPanelAp.setName(new LocaleString(uniqKey + "attachment"));
            attachmentPanelAp.setWidth(new LocaleString("100%"));
            attachmentPanelAp.setLock("view,edit,new,submit,audit");
            attachmentPanelAp.setShrink(0);
            attachmentPanelAp.setGrow(0);
            attachmentPanelAp.setShowTitle(false);
            attachmentPanelAp.setShowAttachmentTips(false);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.setFieldProperty(uniqKey + "attachment", "v", attachDataList);
            dateRowFlex.getItems().add(attachmentPanelAp);
            this.getPageCache().put(attachmentPanelAp.getKey(), (String)attachDataList.get(0).get("uid"));
            return dateRowFlex;
        }
        return null;
    }

    private static List<Map<String, Object>> getAttachDataList(DynamicObject entryRow) {
        String entityId = "hlcm_contractfileother";
        String url = entryRow.getString("presigndocurl");
        if (!HRStringUtils.isBlank((CharSequence)url)) {
            int idx;
            ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
            HashMap<String, String> attachMap = new HashMap<String, String>();
            FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
            url = attachFileServiceExt.getRealPath(url);
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
            String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName, (InputStream)new BufferedInputStream(inputStream), 7200);
            attachMap.put("url", saveUrl);
            attachMap.put("previewurl", saveUrl);
            attachMap.put("uid", ContractInformationPlugin.getUid().toString());
            attachMap.put("name", fileName);
            if (HRStringUtils.isNotEmpty((String)fileName) && (idx = fileName.lastIndexOf(".")) > 0) {
                attachMap.put("type", fileName.substring(idx + 1));
            }
            int size = 0;
            try {
                inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
                size = ByteStreams.toByteArray((InputStream)inputStream).length;
            }
            catch (IOException ex) {
                LOGGER.error("available error", (Throwable)ex);
            }
            attachMap.put("size", size + "");
            attachMap.put("fattachmentpanel", "paperattachment");
            attachMap.put("entityNum", entityId);
            attachMap.put("billPkId", String.valueOf(entryRow.getLong("id")));
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachMap.put("visible", "1111");
            attachDataList.add(attachMap);
            return attachDataList;
        }
        return null;
    }

    private static StringBuffer getUid() {
        StringBuffer uid = new StringBuffer("rc-upload-");
        uid.append(new Date().getTime());
        uid.append("-");
        int index = RandomUtils.nextInt((int)1, (int)10);
        uid.append(index);
        return uid;
    }

    private FlexPanelAp getItemFlex(String uniqKey) {
        return ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(uniqKey).setShrink(0).setGrow(0).setPaddingTop("12px")).setPaddingBottom("12px")).setBorderBottom("0.5px_solid_#E5E5E5")).setDirection("column").build();
    }

    private FlexPanelAp getBaseRowFlex(String key) {
        return ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key).setShrink(1).setGrow(1).setWidth("100%").setAlignSelf("center").setDirection("row").setAlignItems("center").setWrap(false).setPaddingLeft("12px")).setPaddingRight("12px")).build();
    }

    public void onGetControl(OnGetControlArgs e) {
        String uid;
        super.onGetControl(e);
        OperationContext operationContext = OperationContext.get();
        if (operationContext != null && "permissionQuery".equals(operationContext.getOpMethod()) && !HRStringUtils.isBlank((CharSequence)(uid = this.getPageCache().get(operationContext.getOpKey())))) {
            e.setControl(null);
            ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("uid", uid);
            data.put("previewPermission", true);
            data.put("downloadPermission", true);
            clientViewProxy.invokeControlMethod(operationContext.getOpKey(), "setAttachmentPermission", new Object[]{data});
        }
    }
}

