/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.mobile;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.business.utils.HLCMExceptionUtils;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import kd.hr.hlcm.common.enums.EmpCompSignStatusEnum;
import kd.hr.hlcm.common.utils.ComboUtils;

public class SignContractInfoPlugin
extends AbstractMobBillPlugIn {
    private static final Log LOGGER = LogFactory.getLog(SignContractInfoPlugin.class);
    private static final String UNIFIEDCODE = "unifiedcode";
    private static final String REPRESENTATIVE = "representative";
    private static final String ADDRESS = "address";
    private static final String COMPANYPHONE = "companyphone";
    private static final String CONTACTNUMBER = "contactnumber";
    private static final String PERIOD_UNIT = "periodunit";
    private DynamicObject signBill;
    private boolean isMultiFile;

    private void init(FormShowParameter formShowParameter) {
        String id = (String)formShowParameter.getCustomParam("id");
        if (this.signBill == null) {
            this.signBill = ISignManageService.getInstance().loadCurUserSignBill(id);
            this.isMultiFile = this.signBill.getDynamicObjectCollection("entryentity").size() > 1;
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formShowParameter.setHasRight(true);
        this.init(formShowParameter);
        if (this.isMultiFile) {
            String caption = ResManager.loadKDString((String)"\u5f85\u7b7e\u7f72\u52b3\u52a8\u5408\u540c\u548c\u534f\u8bae", (String)"SignContractInfoPlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            formShowParameter.setCaption(caption);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"tosign", "viewcontract"});
        try {
            this.init(formView.getFormShowParameter());
            if (this.isMultiFile) {
                formView.setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
                formView.setVisible(Boolean.TRUE, new String[]{"flexpanelap81"});
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.InContainer);
                openStyle.setTargetKey("flexpanelap81");
                showParameter.setOpenStyle(openStyle);
                showParameter.setFormId("hlcm_contractinformation");
                showParameter.setCustomParam("id", (Object)this.signBill.getLong("id"));
                showParameter.setCustomParam("isToSign", (Object)Boolean.TRUE.toString());
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
                formView.setVisible(Boolean.FALSE, new String[]{"flexpanelap81"});
            }
            String businessStatus = this.signBill.getString("businessstatus");
            DynamicObject contract = (DynamicObject)this.signBill.getDynamicObjectCollection("entryentity").get(0);
            String preSignDocUrl = contract.getString("presigndocurl");
            long count = this.signBill.getDynamicObjectCollection("entryentity").stream().filter(contractTemplate -> !HRStringUtils.equals((String)contractTemplate.getString("entryempsignstatus"), (String)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue())).count();
            this.setLabelText("count", count);
            DynamicObject actualSignCompany = this.signBill.getDynamicObject("actualsigncompany");
            this.setLabelText("actualsigncompany", actualSignCompany.getString("name"));
            this.setLabelText(UNIFIEDCODE, actualSignCompany.getString(UNIFIEDCODE));
            this.setLabelText(REPRESENTATIVE, actualSignCompany.getString(REPRESENTATIVE));
            this.setLabelText(ADDRESS, actualSignCompany.getString(ADDRESS));
            this.setLabelText(COMPANYPHONE, actualSignCompany.getString(CONTACTNUMBER));
            this.setLabelText("empname", this.signBill.getString("empname"));
            DynamicObject cardType = this.signBill.getDynamicObject("cardtype");
            this.setLabelText("cardtype", HRObjectUtils.isEmpty((Object)cardType) ? "-" : cardType.getString("name"));
            this.setLabelText("cardnumber", this.signBill.getString("cardnumber"));
            this.setLabelText("householdregister", this.signBill.getString("householdregister"));
            this.setLabelText("residentialaddress", this.signBill.getString("residentialaddress"));
            this.setLabelText("empphone", this.signBill.getString("empphone"));
            this.setLabelText("periodtype", this.signBill.getDynamicObject("periodtype").getString("name"));
            this.setLabelText("startdate", this.signBill.getDate("startdate"));
            Date endDate = this.signBill.getDate("enddate");
            this.setLabelText("enddate", endDate);
            this.setLabelText(PERIOD_UNIT, ComboUtils.getComboOptionLocaleName((DynamicObject)this.signBill, (String)PERIOD_UNIT));
            if (endDate != null) {
                BigDecimal period = this.signBill.getBigDecimal("period").setScale(1, RoundingMode.HALF_DOWN);
                if (period.compareTo(BigDecimal.ZERO) == 0) {
                    this.setLabelText("period", "0");
                } else {
                    this.setLabelText("period", period);
                }
            } else {
                formView.setVisible(Boolean.FALSE, new String[]{PERIOD_UNIT});
                this.setLabelText("period", "-");
            }
            boolean toSignVisible = HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.PSIGN.getCombKey()) || HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.CONFIRM.getCombKey()) && !HRStringUtils.isEmpty((String)preSignDocUrl);
            LOGGER.info("SignContractInfoPlugin#businessStatus={},toSignVisible={}", (Object)businessStatus, (Object)toSignVisible);
            if (toSignVisible) {
                formView.setVisible(Boolean.TRUE, new String[]{"tosign"});
                return;
            }
            boolean viewContractVisible = contract.getBoolean("isdone") && !HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.STOP.getCombKey());
            formView.setVisible(Boolean.valueOf(viewContractVisible), new String[]{"viewcontract"});
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            formView.setVisible(Boolean.FALSE, new String[]{"tosign", "viewcontract"});
            if (exception instanceof KDException) {
                formView.showErrorNotification(exception.getMessage());
            }
            formView.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SignContractInfoPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String id = (String)formShowParameter.getCustomParam("id");
        this.init(formShowParameter);
        String businessStatus = this.signBill.getString("businessstatus");
        DynamicObjectCollection entryEntity = this.signBill.getDynamicObjectCollection("entryentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        DynamicObject contract = (DynamicObject)entryEntity.get(0);
        boolean attachmentVisible = contract.getBoolean("isdone") && !HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.STOP.getCombKey());
        this.getView().setVisible(Boolean.valueOf(attachmentVisible), new String[]{"attachmentpanelap"});
        if (attachmentVisible) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
            AttachmentUtils.bindAttachment((AttachmentPanel)attachmentPanel, (String)"hlcm_signattachment", (String)id);
        }
        try {
            if (HRStringUtils.equals((String)"4", (String)this.signBill.getString("businesstype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
            }
        }
        catch (Exception exe) {
            LOGGER.error("setFlexInvisible.fail", (Throwable)exe);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        IFormView formView = this.getView();
        LOGGER.info("SignContractInfoPlugin#operateKey={}", (Object)operateKey);
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        this.init(formShowParameter);
        String id = (String)formShowParameter.getCustomParam("id");
        String businessStatus = this.signBill.getString("businessstatus");
        DynamicObjectCollection entryEntity = this.signBill.getDynamicObjectCollection("entryentity");
        if (HRStringUtils.equals((String)operateKey, (String)"tosign")) {
            DynamicObject contract = (DynamicObject)entryEntity.get(0);
            String contractNo = contract.getString("contractno");
            if (HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.PSIGN.getCombKey())) {
                try {
                    if (this.isNewContract(entryEntity) || !IHRCSService.getInstance().authStatus(this.signBill, contract)) {
                        ISignManageService.getInstance().empBatchSign(formView, this.signBill);
                    } else if (this.isSigned(entryEntity)) {
                        formView.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u5df2\u5b8c\u6210\u7b7e\u7f72\uff0c\u65e0\u9700\u91cd\u590d\u7b7e\u7f72\u3002", (String)"SignContractInfoPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                        formView.setVisible(Boolean.FALSE, new String[]{"tosign"});
                        formView.setVisible(Boolean.TRUE, new String[]{"viewcontract"});
                    } else if (this.isMultiFile) {
                        ISignManageService.getInstance().empBatchSign(formView, this.signBill);
                    } else {
                        boolean signStatus = IHRCSService.getInstance().signStatus(this.signBill, contract, contractNo);
                        if (!signStatus) {
                            SignRespParam signRespParam = IHRCSService.getInstance().getHandSignUrl(this.signBill, contractNo);
                            formView.openUrl(signRespParam.getHandSignUrl());
                        }
                    }
                }
                catch (Exception exp) {
                    LOGGER.error("call IHRCSService error", (Throwable)exp);
                    formView.showErrorNotification(HLCMExceptionUtils.handleException((Exception)exp));
                }
            } else if (HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.CONFIRM.getCombKey())) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SignContractInfoPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            } else if (HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.STOP.getCombKey())) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u7b7e\u7f72\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u8bf7\u8054\u7cfbHR\u8fdb\u884c\u5904\u7406\uff0c\u9875\u9762\u5237\u65b0\u4e2d\u3002", (String)"SignContractInfoPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                formView.invokeOperation("refresh");
            } else {
                formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u7684\u7b7e\u7f72\u6d41\u7a0b\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u9875\u9762\u5237\u65b0\u4e2d\u3002", (String)"SignContractInfoPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                formView.invokeOperation("refresh");
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"viewcontract")) {
            String attachmentUrl = ((DynamicObject)entryEntity.get(0)).getString("presigndocurl");
            FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
            String url = attachFileServiceExt.getRealPath(attachmentUrl);
            String fullUrl = UrlService.getAttachmentFullUrl((String)url);
            String downloadRealUrl = ProxyUtils.attachmentDownloadRealUrl((String)fullUrl);
            this.getView().openUrl(downloadRealUrl);
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
            AttachmentUtils.bindAttachment((AttachmentPanel)attachmentPanel, (String)"hlcm_signattachment", (String)id);
        } else {
            LOGGER.warn("operateKey|{}", (Object)operateKey);
        }
    }

    private void setLabelText(String labelName, Object text) {
        Label label = (Label)this.getView().getControl(labelName);
        if (label == null) {
            return;
        }
        if (HRObjectUtils.isEmpty((Object)text)) {
            label.setText("-");
            return;
        }
        if (text instanceof Date) {
            label.setText(HRDateTimeUtils.formatDate((Date)((Date)text)));
        } else {
            label.setText(text.toString());
        }
    }

    private boolean isNewContract(DynamicObjectCollection entryEntity) {
        for (DynamicObject row : entryEntity) {
            if (!HRStringUtils.isNotEmpty((String)row.getString("contractno"))) continue;
            return false;
        }
        return true;
    }

    private boolean isSigned(DynamicObjectCollection entryEntity) {
        for (DynamicObject row : entryEntity) {
            if (HRStringUtils.equals((String)EmpCompSignStatusEnum.SIGN_SUCCESSED.getValue(), (String)row.getString("entryempsignstatus"))) continue;
            return false;
        }
        return true;
    }
}

