/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.mobile.privacy;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.privacy.IPrivacyService;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import kd.hr.hlcm.common.utils.ServicePageUtil;
import kd.hr.hlcm.formplugin.mobile.privacy.HlcmPrivacyServiceHelper;

public class HlcmPrivacyMobilePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HlcmPrivacyMobilePlugin.class);
    private static final String OPERATE_CONFIRM = "donothing_confirm";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setHasRight(true);
    }

    public void afterBindData(EventObject eve) {
        super.afterBindData(eve);
        HlcmPrivacyServiceHelper.setContent(this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (OPERATE_CONFIRM.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            Map responseMap;
            IFormView formView = this.getView();
            Tuple queryPrivacyResult = IPrivacyService.getInstance().queryPrivacy("getPrivacySigningList");
            LOGGER.info("HlcmPrivacyMobilePlugin#queryPrivacyResult={}", JSON.toJSON((Object)queryPrivacyResult));
            if (((Boolean)queryPrivacyResult.item1).booleanValue() && "1".equals((responseMap = HRJSONUtils.convertJSONObjectToMap((Object)queryPrivacyResult.item2)).get("isAgree"))) {
                this.switchPageHandle();
                return;
            }
            Tuple<Boolean, Object> result = HlcmPrivacyServiceHelper.signPrivacy(formView);
            LOGGER.info("HlcmPrivacyMobilePlugin#result={}", JSON.toJSON(result));
            if (((Boolean)result.item1).booleanValue()) {
                this.switchPageHandle();
            }
        }
    }

    private void switchPageHandle() {
        IFormView formView = this.getView();
        String id = (String)formView.getFormShowParameter().getCustomParam("id");
        DynamicObject signBill = ISignManageService.getInstance().loadCurUserSignBill(id);
        String businessStatus = signBill.getString("businessstatus");
        String formId = "hlcm_signcontractinfo";
        if (HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.CONFIRM.getCombKey())) {
            formId = "hlcm_empinfoconfirm";
        }
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        customParams.put("id", id);
        ServicePageUtil.showMobileForm((IFormView)formView, (String)formId, (ShowType)ShowType.Floating, customParams);
    }
}

