/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class ResultPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(ResultPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String successPerson = (String)formShowParameter.getCustomParam("successperson");
        String successOperation = (String)formShowParameter.getCustomParam("successoperation");
        String failPerson = (String)formShowParameter.getCustomParam("failperson");
        String failOperation = (String)formShowParameter.getCustomParam("failoperation");
        Label successPersonLabel = (Label)this.getView().getControl("successperson");
        successPersonLabel.setText(successPerson);
        Label successOperationLabel = (Label)this.getView().getControl("successoperation");
        successOperationLabel.setText(successOperation);
        Label failPersonLabel = (Label)this.getView().getControl("failperson");
        failPersonLabel.setText(failPerson);
        Label failOperationLabel = (Label)this.getView().getControl("failoperation");
        failOperationLabel.setText(failOperation);
        Boolean isShowCommentFlag = (Boolean)formShowParameter.getCustomParam("isShowCommentFlag");
        this.getView().setVisible(isShowCommentFlag, new String[]{"commenttag"});
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"viewdetails"});
    }

    public void click(EventObject evt) {
        Control control;
        Object source = evt.getSource();
        if (source instanceof Control && (control = (Control)source).getKey().equals("viewdetails")) {
            this.exportExcel();
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataList = new ArrayList();
        try {
            headDataList = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException iOException) {
            LOGGER.error((Throwable)iOException);
        }
        String exportExcelUrl = null;
        try {
            exportExcelUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataList);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportExcelUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportExcelUrl);
        }
    }
}

