/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.utils.SignListPermissionUtils;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.utils.DateUtil;
import kd.hr.hlcm.formplugin.signmgt.SignActivityHelper;

public class SignActivityComListPlugin
extends HRDataBaseList {
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("deadline asc,signapply.signeddate asc,processstatus asc");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject activityDy = this.getActivityDy(primaryKeyValue);
        DynamicObject signApply = activityDy.getDynamicObject("signapply");
        if (signApply == null) {
            return;
        }
        Object pkValue = signApply.getPkValue();
        DynamicObject signDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_signmanagebase", (String)"empname,protocoltype", (Object)pkValue);
        if (signDy == null) {
            return;
        }
        String protocolType = signDy.getString("protocoltype");
        String name = signDy.getString("empname");
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(pkValue);
        String caption = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7b7e\u7f72\uff1a%2$s", (String)"SignActivityComListPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ProtocolTypeEnum.loadKDStringByKey((String)protocolType), name);
        billShowParameter.setCaption(caption);
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        String formIdByListFormId = SignTabEnum.getFormIdByListFormId((String)billFormId);
        billShowParameter.setFormId(formIdByListFormId);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCustomParam("activity", primaryKeyValue);
        String pageId = String.format(Locale.ROOT, "%s_%s_%d_%d", this.getView().getPageId(), billShowParameter.getFormId(), primaryKeyValue.hashCode(), RequestContext.get().getCurrUserId());
        billShowParameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("stopsign".equals(operateKey)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            int size = selectedRows.size();
            if (size == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u7ec8\u6b62\u7b7e\u7f72\u7684\u5355\u636e\u3002", (String)"SignActivityComListPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (size != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u7ec8\u6b62\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u7ec8\u6b62\u7b7e\u7f72\u7684\u5355\u636e\u3002", (String)"SignActivityComListPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                String proStatus;
                Object primaryKey = selectedRows.get(0).getPrimaryKeyValue();
                String billFormId = listView.getBillFormId();
                String tableName = SignTabEnum.getTableNameByListFormId((String)billFormId);
                if (!SignListPermissionUtils.checkStopSignPermission((String)billFormId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u7ec8\u6b62\u7b7e\u7f72\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignActivityComListPlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[]{tableName}));
                    args.setCancel(true);
                    return;
                }
                if (!SignListPermissionUtils.checkStopSignDataRulePermission((String)billFormId, (Object)primaryKey)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u7ec8\u6b62\u7b7e\u7f72\u201c%s\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignActivityComListPlugin_6", (String)"hr-hlcm-formplugin", (Object[])new Object[]{tableName}));
                    args.setCancel(true);
                    return;
                }
                DynamicObject activityDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_activity", (String)"processstatus", (Object)primaryKey);
                if (activityDy != null && (HRStringUtils.equals((String)"1", (String)(proStatus = activityDy.getString("processstatus"))) || HRStringUtils.equals((String)"2", (String)proStatus))) {
                    String comboStr = SignActivityHelper.getComboStr(this.getView(), proStatus);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u53ef\u7ec8\u6b62\u7b7e\u7f72\u3002", (String)"SignActivityComListPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[]{comboStr}));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isNotEmpty;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean bl = isNotEmpty = !HRObjectUtils.isEmpty((Object)operationResult);
        if (HRStringUtils.equals((String)"stopsign", (String)operateKey) && isNotEmpty && operationResult.isSuccess()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hlcm_stopsign");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "stop");
            formShowParameter.setCloseCallBack(closeCallBack);
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject activityDy = this.getActivityDy(primaryKeyValue);
            DynamicObject signApply = activityDy.getDynamicObject("signapply");
            if (signApply == null) {
                return;
            }
            Object pkValue = signApply.getPkValue();
            formShowParameter.setCustomParam("id", pkValue);
            formShowParameter.setCustomParam("activity", primaryKeyValue);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)"stop", (String)actionId) && returnData != null && HRStringUtils.equals((String)"success", (String)returnData.toString())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u7b7e\u7f72\u6210\u529f\u3002", (String)"SignActivityComListPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"remaindays")) {
            DynamicObject rowDy = event.getRowData();
            Date deadLine = rowDy.getDate("deadline");
            String processStatus = rowDy.getString("processstatus");
            HashSet remainDaysShowSets = Sets.newHashSet((Object[])new String[]{"0", "3"});
            if (deadLine != null && remainDaysShowSets.contains(processStatus)) {
                event.setFormatValue((Object)DateUtil.getDateDiff((Date)new Date(), (Date)deadLine));
            } else {
                event.setFormatValue((Object)"");
            }
        }
    }

    private DynamicObject getActivityDy(Object primaryKeyValue) {
        return HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_activity", (String)"signapply,processstatus", (Object)primaryKeyValue);
    }
}

